# Misc. Talks

The following video provides more detail about the graph-based
approaches used in *TextRank*, as well as trade-offs, benchmarks,
comparisons with other algorithms, and so on:

["Single and Multiple Document Summarization with Graph-based Ranking Algorithms"](https://www.youtube.com/watch?v=NvpCFJ0dA8A)  
**Rada Mihalcea**  
Microsoft Research on *YouTube* (2016-09-05)

For a general overview of this Python library and its usage, see:

["Graph-Based Data Science"](https://derwen.ai/s/kcgh)  
**Paco Nathan**  
Derwen (2021-01-30)

["PyTextRank"](https://derwen.ai/s/h88s)  
**Paco Nathan**  
[*IIT Patna*](http://www.iitp.ac.in/~ai-nlp-ml/nlp-connect.html) (2020-02-21)  
[video](https://youtu.be/ZwlPsdRDtMI)

For related course materials and training, please check for calendar
updates in the article
["Natural Language Processing in Python"](https://medium.com/derwen/natural-language-processing-in-python-832b0a99791b).


## Citations

In general, see listings on 
[Google Scholar](https://scholar.google.com/scholar?q=related:5tl6J4xZlCIJ:scholar.google.com/&scioq=&hl=en&as_sdt=0,5)
for citations of this work.

["Knowledge Graph-based Core Concept Identification in Learning Resources"](https://books.google.com/books?id=SM96DwAAQBAJ&lpg=PA42&ots=T91TURU84E&dq=pytextrank&pg=PA36#v=onepage&q=pytextrank&f=false)  
**Rubén Manrique**, **Christian Grevisse**, **Olga Mariño**, **Steffen Rothkugel**  
*8th Joint International Conference, JIST 2018* (2018-11-26)


## Other articles

["Use TextRank to Extract Most Important Sentences in Article"](https://medium.com/the-artificial-impostor/use-textrank-to-extract-most-important-sentences-in-article-b8efc7e70b4)  
**Ceshine Lee**  
*The Artificial Impostor* (2018-12-09)

["Automatic Keyword extraction using TextRank in Python"](https://www.thinkinfi.com/2018/09/automatic-keyword-extraction-using_30.html)  
**Anindya Naskar**  
*ThinkInfi* (2018-09-30)

[*Practical Data Analysis: Using Python & Open Source Technology*](https://books.google.com/books?id=VrFmDwAAQBAJ&lpg=PT152&ots=amch1bK3dL&dq=pytextrank&pg=PT149#v=onepage&q=pytextrank&f=false)  
**Dhiraj Bhuyan** (2018-07)

["Beyond bag of words: Using PyTextRank to find Phrases and Summarize text"](https://medium.com/@aneesha/beyond-bag-of-words-using-pytextrank-to-find-phrases-and-summarize-text-f736fa3773c5)  
**Aneesha Bakharia**  
*Medium* (2017-10-11)

["Text Summarization in Python: Extractive vs. Abstractive techniques revisited"](https://rare-technologies.com/text-summarization-in-python-extractive-vs-abstractive-techniques-revisited/)  
**Pranay Mathur**, **Aman Gill**, **Aayush Yadav**  
*RaRe Technologies* (2017-04-05)


## Provenance

The `spaCy` pipeline version of **PyTextRank** was originally written
very late one evening near the beach in A Coruña, Galica, while the
author was teaching an NLP seminar at the university during 
[Big Data Coruña 2019](https://www.citic-research.org/actividades/big-data-coruna-2019.htm).

What a beautiful city, there within ancient Celtic lands, guarded by
the [Tower of Hercules](https://en.wikipedia.org/wiki/Tower_of_Hercules).
It's more than a bit reminiscent of Santa Cruz, California
– or perhaps the other way around.

Many thanks to Professor [Amparo Alonso Betanzos](https://pdi.udc.es/es/File/Pdi/AF2AF),
*Catedrática de Ciencias de la Computación e Inteligencia Artificial de la UDC*,
and to the [Universidade da Coruña](https://www.udc.es/).
