# Glossary


## – A –

### abstractive summarization
> Generating a short, concise summary which captures salient ideas of the source text, potentially using new phrases and sentences that may not appear in the source.





## – C –

### cloud
See also: [cloud computing](#cloud-computing)


### cloud computing
> The on-demand availability of computing resources over the Internet without direct active management by the user, often paid for on a short-term basis, giving the illusion of infinite computing resources available and thereby eliminating the need to plan far ahead for provisioning.



References:

  * <a href="http://www.wikidata.org/entity/Q483639" target="_blank">http://www.wikidata.org/entity/Q483639</a>
  * <a href="http://id.loc.gov/authorities/subjects/sh2008004883" target="_blank">http://id.loc.gov/authorities/subjects/sh2008004883</a>
  * <a href="https://csrc.nist.gov/publications/detail/sp/800-145/final" target="_blank">https://csrc.nist.gov/publications/detail/sp/800-145/final</a>
  * <a href="https://rise.cs.berkeley.edu/blog/a-berkeley-view-on-serverless-computing/" target="_blank">https://rise.cs.berkeley.edu/blog/a-berkeley-view-on-serverless-computing/</a>



### computable content
> Interactive learning materials which leverage remote computation, e.g., Jupyter notebooks.



References:

  * <a href="https://youtu.be/EPftGvsXonc" target="_blank">https://youtu.be/EPftGvsXonc</a>
  * <a href="https://www.wolfram.com/cdf/" target="_blank">https://www.wolfram.com/cdf/</a>
  * <a href="https://www.slideshare.net/pacoid/computable-content" target="_blank">https://www.slideshare.net/pacoid/computable-content</a>



### coreference resolution
> Clustering mentions within a text that refer to the same underlying entities.



References:

  * <a href="https://paperswithcode.com/task/coreference-resolution" target="_blank">https://paperswithcode.com/task/coreference-resolution</a>
  * <a href="http://www.wikidata.org/entity/Q63087" target="_blank">http://www.wikidata.org/entity/Q63087</a>
  * <a href="http://nlpprogress.com/english/coreference_resolution.html" target="_blank">http://nlpprogress.com/english/coreference_resolution.html</a>



## – D –

### DL
See also: [deep learning](#deep-learning)


### data science
> An interdisciplinary field which emerged from industry not academia, focused on deriving insights from data, emphasizing how to leverage curiosity and domain expertise, and applying increasingly advanced mathematics for novel business cases in response to surges in data rates and compute resources.



References:

  * <a href="https://ischoolonline.berkeley.edu/data-science/what-is-data-science/" target="_blank">https://ischoolonline.berkeley.edu/data-science/what-is-data-science/</a>
  * <a href="https://hbr.org/2018/11/curiosity-driven-data-science" target="_blank">https://hbr.org/2018/11/curiosity-driven-data-science</a>
  * <a href="https://community.ibm.com/community/user/datascience/blogs/paco-nathan/2019/03/04/what-is-data-science" target="_blank">https://community.ibm.com/community/user/datascience/blogs/paco-nathan/2019/03/04/what-is-data-science</a>
  * <a href="https://projecteuclid.org/euclid.aoms/1177704711" target="_blank">https://projecteuclid.org/euclid.aoms/1177704711</a>
  * <a href="http://www.wikidata.org/entity/Q2374463" target="_blank">http://www.wikidata.org/entity/Q2374463</a>



### data strategy
> The tools, processes, and practices that define how to manage and leverage data to make informed decisions.





### deep learning
> A family of machine learning methods based on artificial neural networks which use representation learning.



References:

  * <a href="https://en.wikipedia.org/wiki/Deep_learning" target="_blank">https://en.wikipedia.org/wiki/Deep_learning</a>
  * <a href="http://www.wikidata.org/entity/Q197536" target="_blank">http://www.wikidata.org/entity/Q197536</a>



## – E –

### eigenvector centrality
> Measuring the influence of a node within a network.



References:

  * <a href="http://www.wikidata.org/entity/Q28401090" target="_blank">http://www.wikidata.org/entity/Q28401090</a>
  * <a href="https://demonstrations.wolfram.com/NetworkCentralityUsingEigenvectors/" target="_blank">https://demonstrations.wolfram.com/NetworkCentralityUsingEigenvectors/</a>



### entity linking
> Recognizing named entities within a text, then disambiguating them by linking to specific contexts in a knowledge graph.


Broader:

  * [named entity recognition](#named-entity-recognition)
  * [knowledge graph](#knowledge-graph)


References:

  * <a href="http://www.wikidata.org/entity/Q17012245" target="_blank">http://www.wikidata.org/entity/Q17012245</a>
  * <a href="https://paperswithcode.com/task/entity-linking" target="_blank">https://paperswithcode.com/task/entity-linking</a>
  * <a href="http://nlpprogress.com/english/entity_linking.html" target="_blank">http://nlpprogress.com/english/entity_linking.html</a>



### extractive summarization
> Summarizing the source text by identifying a subset of the sentences as the most important excerpts, then generating a sequence of them verbatim.





## – G –

### graph algorithms
> A family of algorithms that operation on graphs for network analysis, measurement, ranking, partitioning, and other methods that leverage graph theory.



References:

  * <a href="http://id.loc.gov/authorities/subjects/sh2002004605" target="_blank">http://id.loc.gov/authorities/subjects/sh2002004605</a>
  * <a href="https://networkx.org/documentation/stable/reference/algorithms/index.html" target="_blank">https://networkx.org/documentation/stable/reference/algorithms/index.html</a>



## – K –

### KG
See also: [knowledge graph](#knowledge-graph)


### KGC
See also: [knowledge graph conference](#knowledge-graph-conference)


### knowledge graph
> A knowledge base that uses a graph-structured data model, representing and annotating interlinked descriptions of entities, with an overlay of semantic metadata.



References:

  * <a href="https://www.poolparty.biz/what-is-a-knowledge-graph/" target="_blank">https://www.poolparty.biz/what-is-a-knowledge-graph/</a>
  * <a href="http://www.wikidata.org/entity/Q33002955" target="_blank">http://www.wikidata.org/entity/Q33002955</a>



### knowledge graph conference
> Founded in 2019 at Columbia University, The Knowledge Graphs Conference is emerging as the premiere source of learning around knowledge graph technologies. We believe knowledge graphs are an underutilized yet essential force for solving complex societal challenges like climate change, democratizing access to knowledge and opportunity, and capturing business value made possible by the AI revolution.





## – L –

### language model
> A statistical model used for predicting the next word or character within a document.


Broader:

  * [natural language](#natural-language)
  * <a href='https://derwen.ai/d/machine_learning' target='_blank'>https://derwen.ai/d/machine_learning</a>


References:

  * <a href="http://www.wikidata.org/entity/Q3621696" target="_blank">http://www.wikidata.org/entity/Q3621696</a>
  * <a href="https://paperswithcode.com/task/language-modelling" target="_blank">https://paperswithcode.com/task/language-modelling</a>
  * <a href="http://nlpprogress.com/english/language_modeling.html" target="_blank">http://nlpprogress.com/english/language_modeling.html</a>



### lemma graph
> A graph data structure used to represent links among phrase extracted from a source text, during the operation of the TextRank algorithm.

Described in: [[mihalcea04textrank]](../biblio/#mihalcea04textrank)




## – N –

### NER
See also: [named entity recognition](#named-entity-recognition)


### NLP
See also: [natural language](#natural-language)


### named entity recognition
> Extracting mentions of *named entities* from unstructured text, then annotating them with pre-defined categories.



References:

  * <a href="http://www.wikidata.org/entity/Q403574" target="_blank">http://www.wikidata.org/entity/Q403574</a>
  * <a href="http://nlpprogress.com/english/named_entity_recognition.html" target="_blank">http://nlpprogress.com/english/named_entity_recognition.html</a>
  * <a href="https://paperswithcode.com/task/named-entity-recognition-ner" target="_blank">https://paperswithcode.com/task/named-entity-recognition-ner</a>



### natural language
> Intersection of computer science and linguistics, used to leverage data in the form of text, speech, and images to identify structure and meaning. Also used for enabling people and computer-based agents to interact using natural language.



References:

  * <a href="http://www.wikidata.org/entity/Q30642" target="_blank">http://www.wikidata.org/entity/Q30642</a>
  * <a href="http://id.loc.gov/authorities/subjects/sh88002425" target="_blank">http://id.loc.gov/authorities/subjects/sh88002425</a>
  * <a href="https://plato.stanford.edu/entries/computational-linguistics/" target="_blank">https://plato.stanford.edu/entries/computational-linguistics/</a>



## – P –

### personalized pagerank
> Using the *personalized teleportation behaviors* originally described for the PageRank algorithm to focus ranked results within a neighborhood of the graph, given a set of nodes as input.

Described in: [[page1998]](../biblio/#page1998), [[gleich15]](../biblio/#gleich15)




### phrase extraction
> Selecting representative phrases from a document as its characteristic entities; in contrast to *keyword* analysis.





## – R –

### RL
See also: [reinforcement learning](#reinforcement-learning)


### reinforcement learning
> Optimal control theory mixed with deep learning where software agents learn to take actions within an environment and make sequences of decisions to maximize a cumulative reward -- typically stated in terms of markov decision process -- finding a balance between exploration (uncharted territory) and exploitation (current knowledge). Generally a reverse engineering of various psychological learning processes.



References:

  * <a href="https://docs.ray.io/en/master/rllib-models.html" target="_blank">https://docs.ray.io/en/master/rllib-models.html</a>
  * <a href="http://www.wikidata.org/entity/Q830687" target="_blank">http://www.wikidata.org/entity/Q830687</a>
  * <a href="http://id.loc.gov/authorities/subjects/sh92000704" target="_blank">http://id.loc.gov/authorities/subjects/sh92000704</a>



## – S –

### semantic relations
> Associations that exist between the meanings of phrases.





### stop words
> Words to be filtered out during natural language processing.



References:

  * <a href="http://www.wikidata.org/entity/Q80735" target="_blank">http://www.wikidata.org/entity/Q80735</a>
  * <a href="http://id.loc.gov/authorities/subjects/sh85046249" target="_blank">http://id.loc.gov/authorities/subjects/sh85046249</a>



### summarization
> Producing a shorter version of one or more documents, while preserving most of the input&#39;s meaning.



References:

  * <a href="http://nlpprogress.com/english/summarization.html" target="_blank">http://nlpprogress.com/english/summarization.html</a>
  * <a href="http://www.wikidata.org/entity/Q1394144" target="_blank">http://www.wikidata.org/entity/Q1394144</a>



## – T –

### text summarization
See also: [summarization](#summarization)


### textgraphs
> Use of graph algorithms for NLP, based on a graph representation of a source text.


Broader:

  * [natural language](#natural-language)
  * [graph algorithms](#graph-algorithms)


References:

  * <a href="http://www.wikidata.org/entity/Q18388823" target="_blank">http://www.wikidata.org/entity/Q18388823</a>
  * <a href="http://www.gabormelli.com/RKB/Text_Graph" target="_blank">http://www.gabormelli.com/RKB/Text_Graph</a>
  * <a href="http://www.textgraphs.org/" target="_blank">http://www.textgraphs.org/</a>



### transformers
> A family of deep learning models, mostly used in NLP, which adopts the mechanism of *attention* to weigh the influence of different parts of the input data.


Broader:

  * [language model](#language-model)
  * [deep learning](#deep-learning)


References:

  * <a href="http://www.wikidata.org/entity/Q85810444" target="_blank">http://www.wikidata.org/entity/Q85810444</a>
  * <a href="https://paperswithcode.com/methods/category/transformers" target="_blank">https://paperswithcode.com/methods/category/transformers</a>


