import React from "react";
import { Routes, Route, Navigate } from "react-router-dom";
import { Header, Footer } from "./components";
import {
  Home,
  Search,
  Favorites,
  Login,
  Register,
  Viewer,
  About,
  Account,
  Admin,
  Changes
} from "./pages";
import { useGlobal } from "./context";

const App = (props) => {
  const { theme, displayFooter, dimensions } = useGlobal();

  return (
    <div
      data-theme={theme === "light" ? "light" : "dark"}
      style={{
        overflowY: displayFooter || !dimensions.showPdfViewer ? "auto" : "",
        display: "flex",
        flexDirection: "column",
        height: `calc(100vh)`
      }}
    >
      <Header visible={true} />
      <Routes>
        <Route index element={<Home />} />
        <Route path="favorites" element={<Favorites />} />
        <Route path="about" element={<About />} />
        <Route path="login" element={<Login />} />
        <Route path="register" element={<Register />} />
        <Route path="account" element={<Account />} />
        <Route path="admin" element={<Admin />} />
        <Route path="changes" element={<Changes />} />
        <Route path="search" element={<Search />} />
        <Route path="viewer" element={<Viewer />} />
        <Route path="*" element={<Navigate to="/" replace={true} />} />
      </Routes>
      <Footer style={{ marginTop: "auto" }} visible={displayFooter} />
    </div>
  );
};

export default App;
