﻿using System;
using System.IO;
using System.Linq;
using NUnit.Framework;
using Xamarin.UITest;
using Xamarin.UITest.Android;
using Xamarin.UITest.Queries;

namespace Cheesesquare.UITests
{
    [TestFixture]
    public class Tests
    {
        AndroidApp app;

        [SetUp]
        public void BeforeEachTest ()
        {
            app = ConfigureApp.Android
                .ApkFile ("app.apk")
                .PreferIdeSettings ()
                .StartApp ();
        }

        [Test]
        public void ClickingHamburgerShouldRevealDrawer ()
        {            
            app.Screenshot ("Launch");
            app.Tap(t => t.Marked("Navigate up"));
            app.WaitForElement(t => t.Text("Discussion"));
            app.Screenshot ("Tap Hamburger");
        }

        [Test]
        public void ClickingFloatingActionButtonShouldDisplaySnackbar ()
        {
            app.Screenshot ("Launch");
            app.Tap (q => q.Id ("fab"));
            app.Screenshot ("Snackbar");
        }

        [Test]
        public void ClickingItemShouldRevealDetails ()
        {
            app.Screenshot ("Launch");
            app.Tap (q => q.Id ("text1"));
            app.Screenshot ("Tap Item");
            app.WaitForElement (q => q.Text ("Info"));
            app.Screenshot ("Details Page");
        }

        //[Test]
        public void Repl ()
        {
            app.Repl ();
        }
    }
}

