/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.location.zzm;

public final class LocationRequest
extends zza
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    int mPriority;
    long zzbjU;
    long zzbjV;
    boolean zzaWy;
    long zzbjE;
    int zzbjW;
    float zzbjX;
    long zzbjY;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzm();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mPriority = 102;
        this.zzbjU = 3600000L;
        this.zzbjV = 600000L;
        this.zzaWy = false;
        this.zzbjE = Long.MAX_VALUE;
        this.zzbjW = Integer.MAX_VALUE;
        this.zzbjX = 0.0f;
        this.zzbjY = 0L;
    }

    public LocationRequest setPriority(int n) {
        LocationRequest.zzkk(n);
        this.mPriority = n;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long l) {
        LocationRequest.zzV(l);
        this.zzbjU = l;
        if (!this.zzaWy) {
            this.zzbjV = (long)((double)this.zzbjU / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.zzbjU;
    }

    public LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zzV(l);
        this.zzbjY = l;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.zzbjY;
        if (l < this.zzbjU) {
            l = this.zzbjU;
        }
        return l;
    }

    public LocationRequest setFastestInterval(long l) {
        LocationRequest.zzV(l);
        this.zzaWy = true;
        this.zzbjV = l;
        return this;
    }

    public long getFastestInterval() {
        return this.zzbjV;
    }

    public LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zzbjE = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zzbjE < 0L) {
            this.zzbjE = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long l) {
        this.zzbjE = l;
        if (this.zzbjE < 0L) {
            this.zzbjE = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.zzbjE;
    }

    public LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zzbjW = n;
        return this;
    }

    public int getNumUpdates() {
        return this.zzbjW;
    }

    public LocationRequest setSmallestDisplacement(float f) {
        LocationRequest.zze(f);
        this.zzbjX = f;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.zzbjX;
    }

    private static void zzV(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    private static void zzkk(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
    }

    private static void zze(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
    }

    LocationRequest(int n, long l, long l2, boolean bl, long l3, int n2, float f, long l4) {
        this.mPriority = n;
        this.zzbjU = l;
        this.zzbjV = l2;
        this.zzaWy = bl;
        this.zzbjE = l3;
        this.zzbjW = n2;
        this.zzbjX = f;
        this.zzbjY = l4;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzm.zza(this, parcel, n);
    }

    public static String zzkl(int n) {
        switch (n) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.zzkl(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzbjU).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzbjV).append("ms");
        if (this.zzbjY > this.zzbjU) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzbjY).append("ms");
        }
        if (this.zzbjX > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzbjX).append("m");
        }
        if (this.zzbjE != Long.MAX_VALUE) {
            long l = this.zzbjE - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzbjW != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzbjW);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.mPriority, this.zzbjU, Float.valueOf(this.zzbjX), this.zzbjY});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.mPriority == locationRequest.mPriority && this.zzbjU == locationRequest.zzbjU && this.zzbjV == locationRequest.zzbjV && this.zzaWy == locationRequest.zzaWy && this.zzbjE == locationRequest.zzbjE && this.zzbjW == locationRequest.zzbjW && this.zzbjX == locationRequest.zzbjX && this.getMaxWaitTime() == locationRequest.getMaxWaitTime();
    }
}

