/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zza {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zzbpn;
    private LatLng zzbpo;
    private float zzbpp;
    private float zzbpq;
    private LatLngBounds zzbnp;
    private float zzbpd;
    private float zzbpi;
    private boolean zzbpj = true;
    private float zzbpr = 0.0f;
    private float zzbps = 0.5f;
    private float zzbpt = 0.5f;
    private boolean zzbpk = false;

    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zzbpn = new BitmapDescriptor(IObjectWrapper.zza.zzcd((IBinder)iBinder));
        this.zzbpo = latLng;
        this.zzbpp = f;
        this.zzbpq = f2;
        this.zzbnp = latLngBounds;
        this.zzbpd = f3;
        this.zzbpi = f4;
        this.zzbpj = bl;
        this.zzbpr = f5;
        this.zzbps = f6;
        this.zzbpt = f7;
        this.zzbpk = bl2;
    }

    public GroundOverlayOptions() {
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    IBinder zzJK() {
        IObjectWrapper iObjectWrapper = this.zzbpn.zzJm();
        return iObjectWrapper.asBinder();
    }

    public GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzac.zzb((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zzbpn = bitmapDescriptor;
        return this;
    }

    public GroundOverlayOptions anchor(float f, float f2) {
        this.zzbps = f;
        this.zzbpt = f2;
        return this;
    }

    public GroundOverlayOptions position(LatLng latLng, float f) {
        zzac.zza((this.zzbnp == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzac.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzac.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzac.zza((this.zzbnp == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzac.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzac.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzac.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzbpo = latLng;
        this.zzbpp = f;
        this.zzbpq = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zzbpo);
        zzac.zza((this.zzbpo == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zzbnp = latLngBounds;
        return this;
    }

    public GroundOverlayOptions bearing(float f) {
        this.zzbpd = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float f) {
        this.zzbpi = f;
        return this;
    }

    public GroundOverlayOptions visible(boolean bl) {
        this.zzbpj = bl;
        return this;
    }

    public GroundOverlayOptions transparency(float f) {
        zzac.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzbpr = f;
        return this;
    }

    public GroundOverlayOptions clickable(boolean bl) {
        this.zzbpk = bl;
        return this;
    }

    public BitmapDescriptor getImage() {
        return this.zzbpn;
    }

    public LatLng getLocation() {
        return this.zzbpo;
    }

    public float getWidth() {
        return this.zzbpp;
    }

    public float getHeight() {
        return this.zzbpq;
    }

    public LatLngBounds getBounds() {
        return this.zzbnp;
    }

    public float getBearing() {
        return this.zzbpd;
    }

    public float getZIndex() {
        return this.zzbpi;
    }

    public float getTransparency() {
        return this.zzbpr;
    }

    public float getAnchorU() {
        return this.zzbps;
    }

    public float getAnchorV() {
        return this.zzbpt;
    }

    public boolean isVisible() {
        return this.zzbpj;
    }

    public boolean isClickable() {
        return this.zzbpk;
    }
}

