/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;

public final class GoogleMapOptions
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new com.google.android.gms.maps.zza();
    private Boolean zzbnY;
    private Boolean zzbnZ;
    private int zzboa = -1;
    private CameraPosition zzbob;
    private Boolean zzboc;
    private Boolean zzbod;
    private Boolean zzboe;
    private Boolean zzbof;
    private Boolean zzbog;
    private Boolean zzboh;
    private Boolean zzboi;
    private Boolean zzboj;
    private Boolean zzbok;
    private Float zzbol = null;
    private Float zzbom = null;
    private LatLngBounds zzbon = null;

    GoogleMapOptions(byte by, byte by2, int n, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.zzbnY = zza.zza(by);
        this.zzbnZ = zza.zza(by2);
        this.zzboa = n;
        this.zzbob = cameraPosition;
        this.zzboc = zza.zza(by3);
        this.zzbod = zza.zza(by4);
        this.zzboe = zza.zza(by5);
        this.zzbof = zza.zza(by6);
        this.zzbog = zza.zza(by7);
        this.zzboh = zza.zza(by8);
        this.zzboi = zza.zza(by9);
        this.zzboj = zza.zza(by10);
        this.zzbok = zza.zza(by11);
        this.zzbol = f;
        this.zzbom = f2;
        this.zzbon = latLngBounds;
    }

    public void writeToParcel(Parcel parcel, int n) {
        com.google.android.gms.maps.zza.zza(this, parcel, n);
    }

    byte zzJo() {
        return zza.zzd(this.zzbnY);
    }

    byte zzJp() {
        return zza.zzd(this.zzbnZ);
    }

    byte zzJq() {
        return zza.zzd(this.zzboc);
    }

    byte zzJr() {
        return zza.zzd(this.zzbod);
    }

    byte zzJs() {
        return zza.zzd(this.zzboe);
    }

    byte zzJt() {
        return zza.zzd(this.zzbof);
    }

    byte zzJu() {
        return zza.zzd(this.zzbog);
    }

    byte zzJv() {
        return zza.zzd(this.zzboh);
    }

    byte zzJw() {
        return zza.zzd(this.zzboi);
    }

    byte zzJx() {
        return zza.zzd(this.zzboj);
    }

    byte zzJy() {
        return zza.zzd(this.zzbok);
    }

    public GoogleMapOptions() {
    }

    public GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzbnY = bl;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzbnZ = bl;
        return this;
    }

    public GoogleMapOptions mapType(int n) {
        this.zzboa = n;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzbob = cameraPosition;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzboc = bl;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean bl) {
        this.zzbod = bl;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzboe = bl;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzbof = bl;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzbog = bl;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzboh = bl;
        return this;
    }

    public GoogleMapOptions liteMode(boolean bl) {
        this.zzboi = bl;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzboj = bl;
        return this;
    }

    public GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzbok = bl;
        return this;
    }

    public GoogleMapOptions minZoomPreference(float f) {
        this.zzbol = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions maxZoomPreference(float f) {
        this.zzbom = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzbon = latLngBounds;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.zzbnY;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.zzbnZ;
    }

    public int getMapType() {
        return this.zzboa;
    }

    public CameraPosition getCamera() {
        return this.zzbob;
    }

    public Boolean getZoomControlsEnabled() {
        return this.zzboc;
    }

    public Boolean getCompassEnabled() {
        return this.zzbod;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.zzboe;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.zzbof;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.zzbog;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.zzboh;
    }

    public Boolean getLiteMode() {
        return this.zzboi;
    }

    public Boolean getMapToolbarEnabled() {
        return this.zzboj;
    }

    public Boolean getAmbientEnabled() {
        return this.zzbok;
    }

    public Float getMinZoomPreference() {
        return this.zzbol;
    }

    public Float getMaxZoomPreference() {
        return this.zzbom;
    }

    public LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzbon;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

