/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.internal.zzasn;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

public class zzasm
extends zza
implements Geofence {
    private final String zzOV;
    private final long zzbkU;
    private final short zzbjF;
    private final double zzbjG;
    private final double zzbjH;
    private final float zzbjI;
    private final int zzbjD;
    private final int zzbjJ;
    private final int zzbjK;
    public static final Parcelable.Creator<zzasm> CREATOR = new zzasn();

    public zzasm(String string, int n, short s, double d, double d2, float f, long l, int n2, int n3) {
        zzasm.zzeT(string);
        zzasm.zzf(f);
        zzasm.zza(d, d2);
        n = zzasm.zzkA(n);
        this.zzbjF = s;
        this.zzOV = string;
        this.zzbjG = d;
        this.zzbjH = d2;
        this.zzbjI = f;
        this.zzbkU = l;
        this.zzbjD = n;
        this.zzbjJ = n2;
        this.zzbjK = n3;
    }

    public short zzIu() {
        return this.zzbjF;
    }

    public double getLatitude() {
        return this.zzbjG;
    }

    public double getLongitude() {
        return this.zzbjH;
    }

    public float getRadius() {
        return this.zzbjI;
    }

    @Override
    public String getRequestId() {
        return this.zzOV;
    }

    public long getExpirationTime() {
        return this.zzbkU;
    }

    public int zzIv() {
        return this.zzbjD;
    }

    public int zzIw() {
        return this.zzbjJ;
    }

    public int zzIx() {
        return this.zzbjK;
    }

    private static void zzeT(String string) {
        if (string == null || string.length() > 100) {
            String string2 = String.valueOf(string);
            throw new IllegalArgumentException(string2.length() != 0 ? "requestId is null or too long: ".concat(string2) : new String("requestId is null or too long: "));
        }
    }

    private static void zzf(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f).toString());
        }
    }

    private static void zza(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d).toString());
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d2).toString());
        }
    }

    private static int zzkA(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n).toString());
        }
        return n2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzasn.zza(this, parcel, n);
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String zzkB(int n) {
        switch (n) {
            case 1: {
                return "CIRCLE";
            }
        }
        return null;
    }

    public static zzasm zzw(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        zzasm zzasm2 = (zzasm)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzasm2;
    }

    public String toString() {
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", zzasm.zzkB(this.zzbjF), this.zzOV, this.zzbjD, this.zzbjG, this.zzbjH, Float.valueOf(this.zzbjI), this.zzbjJ / 1000, this.zzbjK, this.zzbkU);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.zzbjG);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzbjH);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + Float.floatToIntBits(this.zzbjI);
        n = 31 * n + this.zzbjF;
        n = 31 * n + this.zzbjD;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof zzasm)) {
            return false;
        }
        zzasm zzasm2 = (zzasm)object;
        if (this.zzbjI != zzasm2.zzbjI) {
            return false;
        }
        if (this.zzbjG != zzasm2.zzbjG) {
            return false;
        }
        if (this.zzbjH != zzasm2.zzbjH) {
            return false;
        }
        return this.zzbjF == zzasm2.zzbjF;
    }
}

