/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.hockeyapp.android.R;
import net.hockeyapp.android.objects.FeedbackAttachment;
import net.hockeyapp.android.objects.FeedbackMessage;
import net.hockeyapp.android.tasks.AttachmentDownloader;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.views.AttachmentListView;
import net.hockeyapp.android.views.AttachmentView;

public class FeedbackMessageView
extends LinearLayout {
    private TextView mAuthorTextView;
    private TextView mDateTextView;
    private TextView mMessageTextView;
    private AttachmentListView mAttachmentListView;
    private final Context mContext;

    public FeedbackMessageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        LayoutInflater.from((Context)context).inflate(R.layout.hockeyapp_view_feedback_message, (ViewGroup)this);
        this.mAuthorTextView = (TextView)this.findViewById(R.id.label_author);
        this.mDateTextView = (TextView)this.findViewById(R.id.label_date);
        this.mMessageTextView = (TextView)this.findViewById(R.id.label_text);
        this.mAttachmentListView = (AttachmentListView)this.findViewById(R.id.list_attachments);
    }

    public void setFeedbackMessage(FeedbackMessage feedbackMessage) {
        try {
            SimpleDateFormat dateFormatIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
            dateFormatIn.setTimeZone(TimeZone.getTimeZone("UTC"));
            DateFormat dateFormatOut = DateFormat.getDateTimeInstance(3, 3);
            Date date = dateFormatIn.parse(feedbackMessage.getCreatedAt());
            this.mDateTextView.setText((CharSequence)dateFormatOut.format(date));
            this.mDateTextView.setContentDescription((CharSequence)dateFormatOut.format(date));
        }
        catch (ParseException e) {
            HockeyLog.error("Failed to set feedback message", e);
        }
        this.mAuthorTextView.setText((CharSequence)feedbackMessage.getName());
        this.mAuthorTextView.setContentDescription((CharSequence)feedbackMessage.getName());
        this.mMessageTextView.setText((CharSequence)feedbackMessage.getText());
        this.mMessageTextView.setContentDescription((CharSequence)feedbackMessage.getText());
        this.mAttachmentListView.removeAllViews();
        for (FeedbackAttachment feedbackAttachment : feedbackMessage.getFeedbackAttachments()) {
            AttachmentView attachmentView = new AttachmentView(this.mContext, (ViewGroup)this.mAttachmentListView, feedbackAttachment, false);
            AttachmentDownloader.getInstance().download(feedbackAttachment, attachmentView);
            this.mAttachmentListView.addView((View)attachmentView);
        }
    }

    public void setIndex(int index) {
        if (index % 2 == 0) {
            this.setBackgroundColor(this.getResources().getColor(R.color.hockeyapp_background_light));
        } else {
            this.setBackgroundColor(this.getResources().getColor(R.color.hockeyapp_background_white));
        }
    }
}

