/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import net.hockeyapp.android.R;
import net.hockeyapp.android.objects.FeedbackAttachment;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.ImageUtils;
import net.hockeyapp.android.utils.Util;

@SuppressLint(value={"ViewConstructor"})
public class AttachmentView
extends FrameLayout {
    private static final int IMAGES_PER_ROW_PORTRAIT = 3;
    private static final int IMAGES_PER_ROW_LANDSCAPE = 2;
    private final Context mContext;
    private final ViewGroup mParent;
    private final FeedbackAttachment mAttachment;
    private final Uri mAttachmentUri;
    private final String mFilename;
    private ImageView mImageView;
    private TextView mTextView;
    private int mWidthPortrait;
    private int mMaxHeightPortrait;
    private int mWidthLandscape;
    private int mMaxHeightLandscape;
    private int mGap;
    private int mOrientation;

    @SuppressLint(value={"StaticFieldLeak"})
    public AttachmentView(Context context, ViewGroup parent, Uri attachmentUri, boolean removable) {
        super(context);
        this.mContext = context;
        this.mParent = parent;
        this.mAttachment = null;
        this.mAttachmentUri = attachmentUri;
        this.mFilename = attachmentUri.getLastPathSegment();
        this.calculateDimensions(10);
        this.initializeView(context, removable);
        this.mTextView.setText((CharSequence)this.mFilename);
        this.mTextView.setContentDescription(this.mTextView.getText());
        AsyncTaskUtils.execute(new AsyncTask<Void, Void, Bitmap>(){

            protected Bitmap doInBackground(Void ... args) {
                return AttachmentView.this.loadImageThumbnail();
            }

            protected void onPostExecute(Bitmap bitmap) {
                if (bitmap != null) {
                    AttachmentView.this.configureViewForThumbnail(bitmap, false);
                } else {
                    AttachmentView.this.configureViewForPlaceholder(false);
                }
            }
        });
    }

    public AttachmentView(Context context, ViewGroup parent, FeedbackAttachment attachment, boolean removable) {
        super(context);
        this.mContext = context;
        this.mParent = parent;
        this.mAttachment = attachment;
        this.mAttachmentUri = null;
        this.mFilename = attachment.getFilename();
        this.calculateDimensions(40);
        this.initializeView(context, removable);
        this.mOrientation = 1;
        this.mTextView.setText(R.string.hockeyapp_feedback_attachment_loading);
        this.mTextView.setContentDescription(this.mTextView.getText());
        this.configureViewForPlaceholder(false);
    }

    public FeedbackAttachment getAttachment() {
        return this.mAttachment;
    }

    public Uri getAttachmentUri() {
        return this.mAttachmentUri;
    }

    public int getWidthPortrait() {
        return this.mWidthPortrait;
    }

    public int getMaxHeightPortrait() {
        return this.mMaxHeightPortrait;
    }

    public int getWidthLandscape() {
        return this.mWidthLandscape;
    }

    public int getMaxHeightLandscape() {
        return this.mMaxHeightLandscape;
    }

    public int getGap() {
        return this.mGap;
    }

    public int getEffectiveMaxHeight() {
        return this.mOrientation == 0 ? this.mMaxHeightLandscape : this.mMaxHeightPortrait;
    }

    public void remove() {
        Util.announceForAccessibility((View)this.mParent, this.mContext.getString(R.string.hockeyapp_feedback_attachment_removed));
        this.mParent.removeView((View)this);
    }

    public void setImage(Bitmap bitmap, int orientation) {
        this.mTextView.setText((CharSequence)this.mFilename);
        this.mTextView.setContentDescription(this.mTextView.getText());
        this.mOrientation = orientation;
        if (bitmap == null) {
            this.configureViewForPlaceholder(true);
        } else {
            this.configureViewForThumbnail(bitmap, true);
        }
    }

    public void signalImageLoadingError() {
        this.mTextView.setText(R.string.hockeyapp_feedback_attachment_error);
        this.mTextView.setContentDescription(this.mTextView.getText());
    }

    private void calculateDimensions(int marginDip) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mGap = Math.round(TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)metrics));
        int layoutMargin = Math.round(TypedValue.applyDimension((int)1, (float)marginDip, (DisplayMetrics)metrics));
        int displayWidth = metrics.widthPixels;
        int parentWidthPortrait = displayWidth - 2 * layoutMargin - 2 * this.mGap;
        int parentWidthLandscape = displayWidth - 2 * layoutMargin - this.mGap;
        this.mWidthPortrait = parentWidthPortrait / 3;
        this.mWidthLandscape = parentWidthLandscape / 2;
        this.mMaxHeightPortrait = this.mWidthPortrait * 2;
        this.mMaxHeightLandscape = this.mWidthLandscape;
    }

    private void initializeView(Context context, boolean removable) {
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 80));
        this.setPadding(0, this.mGap, 0, 0);
        Util.announceForAccessibility((View)this.mParent, this.mContext.getString(R.string.hockeyapp_feedback_attachment_added));
        this.mImageView = new ImageView(context);
        LinearLayout bottomView = new LinearLayout(context);
        bottomView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, 80));
        bottomView.setGravity(0x800003);
        bottomView.setOrientation(1);
        bottomView.setBackgroundColor(Color.parseColor((String)"#80262626"));
        this.mTextView = new TextView(context);
        this.mTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, 17));
        this.mTextView.setGravity(17);
        this.mTextView.setTextColor(context.getResources().getColor(R.color.hockeyapp_text_white));
        this.mTextView.setSingleLine();
        this.mTextView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
        if (removable) {
            ImageButton imageButton = new ImageButton(context);
            imageButton.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, 80));
            imageButton.setAdjustViewBounds(true);
            imageButton.setImageDrawable(this.getSystemIcon("ic_menu_delete"));
            imageButton.setBackgroundResource(0);
            imageButton.setContentDescription((CharSequence)context.getString(R.string.hockeyapp_feedback_attachment_remove_description));
            imageButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AttachmentView.this.remove();
                }
            });
            imageButton.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View v, boolean hasFocus) {
                    if (hasFocus) {
                        Util.announceForAccessibility((View)AttachmentView.this.mTextView, AttachmentView.this.mTextView.getText());
                    }
                }
            });
            bottomView.addView((View)imageButton);
        }
        bottomView.addView((View)this.mTextView);
        this.addView((View)this.mImageView);
        this.addView((View)bottomView);
    }

    private void configureViewForThumbnail(Bitmap bitmap, final boolean openOnClick) {
        int width = this.mOrientation == 0 ? this.mWidthLandscape : this.mWidthPortrait;
        int height = this.mOrientation == 0 ? this.mMaxHeightLandscape : this.mMaxHeightPortrait;
        this.mTextView.setMaxWidth(width);
        this.mTextView.setMinWidth(width);
        this.mImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.mImageView.setAdjustViewBounds(true);
        this.mImageView.setMinimumWidth(width);
        this.mImageView.setMaxWidth(width);
        this.mImageView.setMaxHeight(height);
        this.mImageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.mImageView.setImageBitmap(bitmap);
        this.mImageView.setContentDescription(this.mTextView.getText());
        this.mImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!openOnClick) {
                    return;
                }
                Intent intent = new Intent();
                intent.setAction("android.intent.action.VIEW");
                intent.setDataAndType(AttachmentView.this.mAttachmentUri, "image/*");
                AttachmentView.this.mContext.startActivity(intent);
            }
        });
    }

    private void configureViewForPlaceholder(final boolean openOnClick) {
        this.mTextView.setMaxWidth(this.mWidthPortrait);
        this.mTextView.setMinWidth(this.mWidthPortrait);
        this.mImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.mImageView.setAdjustViewBounds(false);
        this.mImageView.setBackgroundColor(Color.parseColor((String)"#eeeeee"));
        this.mImageView.setMinimumHeight((int)((float)this.mWidthPortrait * 1.2f));
        this.mImageView.setMinimumWidth(this.mWidthPortrait);
        this.mImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mImageView.setImageDrawable(this.getSystemIcon("ic_menu_attachment"));
        this.mImageView.setContentDescription(this.mTextView.getText());
        this.mImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!openOnClick) {
                    return;
                }
                Intent intent = new Intent();
                intent.setAction("android.intent.action.VIEW");
                intent.setDataAndType(AttachmentView.this.mAttachmentUri, "*/*");
                AttachmentView.this.mContext.startActivity(intent);
            }
        });
    }

    private Bitmap loadImageThumbnail() {
        try {
            this.mOrientation = ImageUtils.determineOrientation(this.mContext, this.mAttachmentUri);
            int width = this.mOrientation == 0 ? this.mWidthLandscape : this.mWidthPortrait;
            int height = this.mOrientation == 0 ? this.mMaxHeightLandscape : this.mMaxHeightPortrait;
            return ImageUtils.decodeSampledBitmap(this.mContext, this.mAttachmentUri, width, height);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private Drawable getSystemIcon(String name) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.getResources().getDrawable(this.getResources().getIdentifier(name, "drawable", "android"), this.mContext.getTheme());
        }
        return this.getResources().getDrawable(this.getResources().getIdentifier(name, "drawable", "android"));
    }
}

