/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.views;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.views.AttachmentView;

public class AttachmentListView
extends ViewGroup {
    private static final String TAG = "AttachmentListView";
    private int mLineHeight;

    public AttachmentListView(Context context) {
        super(context);
    }

    public AttachmentListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ArrayList<Uri> getAttachments() {
        ArrayList<Uri> attachments = new ArrayList<Uri>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            AttachmentView attachmentView = (AttachmentView)this.getChildAt(i);
            attachments.add(attachmentView.getAttachmentUri());
        }
        return attachments;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == 0) {
            HockeyLog.debug(TAG, "Width is unspecified");
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int count = this.getChildCount();
        int height = 0;
        int line_height = 0;
        int xPos = this.getPaddingLeft();
        int yPos = this.getPaddingTop();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            AttachmentView attachmentView = (AttachmentView)child;
            height = attachmentView.getEffectiveMaxHeight() + attachmentView.getPaddingTop();
            if (child.getVisibility() == 8) continue;
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            child.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE));
            int childWidth = child.getMeasuredWidth();
            line_height = Math.max(line_height, child.getMeasuredHeight() + lp.height);
            if (xPos + childWidth > width) {
                xPos = this.getPaddingLeft();
                yPos += line_height;
            }
            xPos += childWidth + lp.width;
        }
        this.mLineHeight = line_height;
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
            height = yPos + line_height + this.getPaddingBottom();
        } else if (View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE && yPos + line_height + this.getPaddingBottom() < height) {
            height = yPos + line_height + this.getPaddingBottom();
        }
        this.setMeasuredDimension(width, height);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(1, 1);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p != null;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int width = r - l;
        int xPos = this.getPaddingLeft();
        int yPos = this.getPaddingTop();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.invalidate();
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (xPos + childWidth > width) {
                xPos = this.getPaddingLeft();
                yPos += this.mLineHeight;
            }
            child.layout(xPos, yPos, xPos + childWidth, yPos + childHeight);
            xPos += childWidth + lp.width + ((AttachmentView)child).getGap();
        }
    }
}

