/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import net.hockeyapp.android.utils.HockeyLog;

public class SimpleMultipartEntity {
    private static final char[] BOUNDARY_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private boolean mIsSetLast = false;
    private boolean mIsSetFirst = false;
    private File mTempFile;
    private OutputStream mOut;
    private String mBoundary;

    public SimpleMultipartEntity(File tempFile) {
        this.mTempFile = tempFile;
        try {
            this.mOut = new FileOutputStream(this.mTempFile);
        }
        catch (IOException e) {
            HockeyLog.error("Failed to open temp file", e);
        }
        StringBuilder buffer = new StringBuilder();
        Random rand = new Random();
        for (int i = 0; i < 30; ++i) {
            buffer.append(BOUNDARY_CHARS[rand.nextInt(BOUNDARY_CHARS.length)]);
        }
        this.mBoundary = buffer.toString();
    }

    public String getBoundary() {
        return this.mBoundary;
    }

    public void writeFirstBoundaryIfNeeds() throws IOException {
        if (!this.mIsSetFirst) {
            this.mOut.write(("--" + this.mBoundary + "\r\n").getBytes());
        }
        this.mIsSetFirst = true;
    }

    public void writeLastBoundaryIfNeeds() {
        if (this.mIsSetLast) {
            return;
        }
        try {
            this.mOut.write(("\r\n--" + this.mBoundary + "--\r\n").getBytes());
            this.mOut.flush();
            this.mOut.close();
            this.mOut = null;
        }
        catch (IOException e) {
            HockeyLog.error("Failed to close temp file", e);
        }
        this.mIsSetLast = true;
    }

    public void addPart(String key, String value) throws IOException {
        this.writeFirstBoundaryIfNeeds();
        this.mOut.write(("Content-Disposition: form-data; name=\"" + key + "\"\r\n").getBytes());
        this.mOut.write("Content-Type: text/plain; charset=UTF-8\r\n".getBytes());
        this.mOut.write("Content-Transfer-Encoding: 8bit\r\n\r\n".getBytes());
        this.mOut.write(value.getBytes());
        this.mOut.write(("\r\n--" + this.mBoundary + "\r\n").getBytes());
    }

    public void addPart(String key, File value, boolean lastFile) throws IOException {
        this.addPart(key, value.getName(), new FileInputStream(value), lastFile);
    }

    public void addPart(String key, String fileName, InputStream fin, boolean lastFile) throws IOException {
        this.addPart(key, fileName, fin, "application/octet-stream", lastFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPart(String key, String fileName, InputStream fin, String type, boolean lastFile) throws IOException {
        this.writeFirstBoundaryIfNeeds();
        try {
            int l;
            type = "Content-Type: " + type + "\r\n";
            this.mOut.write(("Content-Disposition: form-data; name=\"" + key + "\"; filename=\"" + fileName + "\"\r\n").getBytes());
            this.mOut.write(type.getBytes());
            this.mOut.write("Content-Transfer-Encoding: binary\r\n\r\n".getBytes());
            byte[] tmp = new byte[4096];
            while ((l = fin.read(tmp)) != -1) {
                this.mOut.write(tmp, 0, l);
            }
            this.mOut.flush();
            if (lastFile) {
                this.writeLastBoundaryIfNeeds();
            } else {
                this.mOut.write(("\r\n--" + this.mBoundary + "\r\n").getBytes());
            }
        }
        finally {
            try {
                fin.close();
            }
            catch (IOException iOException) {}
        }
    }

    public long getContentLength() {
        this.writeLastBoundaryIfNeeds();
        return this.mTempFile.length();
    }

    public String getContentType() {
        return "multipart/form-data; boundary=" + this.getBoundary();
    }

    public void writeTo(OutputStream out) throws IOException {
        int l;
        this.writeLastBoundaryIfNeeds();
        FileInputStream fileInputStream = new FileInputStream(this.mTempFile);
        BufferedOutputStream outputStream = new BufferedOutputStream(out);
        byte[] tmp = new byte[4096];
        while ((l = fileInputStream.read(tmp)) != -1) {
            outputStream.write(tmp, 0, l);
        }
        fileInputStream.close();
        outputStream.flush();
        outputStream.close();
        this.mTempFile.delete();
        this.mTempFile = null;
    }
}

