/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import java.util.ArrayList;

public class PermissionsUtil {
    public static int[] permissionsState(Context context, String ... permissions) {
        if (permissions == null) {
            return null;
        }
        int[] state = new int[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            state[i] = context.checkCallingOrSelfPermission(permissions[i]);
        }
        return state;
    }

    public static boolean permissionsAreGranted(int[] permissionsState) {
        for (int permissionState : permissionsState) {
            if (permissionState == 0) continue;
            return false;
        }
        return true;
    }

    public static String[] deniedPermissions(String[] permissions, int[] permissionsState) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            if (permissionsState[i] == 0) continue;
            result.add(permissions[i]);
        }
        return result.toArray(new String[0]);
    }

    public static boolean isUnknownSourcesEnabled(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            return context.getApplicationInfo().targetSdkVersion < 26 || context.getPackageManager().canRequestPackageInstalls();
        }
        if (Build.VERSION.SDK_INT >= 17 && Build.VERSION.SDK_INT < 21) {
            return "1".equals(Settings.Global.getString((ContentResolver)context.getContentResolver(), (String)"install_non_market_apps"));
        }
        return "1".equals(Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"install_non_market_apps"));
    }
}

