/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.utils;

import android.util.Log;

public class HockeyLog {
    public static final String HOCKEY_TAG = "HockeyApp";
    private static int sLogLevel = 6;

    public static int getLogLevel() {
        return sLogLevel;
    }

    public static void setLogLevel(int hockeyLogLevel) {
        sLogLevel = hockeyLogLevel;
    }

    public static void verbose(String message) {
        HockeyLog.verbose(null, message);
    }

    public static void verbose(String tag, String message) {
        tag = HockeyLog.sanitizeTag(tag);
        if (sLogLevel <= 2) {
            Log.v((String)tag, (String)message);
        }
    }

    public static void verbose(String message, Throwable throwable) {
        HockeyLog.verbose(null, message, throwable);
    }

    public static void verbose(String tag, String message, Throwable throwable) {
        tag = HockeyLog.sanitizeTag(tag);
        if (sLogLevel <= 2) {
            Log.v((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void debug(String message) {
        HockeyLog.debug(null, message);
    }

    public static void debug(String tag, String message) {
        tag = HockeyLog.sanitizeTag(tag);
        if (sLogLevel <= 3) {
            Log.d((String)tag, (String)message);
        }
    }

    public static void debug(String message, Throwable throwable) {
        HockeyLog.debug(null, message, throwable);
    }

    public static void debug(String tag, String message, Throwable throwable) {
        tag = HockeyLog.sanitizeTag(tag);
        if (sLogLevel <= 3) {
            Log.d((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void info(String message) {
        HockeyLog.info(null, message);
    }

    public static void info(String tag, String message) {
        tag = HockeyLog.sanitizeTag(tag);
        if (sLogLevel <= 4) {
            Log.i((String)tag, (String)message);
        }
    }

    public static void info(String message, Throwable throwable) {
        HockeyLog.info(null, message, throwable);
    }

    public static void info(String tag, String message, Throwable throwable) {
        tag = HockeyLog.sanitizeTag(tag);
        if (sLogLevel <= 4) {
            Log.i((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void warn(String message) {
        HockeyLog.warn(null, message);
    }

    public static void warn(String tag, String message) {
        tag = HockeyLog.sanitizeTag(tag);
        if (sLogLevel <= 5) {
            Log.w((String)tag, (String)message);
        }
    }

    public static void warn(String message, Throwable throwable) {
        HockeyLog.warn(null, message, throwable);
    }

    public static void warn(String tag, String message, Throwable throwable) {
        tag = HockeyLog.sanitizeTag(tag);
        if (sLogLevel <= 5) {
            Log.w((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void error(String message) {
        HockeyLog.error(null, message);
    }

    public static void error(String tag, String message) {
        tag = HockeyLog.sanitizeTag(tag);
        if (sLogLevel <= 6) {
            Log.e((String)tag, (String)message);
        }
    }

    public static void error(String message, Throwable throwable) {
        HockeyLog.error(null, message, throwable);
    }

    public static void error(String tag, String message, Throwable throwable) {
        tag = HockeyLog.sanitizeTag(tag);
        if (sLogLevel <= 6) {
            Log.e((String)tag, (String)message, (Throwable)throwable);
        }
    }

    static String sanitizeTag(String tag) {
        if (tag == null || tag.length() == 0 || tag.length() > 23) {
            tag = HOCKEY_TAG;
        }
        return tag;
    }
}

