/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.tasks;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import java.io.Serializable;
import java.util.ArrayList;
import net.hockeyapp.android.FeedbackActivity;
import net.hockeyapp.android.FeedbackManager;
import net.hockeyapp.android.FeedbackManagerListener;
import net.hockeyapp.android.R;
import net.hockeyapp.android.objects.Feedback;
import net.hockeyapp.android.objects.FeedbackMessage;
import net.hockeyapp.android.objects.FeedbackResponse;
import net.hockeyapp.android.utils.FeedbackParser;
import net.hockeyapp.android.utils.Util;

@SuppressLint(value={"StaticFieldLeak"})
public class ParseFeedbackTask
extends AsyncTask<Void, Void, FeedbackResponse> {
    public static final String PREFERENCES_NAME = "net.hockeyapp.android.feedback";
    public static final String ID_LAST_MESSAGE_SEND = "idLastMessageSend";
    public static final String ID_LAST_MESSAGE_PROCESSED = "idLastMessageProcessed";
    public static final String BUNDLE_PARSE_FEEDBACK_RESPONSE = "parse_feedback_response";
    private Context mContext;
    private String mFeedbackResponse;
    private Handler mHandler;
    private String mRequestType;
    private String mUrlString;

    public ParseFeedbackTask(Context context, String feedbackResponse, Handler handler, String requestType) {
        this.mContext = context;
        this.mFeedbackResponse = feedbackResponse;
        this.mHandler = handler;
        this.mRequestType = requestType;
        this.mUrlString = null;
    }

    public void setUrlString(String urlString) {
        this.mUrlString = urlString;
    }

    protected FeedbackResponse doInBackground(Void ... params) {
        if (this.mContext != null && this.mFeedbackResponse != null) {
            ArrayList<FeedbackMessage> messages;
            Feedback feedback;
            FeedbackResponse response = FeedbackParser.getInstance().parseFeedbackResponse(this.mFeedbackResponse);
            if (response != null && (feedback = response.getFeedback()) != null && (messages = response.getFeedback().getMessages()) != null && !messages.isEmpty()) {
                this.checkForNewAnswers(messages);
            }
            return response;
        }
        return null;
    }

    protected void onPostExecute(FeedbackResponse result) {
        if (result != null && this.mHandler != null) {
            Message msg = new Message();
            Bundle bundle = new Bundle();
            bundle.putSerializable(BUNDLE_PARSE_FEEDBACK_RESPONSE, (Serializable)result);
            msg.setData(bundle);
            this.mHandler.sendMessage(msg);
        }
    }

    private void checkForNewAnswers(ArrayList<FeedbackMessage> messages) {
        FeedbackMessage latestMessage = messages.get(messages.size() - 1);
        int idLatestMessage = latestMessage.getId();
        SharedPreferences preferences = this.mContext.getSharedPreferences(PREFERENCES_NAME, 0);
        if (this.mRequestType.equals("send")) {
            preferences.edit().putInt(ID_LAST_MESSAGE_SEND, idLatestMessage).putInt(ID_LAST_MESSAGE_PROCESSED, idLatestMessage).apply();
        } else if (this.mRequestType.equals("fetch")) {
            int idLastMessageSend = preferences.getInt(ID_LAST_MESSAGE_SEND, -1);
            int idLastMessageProcessed = preferences.getInt(ID_LAST_MESSAGE_PROCESSED, -1);
            if (idLatestMessage != idLastMessageSend && idLatestMessage != idLastMessageProcessed) {
                preferences.edit().putInt(ID_LAST_MESSAGE_PROCESSED, idLatestMessage).apply();
                boolean eventHandled = false;
                FeedbackManagerListener listener = FeedbackManager.getLastListener();
                if (listener != null) {
                    eventHandled = listener.feedbackAnswered(latestMessage);
                }
                if (!eventHandled && this.mUrlString != null) {
                    ParseFeedbackTask.showNewAnswerNotification(this.mContext, this.mUrlString);
                }
            }
        }
    }

    private static void showNewAnswerNotification(Context context, String urlString) {
        Class<? extends FeedbackActivity> activityClass = null;
        if (FeedbackManager.getLastListener() != null) {
            activityClass = FeedbackManager.getLastListener().getFeedbackActivityClass();
        }
        if (activityClass == null) {
            activityClass = FeedbackActivity.class;
        }
        int iconId = context.getResources().getIdentifier("ic_menu_refresh", "drawable", "android");
        Intent intent = new Intent();
        intent.setFlags(0x30000000);
        intent.setClass(context, activityClass);
        intent.putExtra("url", urlString);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x40000000);
        Notification notification = Util.createNotification(context, pendingIntent, context.getString(R.string.hockeyapp_feedback_notification_title), context.getString(R.string.hockeyapp_feedback_new_answer_notification_message), iconId, "net.hockeyapp.android.NOTIFICATION");
        Util.sendNotification(context, 2, notification, "net.hockeyapp.android.NOTIFICATION", context.getString(R.string.hockeyapp_feedback_notification_channel));
    }
}

