/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.tasks;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Map;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.tasks.ConnectionTask;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.HttpURLConnectionBuilder;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"StaticFieldLeak"})
public class LoginTask
extends ConnectionTask<Void, Void, Boolean> {
    public static final String BUNDLE_SUCCESS = "success";
    private final int mMode;
    private final String mUrlString;
    private final Map<String, String> mParams;
    private Context mContext;
    private Handler mHandler;
    private ProgressDialog mProgressDialog;
    private boolean mShowProgressDialog;

    public LoginTask(Context context, Handler handler, String urlString, int mode, Map<String, String> params) {
        this.mContext = context;
        this.mHandler = handler;
        this.mUrlString = urlString;
        this.mMode = mode;
        this.mParams = params;
        this.mShowProgressDialog = true;
        if (context != null) {
            Constants.loadFromContext(context);
        }
    }

    public void setShowProgressDialog(boolean showProgressDialog) {
        this.mShowProgressDialog = showProgressDialog;
    }

    public void attach(Context context, Handler handler) {
        this.mContext = context;
        this.mHandler = handler;
    }

    public void detach() {
        this.mContext = null;
        this.mHandler = null;
        this.mProgressDialog = null;
    }

    protected void onPreExecute() {
        if ((this.mProgressDialog == null || !this.mProgressDialog.isShowing()) && this.mShowProgressDialog) {
            this.mProgressDialog = ProgressDialog.show((Context)this.mContext, (CharSequence)"", (CharSequence)"Please wait...", (boolean)true, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doInBackground(Void ... args) {
        HttpURLConnection connection = null;
        try {
            String responseStr;
            connection = this.makeRequest(this.mMode, this.mParams);
            connection.connect();
            if (connection.getResponseCode() == 200 && !TextUtils.isEmpty((CharSequence)(responseStr = LoginTask.getStringFromConnection(connection)))) {
                Boolean bl = this.handleResponse(responseStr);
                return bl;
            }
        }
        catch (IOException e) {
            HockeyLog.error("Failed to login", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    protected void onPostExecute(Boolean success) {
        if (this.mProgressDialog != null) {
            try {
                this.mProgressDialog.dismiss();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mHandler != null) {
            Message msg = new Message();
            Bundle bundle = new Bundle();
            bundle.putBoolean(BUNDLE_SUCCESS, success.booleanValue());
            msg.setData(bundle);
            this.mHandler.sendMessage(msg);
        }
    }

    private HttpURLConnection makeRequest(int mode, Map<String, String> params) throws IOException {
        if (mode == 1) {
            return new HttpURLConnectionBuilder(this.mUrlString).setRequestMethod("POST").writeFormFields(params).build();
        }
        if (mode == 2) {
            return new HttpURLConnectionBuilder(this.mUrlString).setRequestMethod("POST").setBasicAuthorization(params.get("email"), params.get("password")).build();
        }
        if (mode == 3) {
            String type = params.get("type");
            String id2 = params.get("id");
            String paramUrl = this.mUrlString + "?" + type + "=" + id2;
            return new HttpURLConnectionBuilder(paramUrl).build();
        }
        throw new IllegalArgumentException("Login mode " + mode + " not supported.");
    }

    private boolean handleResponse(String responseStr) {
        SharedPreferences prefs = this.mContext.getSharedPreferences("net.hockeyapp.android.login", 0);
        try {
            JSONObject response = new JSONObject(responseStr);
            String status = response.getString("status");
            if (TextUtils.isEmpty((CharSequence)status)) {
                return false;
            }
            if (this.mMode == 1) {
                String iuid;
                if (status.equals("identified") && !TextUtils.isEmpty((CharSequence)(iuid = response.getString("iuid")))) {
                    prefs.edit().putString("iuid", iuid).putString("email", this.mParams.get("email")).apply();
                    return true;
                }
            } else if (this.mMode == 2) {
                String auid;
                if (status.equals("authorized") && !TextUtils.isEmpty((CharSequence)(auid = response.getString("auid")))) {
                    prefs.edit().putString("auid", auid).putString("email", this.mParams.get("email")).apply();
                    return true;
                }
            } else if (this.mMode == 3) {
                if (status.equals("validated")) {
                    return true;
                }
                prefs.edit().remove("iuid").remove("auid").remove("email").apply();
            } else {
                throw new IllegalArgumentException("Login mode " + this.mMode + " not supported.");
            }
            return false;
        }
        catch (JSONException e) {
            HockeyLog.error("Failed to parse login response", e);
            return false;
        }
    }
}

