/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.tasks;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.StrictMode;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import net.hockeyapp.android.R;
import net.hockeyapp.android.listeners.DownloadFileListener;
import net.hockeyapp.android.utils.HockeyLog;

@SuppressLint(value={"StaticFieldLeak"})
public class DownloadFileTask
extends AsyncTask<Void, Integer, Long> {
    protected static final int MAX_REDIRECTS = 6;
    protected Context mContext;
    protected DownloadFileListener mNotifier;
    protected String mUrlString;
    protected String mFilename;
    protected File mDirectory;
    protected ProgressDialog mProgressDialog;
    private String mDownloadErrorMessage;

    public DownloadFileTask(Context context, String urlString, DownloadFileListener notifier) {
        this.mContext = context;
        this.mUrlString = urlString;
        this.mFilename = UUID.randomUUID() + ".apk";
        this.mDirectory = new File(context.getExternalFilesDir(null), "Download");
        this.mNotifier = notifier;
        this.mDownloadErrorMessage = null;
    }

    public void attach(Context context) {
        this.mContext = context;
    }

    public void detach() {
        this.mContext = null;
        this.mProgressDialog = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long doInBackground(Void ... args) {
        Long l;
        InputStream input = null;
        OutputStream output = null;
        try {
            int count;
            URL url = new URL(this.getURLString());
            URLConnection connection = this.createConnection(url, 6);
            connection.connect();
            int lengthOfFile = connection.getContentLength();
            String contentType = connection.getContentType();
            if (contentType != null && contentType.contains("text")) {
                this.mDownloadErrorMessage = "The requested download does not appear to be a file.";
                Long l2 = 0L;
                return l2;
            }
            boolean result = this.mDirectory.mkdirs();
            if (!result && !this.mDirectory.exists()) {
                throw new IOException("Could not create the dir(s):" + this.mDirectory.getAbsolutePath());
            }
            File file = new File(this.mDirectory, this.mFilename);
            input = new BufferedInputStream(connection.getInputStream());
            output = new FileOutputStream(file);
            byte[] data = new byte[1024];
            long total = 0L;
            while ((count = input.read(data)) != -1) {
                this.publishProgress(new Integer[]{Math.round((float)(total += (long)count) * 100.0f / (float)lengthOfFile)});
                output.write(data, 0, count);
            }
            output.flush();
            l = total;
        }
        catch (IOException e) {
            HockeyLog.error("Failed to download " + this.mUrlString, e);
            Long l3 = 0L;
            return l3;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return l;
    }

    protected void setConnectionProperties(HttpURLConnection connection) {
        connection.addRequestProperty("User-Agent", "HockeySDK/Android 5.1.0");
        connection.setInstanceFollowRedirects(true);
    }

    protected URLConnection createConnection(URL url, int remainingRedirects) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.setConnectionProperties(connection);
        int code = connection.getResponseCode();
        if (code == 301 || code == 302 || code == 303) {
            if (remainingRedirects == 0) {
                return connection;
            }
            URL movedUrl = new URL(connection.getHeaderField("Location"));
            if (!url.getProtocol().equals(movedUrl.getProtocol())) {
                connection.disconnect();
                return this.createConnection(movedUrl, --remainingRedirects);
            }
        }
        return connection;
    }

    protected void onProgressUpdate(Integer ... args) {
        try {
            if (this.mProgressDialog == null) {
                this.mProgressDialog = new ProgressDialog(this.mContext);
                this.mProgressDialog.setProgressStyle(1);
                this.mProgressDialog.setMessage((CharSequence)this.mContext.getString(R.string.hockeyapp_update_loading));
                this.mProgressDialog.setCancelable(false);
                this.mProgressDialog.show();
            }
            this.mProgressDialog.setProgress(args[0].intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onPostExecute(Long result) {
        if (this.mProgressDialog != null) {
            try {
                this.mProgressDialog.dismiss();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result > 0L) {
            this.mNotifier.downloadSuccessful(this);
            Intent intent = new Intent("android.intent.action.INSTALL_PACKAGE");
            intent.setDataAndType(Uri.fromFile((File)new File(this.mDirectory, this.mFilename)), "application/vnd.android.package-archive");
            intent.setFlags(0x10000000);
            StrictMode.VmPolicy oldVmPolicy = null;
            if (Build.VERSION.SDK_INT >= 24) {
                oldVmPolicy = StrictMode.getVmPolicy();
                StrictMode.VmPolicy policy = new StrictMode.VmPolicy.Builder().penaltyLog().build();
                StrictMode.setVmPolicy((StrictMode.VmPolicy)policy);
            }
            this.mContext.startActivity(intent);
            if (oldVmPolicy != null) {
                StrictMode.setVmPolicy((StrictMode.VmPolicy)oldVmPolicy);
            }
        } else {
            try {
                AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
                builder.setTitle(R.string.hockeyapp_download_failed_dialog_title);
                String message = this.mDownloadErrorMessage == null ? this.mContext.getString(R.string.hockeyapp_download_failed_dialog_message) : this.mDownloadErrorMessage;
                builder.setMessage((CharSequence)message);
                builder.setNegativeButton(R.string.hockeyapp_download_failed_dialog_negative_button, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        DownloadFileTask.this.mNotifier.downloadFailed(DownloadFileTask.this, false);
                    }
                });
                builder.setPositiveButton(R.string.hockeyapp_download_failed_dialog_positive_button, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        DownloadFileTask.this.mNotifier.downloadFailed(DownloadFileTask.this, true);
                    }
                });
                builder.create().show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected String getURLString() {
        return this.mUrlString + "&type=apk";
    }
}

