/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.tasks;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.Tracking;
import net.hockeyapp.android.UpdateManagerListener;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.Util;
import net.hockeyapp.android.utils.VersionHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckUpdateTask
extends AsyncTask<Void, String, JSONArray> {
    private static final int MAX_NUMBER_OF_VERSIONS = 25;
    protected String urlString = null;
    protected String apkUrlString = null;
    protected String appIdentifier = null;
    private WeakReference<Context> weakContext = null;
    protected Boolean mandatory = false;
    protected UpdateManagerListener listener;
    private long usageTime = 0L;

    public CheckUpdateTask(WeakReference<? extends Context> weakContext, String urlString) {
        this(weakContext, urlString, null);
    }

    public CheckUpdateTask(WeakReference<? extends Context> weakContext, String urlString, String appIdentifier) {
        this(weakContext, urlString, appIdentifier, null);
    }

    public CheckUpdateTask(WeakReference<? extends Context> weakContext, String urlString, String appIdentifier, UpdateManagerListener listener) {
        this.appIdentifier = appIdentifier;
        this.urlString = urlString;
        this.listener = listener;
        Context ctx = null;
        if (weakContext != null) {
            ctx = (Context)weakContext.get();
        }
        if (ctx != null) {
            this.weakContext = new WeakReference<Context>(ctx.getApplicationContext());
            this.usageTime = Tracking.getUsageTime(ctx);
            Constants.loadFromContext(ctx);
        }
    }

    public void attach(WeakReference<? extends Context> weakContext) {
        Context ctx = null;
        if (weakContext != null) {
            ctx = (Context)weakContext.get();
        }
        if (ctx != null) {
            this.weakContext = new WeakReference<Context>(ctx.getApplicationContext());
            Constants.loadFromContext(ctx);
        }
    }

    public void detach() {
        this.weakContext = null;
    }

    protected int getVersionCode() {
        return Integer.parseInt(Constants.APP_VERSION);
    }

    protected JSONArray doInBackground(Void ... args) {
        block4: {
            Context context;
            Context context2 = context = this.weakContext != null ? (Context)this.weakContext.get() : null;
            if (context == null) {
                return null;
            }
            this.apkUrlString = this.getURLString(context, "apk");
            try {
                int versionCode = this.getVersionCode();
                URL url = new URL(this.getURLString(context, "json"));
                URLConnection connection = this.createConnection(url);
                connection.connect();
                BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
                String jsonString = Util.convertStreamToString(inputStream);
                ((InputStream)inputStream).close();
                JSONArray json = new JSONArray(jsonString);
                if (this.findNewVersion(context, json, versionCode)) {
                    json = this.limitResponseSize(json);
                    return json;
                }
            }
            catch (IOException | JSONException e) {
                if (!Util.isConnectedToNetwork(context)) break block4;
                HockeyLog.error("HockeyUpdate", "Could not fetch updates although connected to internet", e);
            }
        }
        return null;
    }

    protected URLConnection createConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.addRequestProperty("User-Agent", "HockeySDK/Android 5.1.0");
        return connection;
    }

    private boolean findNewVersion(Context context, JSONArray json, int versionCode) {
        try {
            boolean newerVersionFound = false;
            for (int index = 0; index < json.length(); ++index) {
                boolean minRequirementsMet;
                JSONObject entry = json.getJSONObject(index);
                boolean largerVersionCode = entry.getInt("version") > versionCode;
                boolean newerApkFile = entry.getInt("version") == versionCode && VersionHelper.isNewerThanLastUpdateTime(context, entry.getLong("timestamp"));
                boolean bl = minRequirementsMet = VersionHelper.compareVersionStrings(entry.getString("minimum_os_version"), VersionHelper.mapGoogleVersion(Build.VERSION.RELEASE)) <= 0;
                if (!largerVersionCode && !newerApkFile || !minRequirementsMet) continue;
                if (entry.has("mandatory")) {
                    this.mandatory = this.mandatory | entry.getBoolean("mandatory");
                }
                newerVersionFound = true;
            }
            return newerVersionFound;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private JSONArray limitResponseSize(JSONArray json) {
        JSONArray result = new JSONArray();
        for (int index = 0; index < Math.min(json.length(), 25); ++index) {
            try {
                result.put(json.get(index));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    protected void onPostExecute(JSONArray updateInfo) {
        if (updateInfo != null) {
            HockeyLog.verbose("HockeyUpdate", "Received Update Info");
            if (this.listener != null) {
                this.listener.onUpdateAvailable(updateInfo, this.apkUrlString);
            }
        } else {
            HockeyLog.verbose("HockeyUpdate", "No Update Info available");
            if (this.listener != null) {
                this.listener.onNoUpdateAvailable();
            }
        }
    }

    protected void cleanUp() {
        this.urlString = null;
        this.appIdentifier = null;
    }

    private String getURLString(Context context, String format) {
        String iuid;
        SharedPreferences prefs;
        String auid;
        StringBuilder builder = new StringBuilder();
        builder.append(this.urlString);
        builder.append("api/2/apps/");
        builder.append(this.appIdentifier != null ? this.appIdentifier : context.getPackageName());
        builder.append("?format=").append(format);
        String deviceIdentifier = null;
        try {
            deviceIdentifier = Constants.getDeviceIdentifier().get();
        }
        catch (InterruptedException | ExecutionException e) {
            HockeyLog.debug("Error get device identifier", e);
        }
        if (!TextUtils.isEmpty((CharSequence)deviceIdentifier)) {
            builder.append("&udid=").append(this.encodeParam(deviceIdentifier));
        }
        if (!TextUtils.isEmpty((CharSequence)(auid = (prefs = context.getSharedPreferences("net.hockeyapp.android.login", 0)).getString("auid", null)))) {
            builder.append("&auid=").append(this.encodeParam(auid));
        }
        if (!TextUtils.isEmpty((CharSequence)(iuid = prefs.getString("iuid", null)))) {
            builder.append("&iuid=").append(this.encodeParam(iuid));
        }
        builder.append("&os=Android");
        builder.append("&os_version=").append(this.encodeParam(Constants.ANDROID_VERSION));
        builder.append("&device=").append(this.encodeParam(Constants.PHONE_MODEL));
        builder.append("&oem=").append(this.encodeParam(Constants.PHONE_MANUFACTURER));
        builder.append("&app_version=").append(this.encodeParam(Constants.APP_VERSION));
        builder.append("&sdk=").append(this.encodeParam("HockeySDK"));
        builder.append("&sdk_version=").append(this.encodeParam("5.1.0"));
        builder.append("&lang=").append(this.encodeParam(Locale.getDefault().getLanguage()));
        builder.append("&usage_time=").append(this.usageTime);
        return builder.toString();
    }

    private String encodeParam(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

