/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.tasks;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.Queue;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.objects.FeedbackAttachment;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.ImageUtils;
import net.hockeyapp.android.views.AttachmentView;

public class AttachmentDownloader {
    private Queue<DownloadJob> queue;
    private boolean downloadRunning = false;
    private final Handler downloadHandler = new DownloadHandler(this);

    public static AttachmentDownloader getInstance() {
        return AttachmentDownloaderHolder.INSTANCE;
    }

    private AttachmentDownloader() {
        this.queue = new LinkedList<DownloadJob>();
    }

    public void download(FeedbackAttachment feedbackAttachment, AttachmentView attachmentView) {
        this.queue.add(new DownloadJob(feedbackAttachment, attachmentView));
        this.downloadNext();
    }

    private void downloadNext() {
        if (this.downloadRunning) {
            return;
        }
        DownloadJob downloadJob = this.queue.peek();
        if (downloadJob != null) {
            this.downloadRunning = true;
            AsyncTaskUtils.execute(new DownloadTask(downloadJob, this.downloadHandler));
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private static class DownloadTask
    extends AsyncTask<Void, Integer, Boolean> {
        private final DownloadJob downloadJob;
        private final Handler handler;
        private final Context context;
        private Bitmap bitmap;
        private int bitmapOrientation;

        DownloadTask(DownloadJob downloadJob, Handler handler) {
            this.downloadJob = downloadJob;
            this.handler = handler;
            this.context = downloadJob.getAttachmentView().getContext();
            this.bitmap = null;
            this.bitmapOrientation = 1;
        }

        protected void onPreExecute() {
        }

        protected Boolean doInBackground(Void ... args) {
            FeedbackAttachment attachment = this.downloadJob.getFeedbackAttachment();
            File file = new File(Constants.getHockeyAppStorageDir(this.context), attachment.getCacheId());
            if (file.exists()) {
                HockeyLog.error("Cached...");
                this.loadImageThumbnail(file);
                return true;
            }
            HockeyLog.error("Downloading...");
            boolean success = this.downloadAttachment(attachment.getUrl(), file);
            if (success) {
                this.loadImageThumbnail(file);
            }
            return success;
        }

        protected void onProgressUpdate(Integer ... values) {
        }

        protected void onPostExecute(Boolean success) {
            AttachmentView attachmentView = this.downloadJob.getAttachmentView();
            this.downloadJob.setSuccess(success);
            if (success.booleanValue()) {
                attachmentView.setImage(this.bitmap, this.bitmapOrientation);
            } else if (!this.downloadJob.hasRetry()) {
                attachmentView.signalImageLoadingError();
            }
            this.handler.sendEmptyMessage(0);
        }

        private void loadImageThumbnail(File file) {
            try {
                AttachmentView attachmentView = this.downloadJob.getAttachmentView();
                this.bitmapOrientation = ImageUtils.determineOrientation(file);
                int width = this.bitmapOrientation == 0 ? attachmentView.getWidthLandscape() : attachmentView.getWidthPortrait();
                int height = this.bitmapOrientation == 0 ? attachmentView.getMaxHeightLandscape() : attachmentView.getMaxHeightPortrait();
                this.bitmap = ImageUtils.decodeSampledBitmap(file, width, height);
            }
            catch (IOException e) {
                HockeyLog.error("Failed to load image thumbnail", e);
                this.bitmap = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean downloadAttachment(String url, File file) {
            InputStream input = null;
            OutputStream output = null;
            HttpURLConnection connection = null;
            try {
                int count;
                connection = (HttpURLConnection)this.createConnection(new URL(url));
                connection.connect();
                int lengthOfFile = connection.getContentLength();
                String status = connection.getHeaderField("Status");
                if (status != null && !status.startsWith("200")) {
                    boolean bl = false;
                    return bl;
                }
                input = new BufferedInputStream(connection.getInputStream());
                output = new FileOutputStream(file);
                byte[] data = new byte[1024];
                long total = 0L;
                while ((count = input.read(data)) != -1) {
                    this.publishProgress(new Integer[]{(int)((total += (long)count) * 100L / (long)lengthOfFile)});
                    output.write(data, 0, count);
                }
                output.flush();
                boolean bl = total > 0L;
                return bl;
            }
            catch (IOException e) {
                HockeyLog.error("Failed to download attachment to " + file, e);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }

        private URLConnection createConnection(URL url) throws IOException {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", "HockeySDK/Android 5.1.0");
            connection.setInstanceFollowRedirects(true);
            return connection;
        }
    }

    private static class DownloadJob {
        private final FeedbackAttachment feedbackAttachment;
        private final AttachmentView attachmentView;
        private boolean success;
        private int remainingRetries;

        private DownloadJob(FeedbackAttachment feedbackAttachment, AttachmentView attachmentView) {
            this.feedbackAttachment = feedbackAttachment;
            this.attachmentView = attachmentView;
            this.success = false;
            this.remainingRetries = 2;
        }

        FeedbackAttachment getFeedbackAttachment() {
            return this.feedbackAttachment;
        }

        AttachmentView getAttachmentView() {
            return this.attachmentView;
        }

        boolean isSuccess() {
            return this.success;
        }

        void setSuccess(boolean success) {
            this.success = success;
        }

        boolean hasRetry() {
            return this.remainingRetries > 0;
        }

        boolean consumeRetry() {
            return --this.remainingRetries >= 0;
        }
    }

    private static class DownloadHandler
    extends Handler {
        private final AttachmentDownloader downloader;

        DownloadHandler(AttachmentDownloader downloader) {
            this.downloader = downloader;
        }

        public void handleMessage(Message msg) {
            final DownloadJob retryCandidate = (DownloadJob)this.downloader.queue.poll();
            if (!retryCandidate.isSuccess() && retryCandidate.consumeRetry()) {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        DownloadHandler.this.downloader.queue.add(retryCandidate);
                        DownloadHandler.this.downloader.downloadNext();
                    }
                }, 3000L);
            }
            this.downloader.downloadRunning = false;
            this.downloader.downloadNext();
        }
    }

    private static class AttachmentDownloaderHolder {
        static final AttachmentDownloader INSTANCE = new AttachmentDownloader();

        private AttachmentDownloaderHolder() {
        }
    }
}

