/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.objects;

import android.content.Context;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.JSONDateUtils;
import org.json.JSONException;

public class CrashDetails {
    private static final String FIELD_CRASH_REPORTER_KEY = "CrashReporter Key";
    private static final String FIELD_APP_START_DATE = "Start Date";
    private static final String FIELD_APP_CRASH_DATE = "Date";
    private static final String FIELD_OS_VERSION = "Android";
    private static final String FIELD_OS_BUILD = "Android Build";
    private static final String FIELD_DEVICE_MANUFACTURER = "Manufacturer";
    private static final String FIELD_DEVICE_MODEL = "Model";
    private static final String FIELD_APP_PACKAGE = "Package";
    private static final String FIELD_APP_VERSION_NAME = "Version Name";
    private static final String FIELD_APP_VERSION_CODE = "Version Code";
    private static final String FIELD_THREAD_NAME = "Thread";
    private static final String FIELD_FORMAT = "Format";
    private static final String FIELD_FORMAT_VALUE = "Xamarin";
    private static final String FIELD_XAMARIN_CAUSED_BY = "Xamarin caused by: ";
    private final String crashIdentifier;
    private String reporterKey;
    private Date appStartDate;
    private Date appCrashDate;
    private String osVersion;
    private String osBuild;
    private String deviceManufacturer;
    private String deviceModel;
    private String appPackage;
    private String appVersionName;
    private String appVersionCode;
    private String threadName;
    private String throwableStackTrace;
    private Boolean isXamarinException;
    private String format;

    public CrashDetails(String crashIdentifier) {
        this.crashIdentifier = crashIdentifier;
        this.isXamarinException = false;
        this.throwableStackTrace = "";
    }

    public CrashDetails(String crashIdentifier, Throwable throwable) {
        this(crashIdentifier);
        this.isXamarinException = false;
        StringWriter stackTraceResult = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackTraceResult);
        throwable.printStackTrace(printWriter);
        this.throwableStackTrace = ((Object)stackTraceResult).toString();
    }

    public CrashDetails(String crashIdentifier, Throwable throwable, String managedExceptionString, Boolean isManagedException) {
        this(crashIdentifier);
        StringWriter stackTraceResult = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackTraceResult);
        this.isXamarinException = true;
        this.setFormat(FIELD_FORMAT_VALUE);
        if (isManagedException.booleanValue()) {
            printWriter.print(FIELD_XAMARIN_CAUSED_BY);
            throwable.printStackTrace(printWriter);
        } else if (!TextUtils.isEmpty((CharSequence)managedExceptionString)) {
            throwable.printStackTrace(printWriter);
            printWriter.print(FIELD_XAMARIN_CAUSED_BY);
            printWriter.print(managedExceptionString);
        } else {
            throwable.printStackTrace(printWriter);
        }
        this.throwableStackTrace = ((Object)stackTraceResult).toString();
    }

    public static CrashDetails fromFile(File file) throws IOException, JSONException {
        String crashIdentifier = file.getName().substring(0, file.getName().indexOf(".stacktrace"));
        return CrashDetails.fromReader(crashIdentifier, new FileReader(file));
    }

    public static CrashDetails fromReader(String crashIdentifier, Reader in) throws IOException, JSONException {
        String readLine;
        BufferedReader bufferedReader = new BufferedReader(in);
        CrashDetails result = new CrashDetails(crashIdentifier);
        boolean headersProcessed = false;
        StringBuilder stackTraceBuilder = new StringBuilder();
        while ((readLine = bufferedReader.readLine()) != null) {
            if (!headersProcessed) {
                if (readLine.isEmpty()) {
                    headersProcessed = true;
                    continue;
                }
                int colonIndex = readLine.indexOf(":");
                if (colonIndex < 0) {
                    HockeyLog.error("Malformed header line when parsing crash details: \"" + readLine + "\"");
                }
                String headerName = readLine.substring(0, colonIndex).trim();
                String headerValue = readLine.substring(colonIndex + 1, readLine.length()).trim();
                if (headerName.equals(FIELD_CRASH_REPORTER_KEY)) {
                    result.setReporterKey(headerValue);
                    continue;
                }
                if (headerName.equals(FIELD_APP_START_DATE)) {
                    try {
                        result.setAppStartDate(JSONDateUtils.toDate(headerValue));
                        continue;
                    }
                    catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (headerName.equals(FIELD_APP_CRASH_DATE)) {
                    try {
                        result.setAppCrashDate(JSONDateUtils.toDate(headerValue));
                        continue;
                    }
                    catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (headerName.equals(FIELD_OS_VERSION)) {
                    result.setOsVersion(headerValue);
                    continue;
                }
                if (headerName.equals(FIELD_OS_BUILD)) {
                    result.setOsBuild(headerValue);
                    continue;
                }
                if (headerName.equals(FIELD_DEVICE_MANUFACTURER)) {
                    result.setDeviceManufacturer(headerValue);
                    continue;
                }
                if (headerName.equals(FIELD_DEVICE_MODEL)) {
                    result.setDeviceModel(headerValue);
                    continue;
                }
                if (headerName.equals(FIELD_APP_PACKAGE)) {
                    result.setAppPackage(headerValue);
                    continue;
                }
                if (headerName.equals(FIELD_APP_VERSION_NAME)) {
                    result.setAppVersionName(headerValue);
                    continue;
                }
                if (headerName.equals(FIELD_APP_VERSION_CODE)) {
                    result.setAppVersionCode(headerValue);
                    continue;
                }
                if (headerName.equals(FIELD_THREAD_NAME)) {
                    result.setThreadName(headerValue);
                    continue;
                }
                if (!headerName.equals(FIELD_FORMAT)) continue;
                result.setFormat(headerValue);
                continue;
            }
            stackTraceBuilder.append(readLine).append("\n");
        }
        result.setThrowableStackTrace(stackTraceBuilder.toString());
        return result;
    }

    public void writeCrashReport(Context context) {
        File file = new File(context.getFilesDir(), this.crashIdentifier + ".stacktrace");
        try {
            this.writeCrashReport(file);
        }
        catch (JSONException e) {
            HockeyLog.error("Could not write crash report with error " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCrashReport(File file) throws JSONException {
        HockeyLog.debug("Writing unhandled exception to: " + file.getAbsolutePath());
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            this.writeHeader(writer, FIELD_APP_PACKAGE, this.appPackage);
            this.writeHeader(writer, FIELD_APP_VERSION_CODE, this.appVersionCode);
            this.writeHeader(writer, FIELD_APP_VERSION_NAME, this.appVersionName);
            this.writeHeader(writer, FIELD_OS_VERSION, this.osVersion);
            this.writeHeader(writer, FIELD_OS_BUILD, this.osBuild);
            this.writeHeader(writer, FIELD_DEVICE_MANUFACTURER, this.deviceManufacturer);
            this.writeHeader(writer, FIELD_DEVICE_MODEL, this.deviceModel);
            this.writeHeader(writer, FIELD_THREAD_NAME, this.threadName);
            this.writeHeader(writer, FIELD_CRASH_REPORTER_KEY, this.reporterKey);
            this.writeHeader(writer, FIELD_APP_START_DATE, JSONDateUtils.toString(this.appStartDate));
            this.writeHeader(writer, FIELD_APP_CRASH_DATE, JSONDateUtils.toString(this.appCrashDate));
            if (this.isXamarinException.booleanValue()) {
                this.writeHeader(writer, FIELD_FORMAT, FIELD_FORMAT_VALUE);
            }
            writer.write("\n");
            writer.write(this.throwableStackTrace);
            writer.flush();
        }
        catch (IOException e) {
            HockeyLog.error("Error saving crash report!", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                HockeyLog.error("Error saving crash report!", e1);
            }
        }
    }

    private void writeHeader(Writer writer, String name, String value) throws IOException {
        writer.write(name + ": " + value + "\n");
    }

    public String getCrashIdentifier() {
        return this.crashIdentifier;
    }

    public String getReporterKey() {
        return this.reporterKey;
    }

    public void setReporterKey(String reporterKey) {
        this.reporterKey = reporterKey;
    }

    public Date getAppStartDate() {
        return this.appStartDate;
    }

    public void setAppStartDate(Date appStartDate) {
        this.appStartDate = appStartDate;
    }

    public Date getAppCrashDate() {
        return this.appCrashDate;
    }

    public void setAppCrashDate(Date appCrashDate) {
        this.appCrashDate = appCrashDate;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getOsBuild() {
        return this.osBuild;
    }

    public void setOsBuild(String osBuild) {
        this.osBuild = osBuild;
    }

    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    public void setDeviceManufacturer(String deviceManufacturer) {
        this.deviceManufacturer = deviceManufacturer;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public String getAppPackage() {
        return this.appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppVersionName() {
        return this.appVersionName;
    }

    public void setAppVersionName(String appVersionName) {
        this.appVersionName = appVersionName;
    }

    public String getAppVersionCode() {
        return this.appVersionCode;
    }

    public void setAppVersionCode(String appVersionCode) {
        this.appVersionCode = appVersionCode;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getThrowableStackTrace() {
        return this.throwableStackTrace;
    }

    public void setThrowableStackTrace(String throwableStackTrace) {
        this.throwableStackTrace = throwableStackTrace;
    }

    public Boolean getIsXamarinException() {
        return this.isXamarinException;
    }

    public void setIsXamarinException(Boolean isXamarinException) {
        this.isXamarinException = isXamarinException;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

