/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.metrics.model;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.hockeyapp.android.metrics.JsonHelper;
import net.hockeyapp.android.metrics.model.TelemetryData;

public class EventData
extends TelemetryData {
    private int ver = 2;
    private String name;
    private Map<String, String> properties;
    private Map<String, Double> measurements;

    public EventData() {
        this.InitializeFields();
        this.SetupAttributes();
    }

    @Override
    public String getEnvelopeName() {
        return "Microsoft.ApplicationInsights.Event";
    }

    @Override
    public String getBaseType() {
        return "EventData";
    }

    public int getVer() {
        return this.ver;
    }

    @Override
    public void setVer(int value) {
        this.ver = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, String> value) {
        this.properties = value != null ? new LinkedHashMap<String, String>(value) : null;
    }

    public Map<String, Double> getMeasurements() {
        if (this.measurements == null) {
            this.measurements = new LinkedHashMap<String, Double>();
        }
        return this.measurements;
    }

    public void setMeasurements(Map<String, Double> value) {
        this.measurements = value != null ? new LinkedHashMap<String, Double>(value) : null;
    }

    @Override
    protected String serializeContent(Writer writer) throws IOException {
        String prefix = super.serializeContent(writer);
        writer.write(prefix + "\"ver\":");
        writer.write(JsonHelper.convert(this.ver));
        prefix = ",";
        writer.write(prefix + "\"name\":");
        writer.write(JsonHelper.convert(this.name));
        prefix = ",";
        if (this.properties != null) {
            writer.write(prefix + "\"properties\":");
            JsonHelper.writeDictionary(writer, this.properties);
            prefix = ",";
        }
        if (this.measurements != null) {
            writer.write(prefix + "\"measurements\":");
            JsonHelper.writeDictionary(writer, this.measurements);
            prefix = ",";
        }
        return prefix;
    }

    public void SetupAttributes() {
    }

    @Override
    protected void InitializeFields() {
        this.QualifiedName = "com.microsoft.applicationinsights.contracts.EventData";
    }
}

