/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.metrics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Point;
import android.os.AsyncTask;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.view.Display;
import android.view.WindowManager;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.metrics.model.Application;
import net.hockeyapp.android.metrics.model.Device;
import net.hockeyapp.android.metrics.model.IJsonSerializable;
import net.hockeyapp.android.metrics.model.Internal;
import net.hockeyapp.android.metrics.model.Session;
import net.hockeyapp.android.metrics.model.User;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.Util;

class TelemetryContext {
    private static final String TAG = "HockeyApp-Metrics";
    private static final String SHARED_PREFERENCES_KEY = "HOCKEY_APP_TELEMETRY_CONTEXT";
    private static final String SESSION_IS_FIRST_KEY = "SESSION_IS_FIRST";
    final Device mDevice;
    final Session mSession;
    final User mUser;
    final Internal mInternal;
    final Application mApplication;
    private final Object IKEY_LOCK = new Object();
    private WeakReference<Context> mWeakContext;
    private String mInstrumentationKey;
    private String mPackageName;

    private TelemetryContext() {
        this.mDevice = new Device();
        this.mSession = new Session();
        this.mUser = new User();
        this.mApplication = new Application();
        this.mInternal = new Internal();
    }

    @SuppressLint(value={"StaticFieldLeak"})
    TelemetryContext(Context context, String appIdentifier) {
        this();
        this.mWeakContext = new WeakReference<Context>(context);
        this.mInstrumentationKey = Util.convertAppIdentifierToGuid(appIdentifier);
        this.configDeviceContext();
        this.configInternalContext();
        this.configApplicationContext();
        AsyncTaskUtils.execute(new AsyncTask<Void, Object, Object>(){

            protected Object doInBackground(Void ... voids) {
                try {
                    String deviceId = Constants.getDeviceIdentifier().get();
                    TelemetryContext.this.setDeviceId(deviceId);
                    TelemetryContext.this.setAnonymousUserId(deviceId);
                }
                catch (InterruptedException | ExecutionException e) {
                    HockeyLog.debug("Error config device identifier", e);
                }
                return null;
            }
        });
    }

    void renewSessionContext(String sessionId) {
        this.configSessionContext(sessionId);
    }

    private void configSessionContext(String sessionId) {
        HockeyLog.debug(TAG, "Configuring session context");
        this.setSessionId(sessionId);
        HockeyLog.debug(TAG, "Setting the isNew-flag to true, as we only count new sessions");
        this.setIsNewSession("true");
        Context context = this.getContext();
        if (context == null) {
            HockeyLog.warn(TAG, "Failed to write to SharedPreferences, context is null");
            return;
        }
        SharedPreferences settings = context.getSharedPreferences(SHARED_PREFERENCES_KEY, 0);
        if (!settings.getBoolean(SESSION_IS_FIRST_KEY, false)) {
            SharedPreferences.Editor editor = settings.edit();
            editor.putBoolean(SESSION_IS_FIRST_KEY, true);
            editor.apply();
            this.setIsFirstSession("true");
            HockeyLog.debug(TAG, "It's our first session, writing true to SharedPreferences.");
        } else {
            this.setIsFirstSession("false");
            HockeyLog.debug(TAG, "It's not their first session, writing false to SharedPreferences.");
        }
    }

    private void configApplicationContext() {
        HockeyLog.debug(TAG, "Configuring application context");
        this.mPackageName = "";
        if (Constants.APP_PACKAGE != null) {
            this.mPackageName = Constants.APP_PACKAGE;
        }
        String version = String.format("%s (%S)", Constants.APP_VERSION_NAME, Constants.APP_VERSION);
        this.setAppVersion(version);
        String sdkVersionString = "5.1.0";
        this.setSdkVersion("android:" + sdkVersionString);
    }

    private void configDeviceContext() {
        TelephonyManager telephonyManager;
        HockeyLog.debug(TAG, "Configuring device context");
        this.setOsVersion(Build.VERSION.RELEASE);
        this.setOsName("Android");
        this.setDeviceModel(Build.MODEL);
        this.setDeviceOemName(Build.MANUFACTURER);
        this.setOsLocale(Locale.getDefault().toString());
        this.setOsLanguage(Locale.getDefault().getLanguage());
        this.updateScreenResolution();
        Context context = this.getContext();
        TelephonyManager telephonyManager2 = telephonyManager = context != null ? (TelephonyManager)context.getSystemService("phone") : null;
        if (telephonyManager == null || telephonyManager.getPhoneType() != 0) {
            this.setDeviceType("Phone");
        } else {
            this.setDeviceType("Tablet");
        }
        if (Util.isEmulator()) {
            this.setDeviceModel("[Emulator]" + this.mDevice.getModel());
        }
    }

    void updateScreenResolution() {
        Context context = this.getContext();
        if (context != null) {
            int height;
            int width;
            WindowManager wm = (WindowManager)context.getSystemService("window");
            if (Build.VERSION.SDK_INT >= 17) {
                Point size = new Point();
                Display d = wm.getDefaultDisplay();
                if (d != null) {
                    d.getRealSize(size);
                    width = size.x;
                    height = size.y;
                } else {
                    width = 0;
                    height = 0;
                }
            } else {
                try {
                    Method mGetRawW = Display.class.getMethod("getRawWidth", new Class[0]);
                    Method mGetRawH = Display.class.getMethod("getRawHeight", new Class[0]);
                    Display display = wm.getDefaultDisplay();
                    width = (Integer)mGetRawW.invoke((Object)display, new Object[0]);
                    height = (Integer)mGetRawH.invoke((Object)display, new Object[0]);
                }
                catch (Exception ex) {
                    Point size = new Point();
                    Display d = wm.getDefaultDisplay();
                    if (d != null) {
                        d.getSize(size);
                        width = size.x;
                        height = size.y;
                    } else {
                        width = 0;
                        height = 0;
                    }
                    HockeyLog.debug(TAG, "Couldn't determine screen resolution: " + ex.toString());
                }
            }
            String resolutionString = String.valueOf(height) + "x" + String.valueOf(width);
            this.setScreenResolution(resolutionString);
        }
    }

    void configInternalContext() {
        String sdkVersionString = "5.1.0";
        this.setSdkVersion("android:" + sdkVersionString);
    }

    private Context getContext() {
        return this.mWeakContext != null ? (Context)this.mWeakContext.get() : null;
    }

    protected String getPackageName() {
        return this.mPackageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getContextTags() {
        LinkedHashMap<String, String> contextTags = new LinkedHashMap<String, String>();
        IJsonSerializable iJsonSerializable = this.mApplication;
        synchronized (iJsonSerializable) {
            this.mApplication.addToHashMap(contextTags);
        }
        iJsonSerializable = this.mDevice;
        synchronized (iJsonSerializable) {
            this.mDevice.addToHashMap(contextTags);
        }
        iJsonSerializable = this.mSession;
        synchronized (iJsonSerializable) {
            this.mSession.addToHashMap(contextTags);
        }
        iJsonSerializable = this.mUser;
        synchronized (iJsonSerializable) {
            this.mUser.addToHashMap(contextTags);
        }
        iJsonSerializable = this.mInternal;
        synchronized (iJsonSerializable) {
            this.mInternal.addToHashMap(contextTags);
        }
        return contextTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInstrumentationKey() {
        Object object = this.IKEY_LOCK;
        synchronized (object) {
            return this.mInstrumentationKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInstrumentationKey(String instrumentationKey) {
        Object object = this.IKEY_LOCK;
        synchronized (object) {
            this.mInstrumentationKey = instrumentationKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenResolution() {
        Device device = this.mDevice;
        synchronized (device) {
            return this.mDevice.getScreenResolution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScreenResolution(String screenResolution) {
        Device device = this.mDevice;
        synchronized (device) {
            this.mDevice.setScreenResolution(screenResolution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAppVersion() {
        Application application = this.mApplication;
        synchronized (application) {
            return this.mApplication.getVer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppVersion(String appVersion) {
        Application application = this.mApplication;
        synchronized (application) {
            this.mApplication.setVer(appVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAnonymousUserId() {
        User user = this.mUser;
        synchronized (user) {
            return this.mUser.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnonymousUserId(String userId) {
        User user = this.mUser;
        synchronized (user) {
            this.mUser.setId(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSdkVersion() {
        Internal internal = this.mInternal;
        synchronized (internal) {
            return this.mInternal.getSdkVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSdkVersion(String sdkVersion) {
        Internal internal = this.mInternal;
        synchronized (internal) {
            this.mInternal.setSdkVersion(sdkVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionId() {
        Session session = this.mSession;
        synchronized (session) {
            return this.mSession.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionId(String sessionId) {
        Session session = this.mSession;
        synchronized (session) {
            this.mSession.setId(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIsFirstSession() {
        Session session = this.mSession;
        synchronized (session) {
            return this.mSession.getIsFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsFirstSession(String isFirst) {
        Session session = this.mSession;
        synchronized (session) {
            this.mSession.setIsFirst(isFirst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIsNewSession() {
        Session session = this.mSession;
        synchronized (session) {
            return this.mSession.getIsNew();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsNewSession(String isNewSession) {
        Session session = this.mSession;
        synchronized (session) {
            this.mSession.setIsNew(isNewSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOsVersion() {
        Device device = this.mDevice;
        synchronized (device) {
            return this.mDevice.getOsVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOsVersion(String osVersion) {
        Device device = this.mDevice;
        synchronized (device) {
            this.mDevice.setOsVersion(osVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOsName() {
        Device device = this.mDevice;
        synchronized (device) {
            return this.mDevice.getOs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOsName(String osName) {
        Device device = this.mDevice;
        synchronized (device) {
            this.mDevice.setOs(osName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeviceModel() {
        Device device = this.mDevice;
        synchronized (device) {
            return this.mDevice.getModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceModel(String deviceModel) {
        Device device = this.mDevice;
        synchronized (device) {
            this.mDevice.setModel(deviceModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeviceOemName() {
        Device device = this.mDevice;
        synchronized (device) {
            return this.mDevice.getOemName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceOemName(String deviceOemName) {
        Device device = this.mDevice;
        synchronized (device) {
            this.mDevice.setOemName(deviceOemName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOsLocale() {
        Device device = this.mDevice;
        synchronized (device) {
            return this.mDevice.getLocale();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOsLocale(String osLocale) {
        Device device = this.mDevice;
        synchronized (device) {
            this.mDevice.setLocale(osLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOSLanguage() {
        Device device = this.mDevice;
        synchronized (device) {
            return this.mDevice.getLanguage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOsLanguage(String osLanguage) {
        Device device = this.mDevice;
        synchronized (device) {
            this.mDevice.setLanguage(osLanguage);
        }
    }

    public String getDeviceId() {
        return this.mDevice.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceId(String deviceId) {
        Device device = this.mDevice;
        synchronized (device) {
            this.mDevice.setId(deviceId);
        }
    }

    public String getDeviceType() {
        return this.mDevice.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceType(String deviceType) {
        Device device = this.mDevice;
        synchronized (device) {
            this.mDevice.setType(deviceType);
        }
    }
}

