/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.metrics;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPOutputStream;
import net.hockeyapp.android.metrics.Persistence;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.HockeyLog;

public class Sender {
    static final String DEFAULT_ENDPOINT_URL = "https://gate.hockeyapp.net/v2/track";
    static final int DEFAULT_SENDER_READ_TIMEOUT = 10000;
    static final int DEFAULT_SENDER_CONNECT_TIMEOUT = 15000;
    static final int MAX_REQUEST_COUNT = 10;
    private static final String TAG = "HockeyApp-Metrics";
    protected WeakReference<Persistence> mWeakPersistence;
    private AtomicInteger mRequestCount = new AtomicInteger(0);
    private String mCustomServerURL;

    protected Sender() {
    }

    @SuppressLint(value={"StaticFieldLeak"})
    protected void triggerSending() {
        if (this.requestCount() < 10) {
            try {
                AsyncTaskUtils.execute(new AsyncTask<Void, Void, Void>(){

                    protected Void doInBackground(Void ... params) {
                        Sender.this.sendAvailableFiles();
                        return null;
                    }
                });
            }
            catch (RejectedExecutionException e) {
                HockeyLog.error("Could not send events. Executor rejected async task.", e);
            }
        } else {
            HockeyLog.debug(TAG, "We have already 10 pending requests, not sending anything.");
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    protected void triggerSendingForTesting(final HttpURLConnection connection, final File file, final String persistedData) {
        if (this.requestCount() < 10) {
            this.mRequestCount.getAndIncrement();
            AsyncTaskUtils.execute(new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    Sender.this.send(connection, file, persistedData);
                    return null;
                }
            });
        }
    }

    protected void sendAvailableFiles() {
        if (this.getPersistence() != null) {
            File fileToSend = this.getPersistence().nextAvailableFileInDirectory();
            String persistedData = this.loadData(fileToSend);
            HttpURLConnection connection = this.createConnection();
            if (persistedData != null && connection != null) {
                this.send(connection, fileToSend, persistedData);
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected void send(HttpURLConnection connection, File file, String persistedData) {
        block7: {
            if (connection != null && file != null && persistedData != null) {
                try {
                    this.mRequestCount.getAndIncrement();
                    this.logRequest(connection, persistedData);
                    connection.connect();
                    int responseCode = connection.getResponseCode();
                    this.onResponse(connection, responseCode, persistedData, file);
                }
                catch (IOException e) {
                    HockeyLog.debug(TAG, "Couldn't send data with " + e.toString());
                    this.mRequestCount.getAndDecrement();
                    if (this.getPersistence() != null) {
                        HockeyLog.debug(TAG, "Persisting because of IOException: We're probably offline.");
                        this.getPersistence().makeAvailable(file);
                    }
                }
                catch (SecurityException e) {
                    HockeyLog.debug(TAG, "Couldn't send data with " + e.toString());
                    this.mRequestCount.getAndDecrement();
                    if (this.getPersistence() != null) {
                        HockeyLog.debug(TAG, "Persisting because of SecurityException: Missing INTERNET permission or the user might have removed the internet permission.");
                        this.getPersistence().makeAvailable(file);
                    }
                }
                catch (Exception e) {
                    HockeyLog.debug(TAG, "Couldn't send data with " + e.toString());
                    this.mRequestCount.getAndDecrement();
                    if (this.getPersistence() == null) break block7;
                    HockeyLog.debug(TAG, "Persisting because of unknown exception.");
                    this.getPersistence().makeAvailable(file);
                }
            }
        }
    }

    protected String loadData(File file) {
        String persistedData = null;
        if (this.getPersistence() != null && file != null && (persistedData = this.getPersistence().load(file)) != null && persistedData.isEmpty()) {
            this.getPersistence().deleteFile(file);
        }
        return persistedData;
    }

    protected HttpURLConnection createConnection() {
        HttpURLConnection connection = null;
        try {
            URL url;
            if (this.getCustomServerURL() == null) {
                url = new URL(DEFAULT_ENDPOINT_URL);
            } else {
                url = new URL(this.mCustomServerURL);
                if (url == null) {
                    url = new URL(DEFAULT_ENDPOINT_URL);
                }
            }
            connection = (HttpURLConnection)url.openConnection();
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(15000);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-json-stream");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
        }
        catch (IOException e) {
            HockeyLog.error(TAG, "Could not open connection for provided URL with exception: ", e);
        }
        return connection;
    }

    protected void onResponse(HttpURLConnection connection, int responseCode, String payload, File fileToSend) {
        this.mRequestCount.getAndDecrement();
        HockeyLog.debug(TAG, "response code " + Integer.toString(responseCode));
        boolean isRecoverableError = this.isRecoverableError(responseCode);
        if (isRecoverableError) {
            HockeyLog.debug(TAG, "Recoverable error (probably a server error), persisting data:\n" + payload);
            if (this.getPersistence() != null) {
                this.getPersistence().makeAvailable(fileToSend);
            }
        } else {
            if (this.getPersistence() != null) {
                this.getPersistence().deleteFile(fileToSend);
            }
            StringBuilder builder = new StringBuilder();
            if (this.isExpected(responseCode)) {
                try {
                    InputStream inputStream = connection.getInputStream();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    HockeyLog.error(TAG, "Could not close input stream", e);
                }
                this.triggerSending();
            } else {
                this.onUnexpected(connection, responseCode, builder);
            }
        }
    }

    protected boolean isRecoverableError(int responseCode) {
        List<Integer> recoverableCodes = Arrays.asList(408, 429, 500, 503, 511);
        return recoverableCodes.contains(responseCode);
    }

    protected boolean isExpected(int responseCode) {
        return 200 <= responseCode && responseCode <= 203;
    }

    protected void onUnexpected(HttpURLConnection connection, int responseCode, StringBuilder builder) {
        String message = String.format(Locale.ROOT, "Unexpected response code: %d", responseCode);
        builder.append(message);
        builder.append("\n");
        HockeyLog.error(TAG, message);
        this.readResponse(connection, builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logRequest(HttpURLConnection connection, String payload) throws IOException, SecurityException {
        Writer writer = null;
        try {
            if (connection != null && payload != null) {
                HockeyLog.debug(TAG, "Sending payload:\n" + payload);
                HockeyLog.debug(TAG, "Using URL:" + connection.getURL().toString());
                writer = this.getWriter(connection);
                writer.write(payload);
                writer.flush();
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    HockeyLog.error(TAG, "Couldn't close writer with: " + e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readResponse(HttpURLConnection connection, StringBuilder builder) {
        StringBuilder buffer = new StringBuilder();
        InputStream inputStream = null;
        try {
            String result;
            inputStream = connection.getErrorStream();
            if (inputStream == null) {
                inputStream = connection.getInputStream();
            }
            if (inputStream != null) {
                String inputLine;
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((inputLine = br.readLine()) != null) {
                    buffer.append(inputLine);
                }
                result = buffer.toString();
            } else {
                result = connection.getResponseMessage();
            }
            if (!TextUtils.isEmpty((CharSequence)result)) {
                HockeyLog.verbose(result);
            } else {
                HockeyLog.verbose(TAG, "Couldn't log response, result is null or empty string");
            }
        }
        catch (IOException e) {
            HockeyLog.error(TAG, e.toString());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    HockeyLog.error(TAG, e.toString());
                }
            }
        }
    }

    @TargetApi(value=19)
    protected Writer getWriter(HttpURLConnection connection) throws IOException {
        if (Build.VERSION.SDK_INT >= 19) {
            connection.addRequestProperty("Content-Encoding", "gzip");
            connection.setRequestProperty("Content-Type", "application/x-json-stream");
            GZIPOutputStream gzip = new GZIPOutputStream(connection.getOutputStream(), true);
            return new OutputStreamWriter((OutputStream)gzip, "UTF-8");
        }
        return new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
    }

    protected Persistence getPersistence() {
        Persistence persistence = null;
        if (this.mWeakPersistence != null) {
            persistence = (Persistence)this.mWeakPersistence.get();
        }
        return persistence;
    }

    protected void setPersistence(Persistence persistence) {
        this.mWeakPersistence = new WeakReference<Persistence>(persistence);
    }

    protected int requestCount() {
        return this.mRequestCount.get();
    }

    protected String getCustomServerURL() {
        return this.mCustomServerURL;
    }

    protected void setCustomServerURL(String customServerURL) {
        this.mCustomServerURL = customServerURL;
    }
}

