/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.metrics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.UUID;
import net.hockeyapp.android.metrics.Sender;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.HockeyLog;

class Persistence {
    private static final String TAG = "HA-MetricsPersistence";
    private static final String BIT_TELEMETRY_DIRECTORY = "/net.hockeyapp.android/telemetry/";
    private static final Integer MAX_FILE_COUNT = 50;
    private final WeakReference<Context> mWeakContext;
    private WeakReference<Sender> mWeakSender;
    ArrayList<File> mServedFiles;

    Persistence(Context context, Sender sender) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mServedFiles = new ArrayList(MAX_FILE_COUNT + 1);
        this.mWeakSender = new WeakReference<Sender>(sender);
    }

    protected void persist(String[] data) {
        if (!this.isFreeSpaceAvailable()) {
            HockeyLog.warn(TAG, "Failed to persist file: Too many files on disk.");
        } else {
            StringBuilder buffer = new StringBuilder();
            for (String aData : data) {
                if (buffer.length() > 0) {
                    buffer.append('\n');
                }
                buffer.append(aData);
            }
            if (!this.writeToDisk(buffer.toString())) {
                return;
            }
        }
        Sender sender = this.getSender();
        if (sender != null) {
            sender.triggerSending();
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    void sendAvailable() {
        AsyncTaskUtils.execute(new AsyncTask<Void, Object, Object>(){

            protected Object doInBackground(Void ... voids) {
                Sender sender;
                if (Persistence.this.hasFilesAvailable() && (sender = Persistence.this.getSender()) != null) {
                    sender.triggerSending();
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeToDisk(String data) {
        File dir = this.getTelemetryDirectory();
        if (dir == null) {
            return false;
        }
        String uuid = UUID.randomUUID().toString();
        Boolean isSuccess = false;
        FileOutputStream outputStream = null;
        try {
            Persistence persistence = this;
            synchronized (persistence) {
                File file = new File(dir, uuid);
                outputStream = new FileOutputStream(file, true);
                outputStream.write(data.getBytes());
                HockeyLog.warn(TAG, "Saving data to: " + file.toString());
            }
            isSuccess = true;
        }
        catch (Exception e) {
            HockeyLog.warn(TAG, "Failed to save data with exception", e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String load(File file) {
        StringBuilder buffer = new StringBuilder();
        if (file != null) {
            BufferedReader reader = null;
            try {
                Persistence persistence = this;
                synchronized (persistence) {
                    int c;
                    FileInputStream inputStream = new FileInputStream(file);
                    InputStreamReader streamReader = new InputStreamReader(inputStream);
                    reader = new BufferedReader(streamReader);
                    while ((c = reader.read()) != -1) {
                        buffer.append((char)c);
                    }
                }
            }
            catch (Exception e) {
                HockeyLog.warn(TAG, "Error reading telemetry data from file", e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    protected boolean hasFilesAvailable() {
        File file = this.nextAvailableFileInDirectory();
        this.makeAvailable(file);
        return file != null;
    }

    protected synchronized File nextAvailableFileInDirectory() {
        File[] files;
        File dir = this.getTelemetryDirectory();
        File[] fileArray = files = dir != null ? dir.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (!this.mServedFiles.contains(file)) {
                    HockeyLog.info(TAG, "The directory " + file + " (ADDING TO SERVED AND RETURN)");
                    this.mServedFiles.add(file);
                    return file;
                }
                HockeyLog.info(TAG, "The directory " + file + " (WAS ALREADY SERVED)");
            }
        }
        HockeyLog.info(TAG, "The directory " + dir + " did not contain any unserved files");
        return null;
    }

    protected synchronized void deleteFile(File file) {
        if (file != null) {
            boolean deletedFile = file.delete();
            if (!deletedFile) {
                HockeyLog.warn(TAG, "Error deleting telemetry file " + file.toString());
            } else {
                HockeyLog.warn(TAG, "Successfully deleted telemetry file at: " + file.toString());
                this.mServedFiles.remove(file);
            }
        } else {
            HockeyLog.warn(TAG, "Couldn't delete file, the reference to the file was null");
        }
    }

    protected synchronized void makeAvailable(File file) {
        if (file != null) {
            this.mServedFiles.remove(file);
        }
    }

    private synchronized boolean isFreeSpaceAvailable() {
        File dir = this.getTelemetryDirectory();
        File[] files = dir != null ? dir.listFiles() : null;
        return files != null && files.length < MAX_FILE_COUNT;
    }

    protected File getTelemetryDirectory() {
        Context context = this.getContext();
        if (context != null && context.getFilesDir() != null) {
            File dir = new File(context.getFilesDir(), BIT_TELEMETRY_DIRECTORY);
            if (dir.exists() || dir.mkdirs()) {
                return dir;
            }
            HockeyLog.error("Couldn't create directory for telemetry data");
        }
        return null;
    }

    private Context getContext() {
        return (Context)this.mWeakContext.get();
    }

    protected Sender getSender() {
        return this.mWeakSender != null ? (Sender)this.mWeakSender.get() : null;
    }

    protected void setSender(Sender sender) {
        this.mWeakSender = new WeakReference<Sender>(sender);
    }
}

