/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.metrics;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.hockeyapp.android.metrics.Persistence;
import net.hockeyapp.android.metrics.TelemetryContext;
import net.hockeyapp.android.metrics.model.Base;
import net.hockeyapp.android.metrics.model.Data;
import net.hockeyapp.android.metrics.model.Domain;
import net.hockeyapp.android.metrics.model.Envelope;
import net.hockeyapp.android.metrics.model.TelemetryData;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.Util;

class Channel {
    private static final String TAG = "HockeyApp-Metrics";
    protected static final int MAX_BATCH_COUNT = 50;
    protected static final int MAX_BATCH_INTERVAL = 15000;
    protected static final int MAX_BATCH_COUNT_DEBUG = 5;
    protected static final int MAX_BATCH_INTERVAL_DEBUG = 3000;
    protected final List<String> mQueue;
    protected final TelemetryContext mTelemetryContext;
    private final Persistence mPersistence;
    private final Timer mTimer;
    private SynchronizeChannelTask mSynchronizeTask;

    static int getMaxBatchCount() {
        return Util.isDebuggerConnected() ? 5 : 50;
    }

    static int getMaxBatchInterval() {
        return Util.isDebuggerConnected() ? 3000 : 15000;
    }

    public Channel(TelemetryContext telemetryContext, Persistence persistence) {
        this.mTelemetryContext = telemetryContext;
        this.mQueue = new LinkedList<String>();
        this.mPersistence = persistence;
        this.mTimer = new Timer("HockeyApp User Metrics Sender Queue", true);
    }

    protected synchronized void enqueue(String serializedItem) {
        if (serializedItem == null) {
            return;
        }
        if (this.mQueue.add(serializedItem)) {
            if (this.mQueue.size() >= Channel.getMaxBatchCount()) {
                this.synchronize();
            } else if (this.mQueue.size() == 1) {
                this.scheduleSynchronizeTask();
            }
        } else {
            HockeyLog.verbose(TAG, "Unable to add item to queue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronize() {
        if (this.mSynchronizeTask != null) {
            this.mSynchronizeTask.cancel();
        }
        String[] data = null;
        Channel channel = this;
        synchronized (channel) {
            if (!this.mQueue.isEmpty()) {
                data = new String[this.mQueue.size()];
                this.mQueue.toArray(data);
                this.mQueue.clear();
            }
        }
        if (this.mPersistence != null && data != null) {
            this.mPersistence.persist(data);
        }
    }

    protected Envelope createEnvelope(Data<Domain> data) {
        Envelope envelope = new Envelope();
        envelope.setData(data);
        Domain baseData = data.getBaseData();
        if (baseData instanceof TelemetryData) {
            String envelopeName = ((TelemetryData)baseData).getEnvelopeName();
            envelope.setName(envelopeName);
        }
        this.mTelemetryContext.updateScreenResolution();
        envelope.setTime(Util.dateToISO8601(new Date()));
        envelope.setIKey(this.mTelemetryContext.getInstrumentationKey());
        Map<String, String> tags = this.mTelemetryContext.getContextTags();
        if (tags != null) {
            envelope.setTags(tags);
        }
        return envelope;
    }

    protected void scheduleSynchronizeTask() {
        this.mSynchronizeTask = new SynchronizeChannelTask();
        this.mTimer.schedule((TimerTask)this.mSynchronizeTask, Channel.getMaxBatchInterval());
    }

    public void enqueueData(Base data) {
        if (data instanceof Data) {
            Envelope envelope = null;
            try {
                envelope = this.createEnvelope((Data)data);
            }
            catch (ClassCastException e) {
                HockeyLog.debug(TAG, "Telemetry not enqueued, could not create envelope, must be of type ITelemetry");
            }
            if (envelope != null) {
                String serializedEnvelope = this.serializeEnvelope(envelope);
                this.enqueue(serializedEnvelope);
                HockeyLog.debug(TAG, "enqueued telemetry: " + envelope.getName());
            }
        } else {
            HockeyLog.debug(TAG, "Telemetry not enqueued, must be of type ITelemetry");
        }
    }

    protected String serializeEnvelope(Envelope envelope) {
        try {
            if (envelope != null) {
                StringWriter stringWriter = new StringWriter();
                envelope.serialize(stringWriter);
                return stringWriter.toString();
            }
            HockeyLog.debug(TAG, "Envelope wasn't empty but failed to serialize anything, returning null");
            return null;
        }
        catch (IOException e) {
            HockeyLog.debug(TAG, "Failed to save data with exception: " + e.toString());
            return null;
        }
    }

    private class SynchronizeChannelTask
    extends TimerTask {
        SynchronizeChannelTask() {
        }

        @Override
        public void run() {
            Channel.this.synchronize();
        }
    }
}

