/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.Toast;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.hockeyapp.android.R;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.ImageUtils;
import net.hockeyapp.android.views.PaintView;

public class PaintActivity
extends Activity {
    public static final String EXTRA_IMAGE_URI = "imageUri";
    private static final int MENU_SAVE_ID = 1;
    private static final int MENU_UNDO_ID = 2;
    private static final int MENU_CLEAR_ID = 3;
    private PaintView mPaintView;
    private Uri mImageUri;

    @SuppressLint(value={"StaticFieldLeak"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getIntent().getExtras();
        if (extras == null || extras.getParcelable(EXTRA_IMAGE_URI) == null) {
            HockeyLog.error("Can't set up PaintActivity as image extra was not provided!");
            return;
        }
        this.mImageUri = (Uri)extras.getParcelable(EXTRA_IMAGE_URI);
        AsyncTaskUtils.execute(new AsyncTask<Void, Object, Integer>(){

            protected Integer doInBackground(Void ... voids) {
                return ImageUtils.determineOrientation((Context)PaintActivity.this, PaintActivity.this.mImageUri);
            }

            protected void onPostExecute(Integer desiredOrientation) {
                int currentOrientation;
                PaintActivity.this.setRequestedOrientation(desiredOrientation);
                int displayWidth = PaintActivity.this.getResources().getDisplayMetrics().widthPixels;
                int displayHeight = PaintActivity.this.getResources().getDisplayMetrics().heightPixels;
                int n = currentOrientation = displayWidth > displayHeight ? 0 : 1;
                if (currentOrientation != desiredOrientation) {
                    HockeyLog.debug("Image loading skipped because activity will be destroyed for orientation change.");
                    return;
                }
                PaintActivity.this.showPaintView();
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        menu.add(0, 1, 0, (CharSequence)this.getString(R.string.hockeyapp_paint_menu_save));
        menu.add(0, 2, 0, (CharSequence)this.getString(R.string.hockeyapp_paint_menu_undo));
        menu.add(0, 3, 0, (CharSequence)this.getString(R.string.hockeyapp_paint_menu_clear));
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 1: {
                this.makeResult();
                return true;
            }
            case 2: {
                this.mPaintView.undo();
                return true;
            }
            case 3: {
                this.mPaintView.clearImage();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && !this.mPaintView.isClear()) {
            DialogInterface.OnClickListener dialogClickListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    switch (which) {
                        case -1: {
                            PaintActivity.this.makeResult();
                            break;
                        }
                        case -2: {
                            PaintActivity.this.finish();
                            break;
                        }
                    }
                }
            };
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setMessage(R.string.hockeyapp_paint_dialog_message).setPositiveButton(R.string.hockeyapp_paint_dialog_positive_button, dialogClickListener).setNegativeButton(R.string.hockeyapp_paint_dialog_negative_button, dialogClickListener).setNeutralButton(R.string.hockeyapp_paint_dialog_neutral_button, dialogClickListener).show();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void showPaintView() {
        int displayWidth = this.getResources().getDisplayMetrics().widthPixels;
        int displayHeight = this.getResources().getDisplayMetrics().heightPixels;
        this.mPaintView = new PaintView((Context)this, this.mImageUri, displayWidth, displayHeight);
        LinearLayout vLayout = new LinearLayout((Context)this);
        LinearLayout.LayoutParams vParams = new LinearLayout.LayoutParams(-1, -1);
        vLayout.setLayoutParams((ViewGroup.LayoutParams)vParams);
        vLayout.setGravity(17);
        vLayout.setOrientation(1);
        LinearLayout hLayout = new LinearLayout((Context)this);
        LinearLayout.LayoutParams hParams = new LinearLayout.LayoutParams(-1, -1);
        hLayout.setLayoutParams((ViewGroup.LayoutParams)hParams);
        hLayout.setGravity(17);
        hLayout.setOrientation(0);
        vLayout.addView((View)hLayout);
        hLayout.addView((View)this.mPaintView);
        this.setContentView((View)vLayout);
        Toast toast = Toast.makeText((Context)this, (int)R.string.hockeyapp_paint_indicator_toast, (int)1);
        toast.show();
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void makeResult() {
        this.mPaintView.setDrawingCacheEnabled(true);
        final Bitmap bitmap = this.mPaintView.getDrawingCache();
        AsyncTaskUtils.execute(new AsyncTask<Void, Object, Boolean>(){
            File result;

            protected Boolean doInBackground(Void ... args) {
                File hockeyAppCache = new File(PaintActivity.this.getCacheDir(), "HockeyApp");
                if (!hockeyAppCache.exists() && !hockeyAppCache.mkdir()) {
                    return false;
                }
                String imageName = PaintActivity.this.determineFilename(PaintActivity.this.mImageUri, PaintActivity.this.mImageUri.getLastPathSegment());
                String filename = imageName + ".jpg";
                this.result = new File(hockeyAppCache, filename);
                int suffix = 1;
                while (this.result.exists()) {
                    this.result = new File(hockeyAppCache, imageName + "_" + suffix + ".jpg");
                    ++suffix;
                }
                try {
                    FileOutputStream out = new FileOutputStream(this.result);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
                    out.close();
                }
                catch (IOException e) {
                    HockeyLog.error("Could not save image.", e);
                    return false;
                }
                return true;
            }

            protected void onPostExecute(Boolean success) {
                if (success.booleanValue()) {
                    Intent intent = new Intent();
                    Uri uri = Uri.fromFile((File)this.result);
                    intent.putExtra(PaintActivity.EXTRA_IMAGE_URI, (Parcelable)uri);
                    if (PaintActivity.this.getParent() == null) {
                        PaintActivity.this.setResult(-1, intent);
                    } else {
                        PaintActivity.this.getParent().setResult(-1, intent);
                    }
                } else if (PaintActivity.this.getParent() == null) {
                    PaintActivity.this.setResult(0);
                } else {
                    PaintActivity.this.getParent().setResult(0);
                }
                PaintActivity.this.finish();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String determineFilename(Uri uri, String fallback) {
        String[] projection = new String[]{"_data"};
        String path = null;
        ContentResolver cr = this.getApplicationContext().getContentResolver();
        Cursor metaCursor = cr.query(uri, projection, null, null, null);
        if (metaCursor != null) {
            try {
                if (metaCursor.moveToFirst()) {
                    path = metaCursor.getString(0);
                }
            }
            finally {
                metaCursor.close();
            }
        }
        return path == null ? fallback : new File(path).getName();
    }
}

