/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.LoginActivity;
import net.hockeyapp.android.LoginManagerListener;
import net.hockeyapp.android.tasks.LoginTask;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.Util;

public class LoginManager {
    public static final int LOGIN_MODE_ANONYMOUS = 0;
    public static final int LOGIN_MODE_EMAIL_ONLY = 1;
    public static final int LOGIN_MODE_EMAIL_PASSWORD = 2;
    public static final int LOGIN_MODE_VALIDATE = 3;
    static Class<?> mainActivity;
    static LoginManagerListener listener;
    private static String identifier;
    private static String secret;
    private static Handler validateHandler;
    private static String urlString;
    private static int mode;

    public static void register(Context context, String appSecret, int mode) {
        String appIdentifier = Util.getAppIdentifier(context);
        LoginManager.register(context, appIdentifier, appSecret, mode, (Class)null);
    }

    public static void register(Context context, String appSecret, int mode, LoginManagerListener listener) {
        String appIdentifier = Util.getAppIdentifier(context);
        LoginManager.register(context, appIdentifier, appSecret, mode, listener);
    }

    public static void register(Context context, String appIdentifier, String appSecret, int mode, LoginManagerListener listener) {
        LoginManager.listener = listener;
        LoginManager.register(context, appIdentifier, appSecret, mode, (Class)null);
    }

    public static void register(Context context, String appIdentifier, String appSecret, int mode, Class<?> activity) {
        LoginManager.register(context, appIdentifier, appSecret, "https://sdk.hockeyapp.net/", mode, activity);
    }

    public static void register(Context context, String appIdentifier, String appSecret, String urlString, int mode, Class<?> activity) {
        if (context != null) {
            identifier = Util.sanitizeAppIdentifier(appIdentifier);
            secret = appSecret;
            LoginManager.urlString = urlString;
            LoginManager.mode = mode;
            mainActivity = activity;
            if (validateHandler == null) {
                validateHandler = new LoginHandler(context);
            }
            Constants.loadFromContext(context);
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    public static void verifyLogin(final Activity context, Intent intent) {
        if (context == null || mode == 0) {
            return;
        }
        AsyncTaskUtils.execute(new AsyncTask<Void, Object, Object>(){
            private String auid;
            private String iuid;

            protected Object doInBackground(Void ... voids) {
                SharedPreferences prefs = context.getSharedPreferences("net.hockeyapp.android.login", 0);
                int currentMode = prefs.getInt("mode", -1);
                if (currentMode != mode) {
                    HockeyLog.verbose("HockeyAuth", "Mode has changed, require re-auth.");
                    prefs.edit().remove("auid").remove("iuid").putInt("mode", mode).apply();
                }
                this.auid = prefs.getString("auid", null);
                this.iuid = prefs.getString("iuid", null);
                return null;
            }

            protected void onPostExecute(Object o) {
                boolean iuidMissing;
                boolean notAuthenticated = this.auid == null && this.iuid == null;
                boolean auidMissing = this.auid == null && (mode == 2 || mode == 3);
                boolean bl = iuidMissing = this.iuid == null && mode == 1;
                if (notAuthenticated || auidMissing || iuidMissing) {
                    HockeyLog.verbose("HockeyAuth", "Not authenticated or correct ID missing, re-authenticate.");
                    LoginManager.startLoginActivity((Context)context);
                    return;
                }
                if (mode == 3) {
                    HockeyLog.verbose("HockeyAuth", "LOGIN_MODE_VALIDATE, Validate the user's info!");
                    HashMap<String, String> params = new HashMap<String, String>();
                    if (this.auid != null) {
                        params.put("type", "auid");
                        params.put("id", this.auid);
                    } else if (this.iuid != null) {
                        params.put("type", "iuid");
                        params.put("id", this.iuid);
                    }
                    LoginTask verifyTask = new LoginTask((Context)context, validateHandler, LoginManager.getURLString(3), 3, params);
                    verifyTask.setShowProgressDialog(false);
                    AsyncTaskUtils.execute(verifyTask);
                }
            }
        });
    }

    public static String getLoginEmail(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("net.hockeyapp.android.login", 0);
        return prefs.getString("email", null);
    }

    private static void startLoginActivity(Context context) {
        Intent intent = new Intent();
        Boolean isLoginModeValidate = mode == 3;
        int tempMode = isLoginModeValidate != false ? 2 : mode;
        intent.setFlags(0x14000000);
        intent.setClass(context, LoginActivity.class);
        intent.putExtra("url", LoginManager.getURLString(tempMode));
        intent.putExtra("mode", tempMode);
        intent.putExtra("secret", secret);
        context.startActivity(intent);
    }

    private static String getURLString(int mode) {
        String suffix = "";
        if (mode == 2) {
            suffix = "authorize";
        } else if (mode == 1) {
            suffix = "check";
        } else if (mode == 3) {
            suffix = "validate";
        }
        return urlString + "api/3/apps/" + identifier + "/identity/" + suffix;
    }

    static {
        identifier = null;
        secret = null;
        validateHandler = null;
        urlString = null;
    }

    private static class LoginHandler
    extends Handler {
        private final WeakReference<Context> mWeakContext;

        LoginHandler(Context context) {
            this.mWeakContext = new WeakReference<Context>(context);
        }

        public void handleMessage(Message msg) {
            Bundle bundle = msg.getData();
            boolean success = bundle.getBoolean("success");
            Context context = (Context)this.mWeakContext.get();
            if (context == null) {
                return;
            }
            if (!success) {
                LoginManager.startLoginActivity(context);
            } else {
                HockeyLog.verbose("HockeyAuth", "We authenticated or verified successfully");
            }
        }
    }
}

