/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.Toast;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.FeedbackActivity;
import net.hockeyapp.android.FeedbackManagerListener;
import net.hockeyapp.android.R;
import net.hockeyapp.android.objects.FeedbackUserDataElement;
import net.hockeyapp.android.tasks.ParseFeedbackTask;
import net.hockeyapp.android.tasks.SendFeedbackTask;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.PrefsUtil;
import net.hockeyapp.android.utils.Util;

public class FeedbackManager {
    public static final int SCREENSHOT_NOTIFICATION_ID = 1;
    public static final int NEW_ANSWER_NOTIFICATION_ID = 2;
    public static final String NOTIFICATION_CHANNEL_ID = "net.hockeyapp.android.NOTIFICATION";
    private static final int BROADCAST_REQUEST_CODE = 1;
    private static final String BROADCAST_ACTION = "net.hockeyapp.android.SCREENSHOT";
    private static BroadcastReceiver receiver = null;
    private static WeakReference<Activity> weakActivity;
    private static boolean notificationActive;
    private static String identifier;
    private static String urlString;
    private static FeedbackUserDataElement requireUserName;
    private static FeedbackUserDataElement requireUserEmail;
    private static String userName;
    private static String userEmail;
    private static String userId;
    private static FeedbackManagerListener lastListener;

    public static void register(Context context) {
        String appIdentifier = Util.getAppIdentifier(context);
        FeedbackManager.register(context, appIdentifier);
    }

    public static void register(Context context, FeedbackManagerListener listener) {
        String appIdentifier = Util.getAppIdentifier(context);
        FeedbackManager.register(context, appIdentifier, listener);
    }

    public static void register(Context context, String appIdentifier) {
        FeedbackManager.register(context, appIdentifier, null);
    }

    public static void register(Context context, String appIdentifier, FeedbackManagerListener listener) {
        FeedbackManager.register(context, "https://sdk.hockeyapp.net/", appIdentifier, listener);
    }

    public static void register(Context context, String urlString, String appIdentifier, FeedbackManagerListener listener) {
        if (context != null) {
            identifier = Util.sanitizeAppIdentifier(appIdentifier);
            FeedbackManager.urlString = urlString;
            lastListener = listener;
            Constants.loadFromContext(context);
        }
    }

    public static void unregister() {
        lastListener = null;
    }

    public static void showFeedbackActivity(Context context, Uri ... attachments) {
        FeedbackManager.showFeedbackActivity(context, null, attachments);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    public static void showFeedbackActivity(final Context context, final Bundle extras, final Uri ... attachments) {
        if (urlString == null || identifier == null) {
            HockeyLog.error("FeedbackManager hasn't been registered.");
            return;
        }
        if (context != null) {
            final Class<? extends FeedbackActivity> activityClass = lastListener != null ? lastListener.getFeedbackActivityClass() : null;
            final boolean forceNewThread = lastListener != null && lastListener.shouldCreateNewFeedbackThread();
            AsyncTaskUtils.execute(new AsyncTask<Void, Object, Intent>(){

                protected Intent doInBackground(Void ... voids) {
                    String[] nameEmailSubjectArray;
                    Intent intent = new Intent();
                    if (extras != null && !extras.isEmpty()) {
                        intent.putExtras(extras);
                    }
                    intent.setFlags(0x10000000);
                    intent.setClass(context, activityClass != null ? activityClass : FeedbackActivity.class);
                    intent.putExtra("url", FeedbackManager.getURLString());
                    String token = !forceNewThread ? PrefsUtil.getInstance().getFeedbackTokenFromPrefs(context) : null;
                    intent.putExtra("token", token);
                    intent.putExtra("forceNewThread", forceNewThread);
                    String userName = userName;
                    String userEmail = userEmail;
                    String userSubject = null;
                    String nameEmailSubject = PrefsUtil.getInstance().getNameEmailFromPrefs(context);
                    if (nameEmailSubject != null && (nameEmailSubjectArray = nameEmailSubject.split("\\|")) != null && nameEmailSubjectArray.length >= 2) {
                        userName = nameEmailSubjectArray[0];
                        userEmail = nameEmailSubjectArray[1];
                        if (!forceNewThread && nameEmailSubjectArray.length >= 3) {
                            userSubject = nameEmailSubjectArray[2];
                        }
                    }
                    intent.putExtra("initialUserName", userName);
                    intent.putExtra("initialUserEmail", userEmail);
                    intent.putExtra("initialUserSubject", userSubject);
                    intent.putExtra("initialAttachments", (Parcelable[])this.getInitialAttachments(attachments));
                    intent.putExtra("userId", userId);
                    return intent;
                }

                protected void onPostExecute(Intent intent) {
                    context.startActivity(intent);
                }

                private Uri[] getInitialAttachments(Uri[] userAttachments) {
                    ArrayList<Uri> initialAttachments = new ArrayList<Uri>();
                    File[] screenshots = this.searchScreenshots();
                    if (screenshots != null) {
                        for (File screenshot : screenshots) {
                            initialAttachments.add(Uri.fromFile((File)screenshot));
                        }
                    }
                    if (attachments != null && attachments.length > 0) {
                        initialAttachments.addAll(Arrays.asList(attachments));
                    }
                    if (initialAttachments.size() > 0) {
                        return initialAttachments.toArray(new Uri[0]);
                    }
                    return null;
                }

                private File[] searchScreenshots() {
                    File dir = Constants.getHockeyAppStorageDir(context);
                    if (dir != null) {
                        return dir.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.endsWith(".jpg");
                            }
                        });
                    }
                    return null;
                }
            });
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    public static void checkForAnswersAndNotify(final Context context) {
        if (urlString == null || identifier == null) {
            HockeyLog.error("FeedbackManager hasn't been registered.");
            return;
        }
        String token = PrefsUtil.getInstance().getFeedbackTokenFromPrefs(context);
        if (token == null) {
            return;
        }
        int lastMessageId = context.getSharedPreferences("net.hockeyapp.android.feedback", 0).getInt("idLastMessageSend", -1);
        SendFeedbackTask sendFeedbackTask = new SendFeedbackTask(context, FeedbackManager.getURLString(), null, null, null, null, null, null, token, null, true){

            @Override
            protected void onPostExecute(HashMap<String, String> result) {
                super.onPostExecute(result);
                String responseString = result.get("response");
                if (responseString != null) {
                    ParseFeedbackTask task = new ParseFeedbackTask(context, responseString, null, "fetch");
                    task.setUrlString(FeedbackManager.getURLString());
                    AsyncTaskUtils.execute(task);
                }
            }
        };
        sendFeedbackTask.setShowProgressDialog(false);
        sendFeedbackTask.setLastMessageId(lastMessageId);
        AsyncTaskUtils.execute(sendFeedbackTask);
    }

    public static FeedbackManagerListener getLastListener() {
        return lastListener;
    }

    private static String getURLString() {
        if (urlString == null || identifier == null) {
            HockeyLog.error("FeedbackManager hasn't been registered.");
            return null;
        }
        return urlString + "api/2/apps/" + identifier + "/feedback/";
    }

    public static FeedbackUserDataElement getRequireUserName() {
        return requireUserName;
    }

    public static void setRequireUserName(FeedbackUserDataElement requireUserName) {
        FeedbackManager.requireUserName = requireUserName;
    }

    public static FeedbackUserDataElement getRequireUserEmail() {
        return requireUserEmail;
    }

    public static void setRequireUserEmail(FeedbackUserDataElement requireUserEmail) {
        FeedbackManager.requireUserEmail = requireUserEmail;
    }

    public static void setUserName(String userName) {
        FeedbackManager.userName = userName;
    }

    public static void setUserEmail(String userEmail) {
        FeedbackManager.userEmail = userEmail;
    }

    public static void setUserId(String userId) {
        FeedbackManager.userId = userId;
    }

    public static void setActivityForScreenshot(Activity activity) {
        weakActivity = new WeakReference<Activity>(activity);
        if (!notificationActive) {
            FeedbackManager.startScreenshotNotification();
        }
    }

    public static void unsetCurrentActivityForScreenshot(Activity activity) {
        Activity currentActivity = FeedbackManager.getCurrentActivity();
        if (currentActivity == null || currentActivity != activity) {
            return;
        }
        FeedbackManager.endScreenshotNotification();
        weakActivity = null;
    }

    @SuppressLint(value={"StaticFieldLeak"})
    public static void takeScreenshot(final Context context) {
        Activity currentActivity = FeedbackManager.getCurrentActivity();
        if (currentActivity == null) {
            return;
        }
        View view = currentActivity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        final Bitmap bitmap = view.getDrawingCache();
        final String filename = currentActivity.getLocalClassName();
        AsyncTaskUtils.execute(new AsyncTask<Void, Void, Boolean>(){
            File result;

            protected Boolean doInBackground(Void ... args) {
                File dir = Constants.getHockeyAppStorageDir(context);
                this.result = new File(dir, filename + ".jpg");
                int suffix = 1;
                while (this.result.exists()) {
                    this.result = new File(dir, filename + "_" + suffix + ".jpg");
                    ++suffix;
                }
                try {
                    FileOutputStream out = new FileOutputStream(this.result);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
                    out.close();
                    HockeyLog.debug("Screenshot '" + this.result.getName() + "' has been saved");
                    return true;
                }
                catch (IOException e) {
                    HockeyLog.error("Could not save screenshot.", e);
                    return false;
                }
            }

            protected void onPostExecute(Boolean success) {
                if (!success.booleanValue()) {
                    Toast.makeText((Context)context, (int)R.string.hockeyapp_feedback_screenshot_fail, (int)1).show();
                }
            }
        });
    }

    private static void startScreenshotNotification() {
        Activity currentActivity = FeedbackManager.getCurrentActivity();
        if (currentActivity == null) {
            return;
        }
        notificationActive = true;
        int iconId = currentActivity.getResources().getIdentifier("ic_menu_camera", "drawable", "android");
        Intent intent = new Intent();
        intent.setAction(BROADCAST_ACTION);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)currentActivity, (int)1, (Intent)intent, (int)0x40000000);
        Notification notification = Util.createNotification((Context)currentActivity, pendingIntent, currentActivity.getString(R.string.hockeyapp_feedback_notification_title), currentActivity.getString(R.string.hockeyapp_feedback_screenshot_notification_message), iconId, NOTIFICATION_CHANNEL_ID);
        Util.sendNotification((Context)currentActivity, 1, notification, NOTIFICATION_CHANNEL_ID, currentActivity.getString(R.string.hockeyapp_feedback_notification_channel));
        if (receiver == null) {
            receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    FeedbackManager.takeScreenshot(context);
                }
            };
        }
        currentActivity.registerReceiver(receiver, new IntentFilter(BROADCAST_ACTION));
    }

    private static void endScreenshotNotification() {
        Activity currentActivity = FeedbackManager.getCurrentActivity();
        if (currentActivity == null) {
            return;
        }
        notificationActive = false;
        currentActivity.unregisterReceiver(receiver);
        Util.cancelNotification((Context)currentActivity, 1);
    }

    private static Activity getCurrentActivity() {
        return weakActivity != null ? (Activity)weakActivity.get() : null;
    }

    static {
        notificationActive = false;
        identifier = null;
        urlString = null;
        requireUserName = FeedbackUserDataElement.REQUIRED;
        requireUserEmail = FeedbackUserDataElement.REQUIRED;
        lastListener = null;
    }

    private static class MediaScannerClient
    implements MediaScannerConnection.MediaScannerConnectionClient {
        private MediaScannerConnection connection = null;
        private String path;

        private MediaScannerClient(String path) {
            this.path = path;
        }

        public void setConnection(MediaScannerConnection connection) {
            this.connection = connection;
        }

        public void onMediaScannerConnected() {
            if (this.connection != null) {
                this.connection.scanFile(this.path, null);
            }
        }

        public void onScanCompleted(String path, Uri uri) {
            HockeyLog.verbose(String.format("Scanned path %s -> URI = %s", path, uri.toString()));
            this.connection.disconnect();
        }
    }
}

