/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.CompletedFuture;
import net.hockeyapp.android.utils.HockeyLog;

public class Constants {
    public static final String BASE_URL = "https://sdk.hockeyapp.net/";
    public static final String SDK_NAME = "HockeySDK";
    public static final String SDK_VERSION = "5.1.0";
    public static final String FILES_DIRECTORY_NAME = "HockeyApp";
    public static final String SDK_USER_AGENT = "HockeySDK/Android 5.1.0";
    public static final int UPDATE_PERMISSIONS_REQUEST = 1;
    private static final String BUNDLE_BUILD_NUMBER = "buildNumber";
    public static String APP_VERSION = null;
    public static String APP_VERSION_NAME = null;
    public static String APP_PACKAGE = null;
    public static String ANDROID_VERSION = null;
    public static String ANDROID_BUILD = null;
    public static String PHONE_MODEL = null;
    public static String PHONE_MANUFACTURER = null;
    static String DEVICE_IDENTIFIER = null;
    static CountDownLatch LOADING_LATCH = new CountDownLatch(1);

    public static Future<String> getDeviceIdentifier() {
        if (LOADING_LATCH.getCount() == 0L) {
            return new CompletedFuture<String>(DEVICE_IDENTIFIER);
        }
        return AsyncTaskUtils.execute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                LOADING_LATCH.await();
                return DEVICE_IDENTIFIER;
            }
        });
    }

    public static void loadFromContext(Context context) {
        ANDROID_VERSION = Build.VERSION.RELEASE;
        ANDROID_BUILD = Build.DISPLAY;
        PHONE_MODEL = Build.MODEL;
        PHONE_MANUFACTURER = Build.MANUFACTURER;
        Constants.loadPackageData(context);
        Constants.loadIdentifiers(context);
    }

    public static File getHockeyAppStorageDir(Context context) {
        boolean success;
        File dir = new File(context.getExternalFilesDir(null), FILES_DIRECTORY_NAME);
        boolean bl = success = dir.exists() || dir.mkdirs();
        if (!success) {
            HockeyLog.warn("Couldn't create HockeyApp Storage dir");
        }
        return dir;
    }

    private static void loadPackageData(Context context) {
        if (context != null) {
            try {
                PackageManager packageManager = context.getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
                APP_PACKAGE = packageInfo.packageName;
                APP_VERSION = "" + packageInfo.versionCode;
                APP_VERSION_NAME = packageInfo.versionName;
                int buildNumber = Constants.loadBuildNumber(context, packageManager);
                if (buildNumber != 0 && buildNumber > packageInfo.versionCode) {
                    APP_VERSION = "" + buildNumber;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                HockeyLog.error("Exception thrown when accessing the package info", e);
            }
        }
    }

    private static int loadBuildNumber(Context context, PackageManager packageManager) {
        try {
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            Bundle metaData = appInfo.metaData;
            if (metaData != null) {
                return metaData.getInt(BUNDLE_BUILD_NUMBER, 0);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            HockeyLog.error("Exception thrown when accessing the application info", e);
        }
        return 0;
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private static void loadIdentifiers(final Context context) {
        if (DEVICE_IDENTIFIER != null) {
            return;
        }
        AsyncTaskUtils.execute(new AsyncTask<Void, Object, String>(){

            protected String doInBackground(Void ... voids) {
                SharedPreferences preferences = context.getSharedPreferences(Constants.FILES_DIRECTORY_NAME, 0);
                String deviceIdentifier = preferences.getString("deviceIdentifier", null);
                if (deviceIdentifier == null) {
                    deviceIdentifier = UUID.randomUUID().toString();
                    preferences.edit().putString("deviceIdentifier", deviceIdentifier).apply();
                }
                return deviceIdentifier;
            }

            protected void onPostExecute(String deviceIdentifier) {
                DEVICE_IDENTIFIER = deviceIdentifier;
                LOADING_LATCH.countDown();
            }
        });
    }
}

