/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.design.R;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.PointerIconCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.view.menu.MenuItemImpl;
import android.support.v7.view.menu.MenuView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class BottomNavigationItemView
extends FrameLayout
implements MenuView.ItemView {
    public static final int INVALID_ITEM_POSITION = -1;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private final int mDefaultMargin;
    private final int mShiftAmount;
    private final float mScaleUpFactor;
    private final float mScaleDownFactor;
    private boolean mShiftingMode;
    private ImageView mIcon;
    private final TextView mSmallLabel;
    private final TextView mLargeLabel;
    private int mItemPosition = -1;
    private MenuItemImpl mItemData;
    private ColorStateList mIconTint;

    public BottomNavigationItemView(@NonNull Context context) {
        this(context, null);
    }

    public BottomNavigationItemView(@NonNull Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomNavigationItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources res = this.getResources();
        int inactiveLabelSize = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_text_size);
        int activeLabelSize = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_active_text_size);
        this.mDefaultMargin = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_margin);
        this.mShiftAmount = inactiveLabelSize - activeLabelSize;
        this.mScaleUpFactor = 1.0f * (float)activeLabelSize / (float)inactiveLabelSize;
        this.mScaleDownFactor = 1.0f * (float)inactiveLabelSize / (float)activeLabelSize;
        LayoutInflater.from((Context)context).inflate(R.layout.design_bottom_navigation_item, (ViewGroup)this, true);
        this.setBackgroundResource(R.drawable.design_bottom_navigation_item_background);
        this.mIcon = (ImageView)this.findViewById(R.id.icon);
        this.mSmallLabel = (TextView)this.findViewById(R.id.smallLabel);
        this.mLargeLabel = (TextView)this.findViewById(R.id.largeLabel);
    }

    public void initialize(MenuItemImpl itemData, int menuType) {
        this.mItemData = itemData;
        this.setCheckable(itemData.isCheckable());
        this.setChecked(itemData.isChecked());
        this.setEnabled(itemData.isEnabled());
        this.setIcon(itemData.getIcon());
        this.setTitle(itemData.getTitle());
        this.setId(itemData.getItemId());
    }

    public void setItemPosition(int position) {
        this.mItemPosition = position;
    }

    public int getItemPosition() {
        return this.mItemPosition;
    }

    public void setShiftingMode(boolean enabled) {
        this.mShiftingMode = enabled;
    }

    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    public void setTitle(CharSequence title) {
        this.mSmallLabel.setText(title);
        this.mLargeLabel.setText(title);
        this.setContentDescription(title);
    }

    public void setCheckable(boolean checkable) {
        this.refreshDrawableState();
    }

    public void setChecked(boolean checked) {
        ViewCompat.setPivotX((View)this.mLargeLabel, (float)(this.mLargeLabel.getWidth() / 2));
        ViewCompat.setPivotY((View)this.mLargeLabel, (float)this.mLargeLabel.getBaseline());
        ViewCompat.setPivotX((View)this.mSmallLabel, (float)(this.mSmallLabel.getWidth() / 2));
        ViewCompat.setPivotY((View)this.mSmallLabel, (float)this.mSmallLabel.getBaseline());
        if (this.mShiftingMode) {
            if (checked) {
                FrameLayout.LayoutParams iconParams = (FrameLayout.LayoutParams)this.mIcon.getLayoutParams();
                iconParams.gravity = 49;
                iconParams.topMargin = this.mDefaultMargin;
                this.mIcon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
                this.mLargeLabel.setVisibility(0);
                ViewCompat.setScaleX((View)this.mLargeLabel, (float)1.0f);
                ViewCompat.setScaleY((View)this.mLargeLabel, (float)1.0f);
            } else {
                FrameLayout.LayoutParams iconParams = (FrameLayout.LayoutParams)this.mIcon.getLayoutParams();
                iconParams.gravity = 17;
                iconParams.topMargin = this.mDefaultMargin;
                this.mIcon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
                this.mLargeLabel.setVisibility(4);
                ViewCompat.setScaleX((View)this.mLargeLabel, (float)0.5f);
                ViewCompat.setScaleY((View)this.mLargeLabel, (float)0.5f);
            }
            this.mSmallLabel.setVisibility(4);
        } else if (checked) {
            FrameLayout.LayoutParams iconParams = (FrameLayout.LayoutParams)this.mIcon.getLayoutParams();
            iconParams.gravity = 49;
            iconParams.topMargin = this.mDefaultMargin + this.mShiftAmount;
            this.mIcon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
            this.mLargeLabel.setVisibility(0);
            this.mSmallLabel.setVisibility(4);
            ViewCompat.setScaleX((View)this.mLargeLabel, (float)1.0f);
            ViewCompat.setScaleY((View)this.mLargeLabel, (float)1.0f);
            ViewCompat.setScaleX((View)this.mSmallLabel, (float)this.mScaleUpFactor);
            ViewCompat.setScaleY((View)this.mSmallLabel, (float)this.mScaleUpFactor);
        } else {
            FrameLayout.LayoutParams iconParams = (FrameLayout.LayoutParams)this.mIcon.getLayoutParams();
            iconParams.gravity = 49;
            iconParams.topMargin = this.mDefaultMargin;
            this.mIcon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
            this.mLargeLabel.setVisibility(4);
            this.mSmallLabel.setVisibility(0);
            ViewCompat.setScaleX((View)this.mLargeLabel, (float)this.mScaleDownFactor);
            ViewCompat.setScaleY((View)this.mLargeLabel, (float)this.mScaleDownFactor);
            ViewCompat.setScaleX((View)this.mSmallLabel, (float)1.0f);
            ViewCompat.setScaleY((View)this.mSmallLabel, (float)1.0f);
        }
        this.refreshDrawableState();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mSmallLabel.setEnabled(enabled);
        this.mLargeLabel.setEnabled(enabled);
        this.mIcon.setEnabled(enabled);
        if (enabled) {
            ViewCompat.setPointerIcon((View)this, (PointerIconCompat)PointerIconCompat.getSystemIcon((Context)this.getContext(), (int)1002));
        } else {
            ViewCompat.setPointerIcon((View)this, null);
        }
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.mItemData != null && this.mItemData.isCheckable() && this.mItemData.isChecked()) {
            BottomNavigationItemView.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public void setShortcut(boolean showShortcut, char shortcutKey) {
    }

    public void setIcon(Drawable icon) {
        if (icon != null) {
            Drawable.ConstantState state = icon.getConstantState();
            icon = DrawableCompat.wrap((Drawable)(state == null ? icon : state.newDrawable())).mutate();
            DrawableCompat.setTintList((Drawable)icon, (ColorStateList)this.mIconTint);
        }
        this.mIcon.setImageDrawable(icon);
    }

    public boolean prefersCondensedTitle() {
        return false;
    }

    public boolean showsIcon() {
        return true;
    }

    public void setIconTintList(ColorStateList tint) {
        this.mIconTint = tint;
        if (this.mItemData != null) {
            this.setIcon(this.mItemData.getIcon());
        }
    }

    public void setTextColor(ColorStateList color2) {
        this.mSmallLabel.setTextColor(color2);
        this.mLargeLabel.setTextColor(color2);
    }

    public void setItemBackground(int background) {
        Drawable backgroundDrawable = background == 0 ? null : ContextCompat.getDrawable((Context)this.getContext(), (int)background);
        ViewCompat.setBackground((View)this, (Drawable)backgroundDrawable);
    }
}

