/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.net.Uri;
import android.os.AsyncTask;
import android.view.MotionEvent;
import android.widget.ImageView;
import java.io.IOException;
import java.util.Stack;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.ImageUtils;

@SuppressLint(value={"ViewConstructor"})
public class PaintView
extends ImageView {
    private static final float TOUCH_TOLERANCE = 4.0f;
    private Path path = new Path();
    private Stack<Path> paths = new Stack();
    private Paint paint = new Paint();
    private float mX;
    private float mY;

    @SuppressLint(value={"StaticFieldLeak"})
    public PaintView(Context context, Uri imageUri, int displayWidth, int displayHeight) {
        super(context);
        this.paint.setAntiAlias(true);
        this.paint.setDither(true);
        this.paint.setColor(-65536);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeJoin(Paint.Join.ROUND);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.paint.setStrokeWidth(12.0f);
        new AsyncTask<Object, Void, Bitmap>(){

            protected void onPreExecute() {
                PaintView.this.setAdjustViewBounds(true);
            }

            protected Bitmap doInBackground(Object ... args) {
                Context context = (Context)args[0];
                Uri imageUri = (Uri)args[1];
                Integer displayWidth = (Integer)args[2];
                Integer displayHeight = (Integer)args[3];
                try {
                    return ImageUtils.decodeSampledBitmap(context, imageUri, displayWidth, displayHeight);
                }
                catch (IOException e) {
                    HockeyLog.error("Could not load image into ImageView.", e);
                    return null;
                }
            }

            protected void onPostExecute(Bitmap bm) {
                if (bm == null) {
                    return;
                }
                PaintView.this.setImageBitmap(bm);
            }
        }.execute(new Object[]{context, imageUri, displayWidth, displayHeight});
    }

    public void clearImage() {
        this.paths.clear();
        this.invalidate();
    }

    public void undo() {
        if (!this.paths.empty()) {
            this.paths.pop();
            this.invalidate();
        }
    }

    public boolean isClear() {
        return this.paths.empty();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (Path path : this.paths) {
            canvas.drawPath(path, this.paint);
        }
        canvas.drawPath(this.path, this.paint);
    }

    private void touchStart(float x, float y) {
        this.path.reset();
        this.path.moveTo(x, y);
        this.mX = x;
        this.mY = y;
    }

    private void touchMove(float x, float y) {
        float dx = Math.abs(x - this.mX);
        float dy = Math.abs(y - this.mY);
        if (dx >= 4.0f || dy >= 4.0f) {
            this.path.quadTo(this.mX, this.mY, (x + this.mX) / 2.0f, (y + this.mY) / 2.0f);
            this.mX = x;
            this.mY = y;
        }
    }

    private void touchUp() {
        this.path.lineTo(this.mX, this.mY);
        this.paths.push(this.path);
        this.path = new Path();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.touchStart(x, y);
                this.invalidate();
                break;
            }
            case 2: {
                this.touchMove(x, y);
                this.invalidate();
                break;
            }
            case 1: {
                this.touchUp();
                this.invalidate();
            }
        }
        return true;
    }
}

