/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Scanner;
import java.util.regex.Pattern;
import net.hockeyapp.android.R;
import net.hockeyapp.android.UpdateInfoListener;
import net.hockeyapp.android.utils.HockeyLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VersionHelper {
    public static final String VERSION_MAX = "99.0";
    private ArrayList<JSONObject> mSortedVersions;
    private JSONObject mNewest;
    private Context mContext;
    private UpdateInfoListener mListener;
    private int mCurrentVersionCode;

    public VersionHelper(Context context, String infoJSON, UpdateInfoListener listener) {
        this.mContext = context;
        this.mListener = listener;
        this.loadVersions(infoJSON);
        this.sortVersions();
    }

    private void loadVersions(String infoJSON) {
        this.mNewest = new JSONObject();
        this.mSortedVersions = new ArrayList();
        this.mCurrentVersionCode = this.mListener.getCurrentVersionCode();
        try {
            JSONArray versions = new JSONArray(infoJSON);
            int versionCode = this.mCurrentVersionCode;
            for (int index = 0; index < versions.length(); ++index) {
                boolean newerApkFile;
                JSONObject entry = versions.getJSONObject(index);
                boolean largerVersionCode = entry.getInt("version") > versionCode;
                boolean bl = newerApkFile = entry.getInt("version") == versionCode && VersionHelper.isNewerThanLastUpdateTime(this.mContext, entry.getLong("timestamp"));
                if (largerVersionCode || newerApkFile) {
                    this.mNewest = entry;
                    versionCode = entry.getInt("version");
                }
                this.mSortedVersions.add(entry);
            }
        }
        catch (NullPointerException | JSONException throwable) {
            // empty catch block
        }
    }

    private void sortVersions() {
        Collections.sort(this.mSortedVersions, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                try {
                    if (object1.getInt("version") > object2.getInt("version")) {
                        return 0;
                    }
                }
                catch (NullPointerException | JSONException throwable) {
                    // empty catch block
                }
                return 0;
            }
        });
    }

    public String getVersionString() {
        return VersionHelper.failSafeGetStringFromJSON(this.mNewest, "shortversion", "") + " (" + VersionHelper.failSafeGetStringFromJSON(this.mNewest, "version", "") + ")";
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public String getFileDateString() {
        long timestamp = VersionHelper.failSafeGetLongFromJSON(this.mNewest, "timestamp", 0L);
        Date date = new Date(timestamp * 1000L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        return dateFormat.format(date);
    }

    public long getFileSizeBytes() {
        boolean external = Boolean.valueOf(VersionHelper.failSafeGetStringFromJSON(this.mNewest, "external", "false"));
        long appSize = VersionHelper.failSafeGetLongFromJSON(this.mNewest, "appsize", 0L);
        return external && appSize == 0L ? -1L : appSize;
    }

    private static String failSafeGetStringFromJSON(JSONObject json, String name, String defaultValue) {
        try {
            return json.getString(name);
        }
        catch (JSONException e) {
            return defaultValue;
        }
    }

    private static long failSafeGetLongFromJSON(JSONObject json, String name, long defaultValue) {
        try {
            return json.getLong(name);
        }
        catch (JSONException e) {
            return defaultValue;
        }
    }

    public String getReleaseNotes(boolean showRestore) {
        StringBuilder result = new StringBuilder();
        result.append("<html>");
        result.append("<body style='padding: 0px 0px 20px 0px'>");
        int count = 0;
        for (JSONObject version : this.mSortedVersions) {
            if (count > 0) {
                result.append(this.getSeparator());
                if (showRestore) {
                    result.append(this.getRestoreButton(version));
                }
            }
            result.append(this.getVersionLine(count, version));
            result.append(this.getVersionNotes(version));
            ++count;
        }
        result.append("</body>");
        result.append("</html>");
        return result.toString();
    }

    private Object getSeparator() {
        return "<hr style='border-top: 1px solid #c8c8c8; border-bottom: 0px; margin: 40px 10px 0px 10px;' />";
    }

    private String getRestoreButton(JSONObject version) {
        StringBuilder result = new StringBuilder();
        String versionID = this.getVersionID(version);
        if (!TextUtils.isEmpty((CharSequence)versionID)) {
            String style = "background: #c8c8c8; color: #000; display: block; float: right; padding: 7px; margin: 0px 10px 10px; text-decoration: none;";
            result.append(String.format("<a href='restore:%s' style='%s'>%s</a>", versionID, style, this.mContext.getString(R.string.hockeyapp_update_restore)));
        }
        return result.toString();
    }

    private String getVersionID(JSONObject version) {
        String versionID = "";
        try {
            versionID = version.getString("id");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return versionID;
    }

    private String getVersionLine(int count, JSONObject version) {
        StringBuilder result = new StringBuilder();
        int newestCode = this.getVersionCode(this.mNewest);
        int versionCode = this.getVersionCode(version);
        String versionName = this.getVersionName(version);
        result.append("<div style='padding: 20px 10px 10px;'><strong>");
        if (count == 0) {
            result.append(this.mContext.getString(R.string.hockeyapp_update_newest_version)).append(':');
        } else {
            String versionString = String.format(this.mContext.getString(R.string.hockeyapp_update_version), versionName);
            result.append(String.format("%s (%s): ", versionString, versionCode));
            if (versionCode != newestCode && versionCode == this.mCurrentVersionCode) {
                this.mCurrentVersionCode = -1;
                result.append(String.format("[%s]", this.mContext.getString(R.string.hockeyapp_update_already_installed)));
            }
        }
        result.append("</strong></div>");
        return result.toString();
    }

    private int getVersionCode(JSONObject version) {
        int versionCode = 0;
        try {
            versionCode = version.getInt("version");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return versionCode;
    }

    private String getVersionName(JSONObject version) {
        String versionName = "";
        try {
            versionName = version.getString("shortversion");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return versionName;
    }

    private String getVersionNotes(JSONObject version) {
        StringBuilder result = new StringBuilder();
        String notes = VersionHelper.failSafeGetStringFromJSON(version, "notes", "");
        result.append("<div style='padding: 0px 10px;'>");
        if (notes.trim().length() == 0) {
            result.append(String.format("<em>%s</em>", this.mContext.getString(R.string.hockeyapp_update_no_info)));
        } else {
            result.append(notes);
        }
        result.append("</div>");
        return result.toString();
    }

    public static int compareVersionStrings(String left, String right) {
        if (left == null || right == null) {
            return 0;
        }
        try {
            Scanner leftScanner = new Scanner(left.replaceAll("\\-.*", ""));
            Scanner rightScanner = new Scanner(right.replaceAll("\\-.*", ""));
            leftScanner.useDelimiter("\\.");
            rightScanner.useDelimiter("\\.");
            while (leftScanner.hasNextInt() && rightScanner.hasNextInt()) {
                int rightValue;
                int leftValue = leftScanner.nextInt();
                if (leftValue < (rightValue = rightScanner.nextInt())) {
                    return -1;
                }
                if (leftValue <= rightValue) continue;
                return 1;
            }
            if (leftScanner.hasNextInt()) {
                return 1;
            }
            if (rightScanner.hasNextInt()) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isNewerThanLastUpdateTime(Context context, long timestamp) {
        if (context == null) {
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo appInfo = pm.getApplicationInfo(context.getPackageName(), 0);
            String appFile = appInfo.sourceDir;
            long lastModified = new File(appFile).lastModified() / 1000L + 1800L;
            return timestamp > lastModified;
        }
        catch (PackageManager.NameNotFoundException e) {
            HockeyLog.error("Failed to get application info", e);
            return false;
        }
    }

    public static String mapGoogleVersion(String version) {
        if (version == null || version.equalsIgnoreCase("L")) {
            return "5.0";
        }
        if (version.equalsIgnoreCase("M")) {
            return "6.0";
        }
        if (version.equalsIgnoreCase("N")) {
            return "7.0";
        }
        if (version.equalsIgnoreCase("O")) {
            return "8.0";
        }
        if (Pattern.matches("^[a-zA-Z]+", version)) {
            return VERSION_MAX;
        }
        return version;
    }
}

