/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.utils;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.text.TextUtils;
import android.util.Patterns;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hockeyapp.android.R;
import net.hockeyapp.android.utils.HockeyLog;

public class Util {
    private static final String APP_IDENTIFIER_PATTERN = "[0-9a-f]+";
    private static final int APP_IDENTIFIER_LENGTH = 32;
    private static final String APP_IDENTIFIER_KEY = "net.hockeyapp.android.appIdentifier";
    private static final String APP_SECRET_KEY = "net.hockeyapp.android.appSecret";
    private static final Pattern appIdentifierPattern = Pattern.compile("[0-9a-f]+", 2);
    private static final ThreadLocal<DateFormat> DATE_FORMAT_THREAD_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };

    public static String encodeParam(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            HockeyLog.error("Failed to encode param " + param, e);
            return "";
        }
    }

    public static boolean isValidEmail(String value) {
        return !TextUtils.isEmpty((CharSequence)value) && Patterns.EMAIL_ADDRESS.matcher(value).matches();
    }

    public static Boolean runsOnTablet(Context context) {
        if (context != null) {
            Configuration configuration = context.getResources().getConfiguration();
            return (configuration.screenLayout & 0xF) == 3 || (configuration.screenLayout & 0xF) == 4;
        }
        return false;
    }

    public static String sanitizeAppIdentifier(String appIdentifier) throws IllegalArgumentException {
        if (appIdentifier == null) {
            throw new IllegalArgumentException("App ID must not be null.");
        }
        String sAppIdentifier = appIdentifier.trim();
        Matcher matcher = appIdentifierPattern.matcher(sAppIdentifier);
        if (sAppIdentifier.length() != 32) {
            throw new IllegalArgumentException("App ID length must be 32 characters.");
        }
        if (!matcher.matches()) {
            throw new IllegalArgumentException("App ID must match regex pattern /[0-9a-f]+/i");
        }
        return sAppIdentifier;
    }

    public static String getFormString(Map<String, String> params) throws UnsupportedEncodingException {
        ArrayList<String> protoList = new ArrayList<String>();
        for (String key : params.keySet()) {
            String value = params.get(key);
            key = URLEncoder.encode(key, "UTF-8");
            value = URLEncoder.encode(value, "UTF-8");
            protoList.add(key + "=" + value);
        }
        return TextUtils.join((CharSequence)"&", protoList);
    }

    public static boolean classExists(String className) {
        try {
            return Class.forName(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Notification createNotification(Context context, PendingIntent pendingIntent, String title, String text, int iconId, String channelId) {
        Notification.Builder builder = Build.VERSION.SDK_INT >= 26 ? new Notification.Builder(context, channelId) : new Notification.Builder(context);
        builder.setContentTitle((CharSequence)title).setContentText((CharSequence)text).setContentIntent(pendingIntent).setSmallIcon(iconId);
        if (Build.VERSION.SDK_INT >= 16) {
            return builder.build();
        }
        return builder.getNotification();
    }

    public static void sendNotification(Context context, int id2, Notification notification, String channelId, CharSequence channelName) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(channelId, channelName, 3);
            notificationManager.createNotificationChannel(channel);
        }
        notificationManager.notify(id2, notification);
    }

    public static void cancelNotification(Context context, int id2) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancel(id2);
    }

    public static void announceForAccessibility(View view, CharSequence text) {
        AccessibilityManager manager = (AccessibilityManager)view.getContext().getSystemService("accessibility");
        if (!manager.isEnabled()) {
            return;
        }
        int eventType = Build.VERSION.SDK_INT < 16 ? 8 : 16384;
        AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
        event.getText().add(text);
        event.setSource(view);
        event.setEnabled(view.isEnabled());
        event.setClassName((CharSequence)view.getClass().getName());
        event.setPackageName((CharSequence)view.getContext().getPackageName());
        manager.sendAccessibilityEvent(event);
    }

    public static String getAppIdentifier(Context context) {
        String appIdentifier = Util.getManifestString(context, APP_IDENTIFIER_KEY);
        if (TextUtils.isEmpty((CharSequence)appIdentifier)) {
            throw new IllegalArgumentException("HockeyApp app identifier was not configured correctly in manifest or build configuration.");
        }
        return appIdentifier;
    }

    public static String getAppSecret(Context context) {
        return Util.getManifestString(context, APP_SECRET_KEY);
    }

    public static String getManifestString(Context context, String key) {
        return Util.getBundle(context).getString(key);
    }

    private static Bundle getBundle(Context context) {
        Bundle bundle;
        try {
            bundle = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        return bundle;
    }

    public static boolean isConnectedToNetwork(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            if (connectivityManager != null) {
                NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
                return activeNetwork != null && activeNetwork.isConnected();
            }
        }
        catch (Exception e) {
            HockeyLog.error("Exception thrown when check network is connected", e);
        }
        return false;
    }

    public static String getAppName(Context context) {
        PackageManager packageManager = context.getPackageManager();
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = packageManager.getApplicationInfo(context.getApplicationInfo().packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return applicationInfo != null ? (String)packageManager.getApplicationLabel(applicationInfo) : context.getString(R.string.hockeyapp_crash_dialog_app_name_fallback);
    }

    public static String convertAppIdentifierToGuid(String appIdentifier) throws IllegalArgumentException {
        String sanitizedAppIdentifier = Util.sanitizeAppIdentifier(appIdentifier);
        String guid = null;
        if (sanitizedAppIdentifier != null) {
            StringBuilder idBuf = new StringBuilder(sanitizedAppIdentifier);
            idBuf.insert(20, '-');
            idBuf.insert(16, '-');
            idBuf.insert(12, '-');
            idBuf.insert(8, '-');
            guid = idBuf.toString();
        }
        return guid;
    }

    public static boolean isEmulator() {
        return Build.BRAND.equalsIgnoreCase("generic");
    }

    public static String dateToISO8601(Date date) {
        Date localDate = date;
        if (localDate == null) {
            localDate = new Date();
        }
        return DATE_FORMAT_THREAD_LOCAL.get().format(localDate);
    }

    public static boolean isDebuggerConnected() {
        return Debug.isDebuggerConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream), 1024);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append('\n');
            }
        }
        catch (IOException e) {
            HockeyLog.error("Failed to convert stream to string", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return stringBuilder.toString();
    }

    public static byte[] hash(byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        digest.update(bytes);
        return digest.digest();
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte aMessageDigest : bytes) {
            String h = Integer.toHexString(0xFF & aMessageDigest);
            while (h.length() < 2) {
                h = "0" + h;
            }
            hexString.append(h);
        }
        return hexString.toString();
    }
}

