/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.hockeyapp.android.utils.HockeyLog;

public class ImageUtils {
    public static final int ORIENTATION_PORTRAIT = 1;
    public static final int ORIENTATION_LANDSCAPE = 0;

    public static int determineOrientation(File file) throws IOException {
        try (FileInputStream input = null;){
            input = new FileInputStream(file);
            int n = ImageUtils.determineOrientation(input);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int determineOrientation(Context context, Uri uri) {
        InputStream input = null;
        try {
            input = context.getContentResolver().openInputStream(uri);
            int n = ImageUtils.determineOrientation(input);
            return n;
        }
        catch (IOException e) {
            HockeyLog.error("Unable to determine necessary screen orientation.", e);
            int n = 1;
            return n;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                HockeyLog.error("Unable to close input stream.", e);
            }
        }
    }

    public static int determineOrientation(InputStream input) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
        if (options.outWidth == -1 || options.outHeight == -1) {
            return 1;
        }
        float ratio = (float)options.outWidth / (float)options.outHeight;
        return ratio > 1.0f ? 0 : 1;
    }

    public static Bitmap decodeSampledBitmap(File file, int reqWidth, int reqHeight) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtils.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeSampledBitmap(Context context, Uri imageUri, int reqWidth, int reqHeight) throws IOException {
        InputStream inputBounds = null;
        InputStream inputBitmap = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            inputBounds = context.getContentResolver().openInputStream(imageUri);
            BitmapFactory.decodeStream((InputStream)inputBounds, null, (BitmapFactory.Options)options);
            options.inSampleSize = ImageUtils.calculateInSampleSize(options, reqWidth, reqHeight);
            options.inJustDecodeBounds = false;
            inputBitmap = context.getContentResolver().openInputStream(imageUri);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputBitmap, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            if (inputBounds != null) {
                inputBounds.close();
            }
            if (inputBitmap != null) {
                inputBitmap.close();
            }
        }
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }
}

