/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.utils;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hockeyapp.android.utils.Base64;
import net.hockeyapp.android.utils.SimpleMultipartEntity;

public class HttpURLConnectionBuilder {
    private static final int DEFAULT_TIMEOUT = 120000;
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final long FORM_FIELD_LIMIT = 0x400000L;
    public static final int FIELDS_LIMIT = 25;
    private final String mUrlString;
    private String mRequestMethod;
    private String mRequestBody;
    private SimpleMultipartEntity mMultipartEntity;
    private int mTimeout = 120000;
    private final Map<String, String> mHeaders;

    public HttpURLConnectionBuilder(String urlString) {
        this.mUrlString = urlString;
        this.mHeaders = new HashMap<String, String>();
        this.mHeaders.put("User-Agent", "HockeySDK/Android 5.1.0");
    }

    public HttpURLConnectionBuilder setRequestMethod(String requestMethod) {
        this.mRequestMethod = requestMethod;
        return this;
    }

    public HttpURLConnectionBuilder setRequestBody(String requestBody) {
        this.mRequestBody = requestBody;
        return this;
    }

    public HttpURLConnectionBuilder writeFormFields(Map<String, String> fields) {
        if (fields.size() > 25) {
            throw new IllegalArgumentException("Fields size too large: " + fields.size() + " - max allowed: " + 25);
        }
        for (String key : fields.keySet()) {
            String value = fields.get(key);
            if (value == null || (long)value.length() <= 0x400000L) continue;
            throw new IllegalArgumentException("Form field " + key + " size too large: " + value.length() + " - max allowed: " + 0x400000L);
        }
        try {
            String formString = HttpURLConnectionBuilder.getFormString(fields, DEFAULT_CHARSET);
            this.setHeader("Content-Type", "application/x-www-form-urlencoded");
            this.setRequestBody(formString);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public HttpURLConnectionBuilder writeMultipartData(Map<String, String> fields, Context context, List<Uri> attachmentUris) {
        try {
            File tempFile = File.createTempFile("multipart", null, context.getCacheDir());
            this.mMultipartEntity = new SimpleMultipartEntity(tempFile);
            this.mMultipartEntity.writeFirstBoundaryIfNeeds();
            for (String key : fields.keySet()) {
                this.mMultipartEntity.addPart(key, fields.get(key));
            }
            for (int i = 0; i < attachmentUris.size(); ++i) {
                Uri attachmentUri = attachmentUris.get(i);
                boolean lastFile = i == attachmentUris.size() - 1;
                InputStream input = context.getContentResolver().openInputStream(attachmentUri);
                String filename = attachmentUri.getLastPathSegment();
                this.mMultipartEntity.addPart("attachment" + i, filename, input, lastFile);
            }
            this.mMultipartEntity.writeLastBoundaryIfNeeds();
            this.setHeader("Content-Type", "multipart/form-data; boundary=" + this.mMultipartEntity.getBoundary());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public HttpURLConnectionBuilder setTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout has to be positive.");
        }
        this.mTimeout = timeout;
        return this;
    }

    public HttpURLConnectionBuilder setHeader(String name, String value) {
        this.mHeaders.put(name, value);
        return this;
    }

    public HttpURLConnectionBuilder setBasicAuthorization(String username, String password) {
        String authString = "Basic " + Base64.encodeToString((username + ":" + password).getBytes(), 2);
        this.setHeader("Authorization", authString);
        return this;
    }

    public HttpURLConnection build() throws IOException {
        URL url = new URL(this.mUrlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(this.mTimeout);
        connection.setReadTimeout(this.mTimeout);
        if (!TextUtils.isEmpty((CharSequence)this.mRequestMethod)) {
            connection.setRequestMethod(this.mRequestMethod);
            if (!TextUtils.isEmpty((CharSequence)this.mRequestBody) || this.mRequestMethod.equalsIgnoreCase("POST") || this.mRequestMethod.equalsIgnoreCase("PUT")) {
                connection.setDoOutput(true);
            }
        }
        for (String name : this.mHeaders.keySet()) {
            connection.setRequestProperty(name, this.mHeaders.get(name));
        }
        if (!TextUtils.isEmpty((CharSequence)this.mRequestBody)) {
            OutputStream outputStream = connection.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, DEFAULT_CHARSET));
            writer.write(this.mRequestBody);
            writer.flush();
            writer.close();
        }
        if (this.mMultipartEntity != null) {
            connection.setRequestProperty("Content-Length", String.valueOf(this.mMultipartEntity.getContentLength()));
            this.mMultipartEntity.writeTo(connection.getOutputStream());
        }
        return connection;
    }

    private static String getFormString(Map<String, String> params, String charset) throws UnsupportedEncodingException {
        ArrayList<String> protoList = new ArrayList<String>();
        for (String key : params.keySet()) {
            String value = params.get(key);
            key = URLEncoder.encode(key, charset);
            value = URLEncoder.encode(value, charset);
            protoList.add(key + "=" + value);
        }
        return TextUtils.join((CharSequence)"&", protoList);
    }
}

