/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.hockeyapp.android.objects.Feedback;
import net.hockeyapp.android.objects.FeedbackAttachment;
import net.hockeyapp.android.objects.FeedbackMessage;
import net.hockeyapp.android.objects.FeedbackResponse;
import net.hockeyapp.android.utils.HockeyLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FeedbackParser {
    private FeedbackParser() {
    }

    public static FeedbackParser getInstance() {
        return FeedbackParserHolder.INSTANCE;
    }

    public FeedbackResponse parseFeedbackResponse(String feedbackResponseJson) {
        FeedbackResponse feedbackResponse = null;
        if (feedbackResponseJson != null) {
            try {
                JSONObject jsonObject = new JSONObject(feedbackResponseJson);
                JSONObject feedbackObject = jsonObject.getJSONObject("feedback");
                Feedback feedback = new Feedback();
                JSONArray messagesArray = feedbackObject.getJSONArray("messages");
                ArrayList<FeedbackMessage> messages = null;
                if (messagesArray.length() > 0) {
                    messages = new ArrayList<FeedbackMessage>();
                    for (int i = 0; i < messagesArray.length(); ++i) {
                        String subject = messagesArray.getJSONObject(i).getString("subject");
                        String text = messagesArray.getJSONObject(i).getString("text");
                        String oem = messagesArray.getJSONObject(i).getString("oem");
                        String model = messagesArray.getJSONObject(i).getString("model");
                        String osVersion = messagesArray.getJSONObject(i).getString("os_version");
                        String createdAt = messagesArray.getJSONObject(i).getString("created_at");
                        int id2 = messagesArray.getJSONObject(i).getInt("id");
                        String token = messagesArray.getJSONObject(i).getString("token");
                        int via = messagesArray.getJSONObject(i).getInt("via");
                        String userString = messagesArray.getJSONObject(i).getString("user_string");
                        String cleanText = messagesArray.getJSONObject(i).getString("clean_text");
                        String name = messagesArray.getJSONObject(i).getString("name");
                        String appId = messagesArray.getJSONObject(i).getString("app_id");
                        JSONArray jsonAttachments = messagesArray.getJSONObject(i).optJSONArray("attachments");
                        List<FeedbackAttachment> feedbackAttachments = Collections.emptyList();
                        if (jsonAttachments != null) {
                            feedbackAttachments = new ArrayList();
                            for (int j = 0; j < jsonAttachments.length(); ++j) {
                                int attachmentId = jsonAttachments.getJSONObject(j).getInt("id");
                                int attachmentMessageId = jsonAttachments.getJSONObject(j).getInt("feedback_message_id");
                                String filename = jsonAttachments.getJSONObject(j).getString("file_name");
                                String url = jsonAttachments.getJSONObject(j).getString("url");
                                String attachmentCreatedAt = jsonAttachments.getJSONObject(j).getString("created_at");
                                String attachmentUpdatedAt = jsonAttachments.getJSONObject(j).getString("updated_at");
                                FeedbackAttachment feedbackAttachment = new FeedbackAttachment();
                                feedbackAttachment.setId(attachmentId);
                                feedbackAttachment.setMessageId(attachmentMessageId);
                                feedbackAttachment.setFilename(filename);
                                feedbackAttachment.setUrl(url);
                                feedbackAttachment.setCreatedAt(attachmentCreatedAt);
                                feedbackAttachment.setUpdatedAt(attachmentUpdatedAt);
                                feedbackAttachments.add(feedbackAttachment);
                            }
                        }
                        FeedbackMessage feedbackMessage = new FeedbackMessage();
                        feedbackMessage.setAppId(appId);
                        feedbackMessage.setCleanText(cleanText);
                        feedbackMessage.setCreatedAt(createdAt);
                        feedbackMessage.setId(id2);
                        feedbackMessage.setModel(model);
                        feedbackMessage.setName(name);
                        feedbackMessage.setOem(oem);
                        feedbackMessage.setOsVersion(osVersion);
                        feedbackMessage.setSubject(subject);
                        feedbackMessage.setText(text);
                        feedbackMessage.setToken(token);
                        feedbackMessage.setUserString(userString);
                        feedbackMessage.setVia(via);
                        feedbackMessage.setFeedbackAttachments(feedbackAttachments);
                        messages.add(feedbackMessage);
                    }
                }
                feedback.setMessages(messages);
                try {
                    feedback.setName(feedbackObject.getString("name"));
                }
                catch (JSONException e) {
                    HockeyLog.error("Failed to parse \"name\" in feedback response", e);
                }
                try {
                    feedback.setEmail(feedbackObject.getString("email"));
                }
                catch (JSONException e) {
                    HockeyLog.error("Failed to parse \"email\" in feedback response", e);
                }
                try {
                    feedback.setId(feedbackObject.getInt("id"));
                }
                catch (JSONException e) {
                    HockeyLog.error("Failed to parse \"id\" in feedback response", e);
                }
                try {
                    feedback.setCreatedAt(feedbackObject.getString("created_at"));
                }
                catch (JSONException e) {
                    HockeyLog.error("Failed to parse \"created_at\" in feedback response", e);
                }
                feedbackResponse = new FeedbackResponse();
                feedbackResponse.setFeedback(feedback);
                try {
                    feedbackResponse.setStatus(jsonObject.getString("status"));
                }
                catch (JSONException e) {
                    HockeyLog.error("Failed to parse \"status\" in feedback response", e);
                }
                try {
                    feedbackResponse.setToken(jsonObject.getString("token"));
                }
                catch (JSONException e) {
                    HockeyLog.error("Failed to parse \"token\" in feedback response", e);
                }
            }
            catch (JSONException e) {
                HockeyLog.error("Failed to parse feedback response", e);
            }
        }
        return feedbackResponse;
    }

    private static class FeedbackParserHolder {
        static final FeedbackParser INSTANCE = new FeedbackParser();

        private FeedbackParserHolder() {
        }
    }
}

