/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.tasks;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.R;
import net.hockeyapp.android.tasks.ConnectionTask;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.HttpURLConnectionBuilder;
import net.hockeyapp.android.utils.Util;

@SuppressLint(value={"StaticFieldLeak"})
public class SendFeedbackTask
extends ConnectionTask<Void, Void, HashMap<String, String>> {
    public static final String BUNDLE_FEEDBACK_RESPONSE = "feedback_response";
    public static final String BUNDLE_FEEDBACK_STATUS = "feedback_status";
    public static final String BUNDLE_REQUEST_TYPE = "request_type";
    private static final String TAG = "SendFeedbackTask";
    private static final String FILE_TAG = "HockeyApp";
    private Context mContext;
    private Handler mHandler;
    private String mUrlString;
    private String mName;
    private String mEmail;
    private String mSubject;
    private String mText;
    private String mUserId;
    private List<Uri> mAttachmentUris;
    private String mToken;
    private boolean mIsFetchMessages;
    private ProgressDialog mProgressDialog;
    private boolean mShowProgressDialog;
    private int mLastMessageId;

    public SendFeedbackTask(Context context, String urlString, String name, String email, String subject, String text, String userId, List<Uri> attachmentUris, String token, Handler handler, boolean isFetchMessages) {
        this.mContext = context;
        this.mUrlString = urlString;
        this.mName = name;
        this.mEmail = email;
        this.mSubject = subject;
        this.mText = text;
        this.mUserId = userId;
        this.mAttachmentUris = attachmentUris;
        this.mToken = token;
        this.mHandler = handler;
        this.mIsFetchMessages = isFetchMessages;
        this.mShowProgressDialog = true;
        this.mLastMessageId = -1;
        if (context != null) {
            Constants.loadFromContext(context);
        }
    }

    public void setShowProgressDialog(boolean showProgressDialog) {
        this.mShowProgressDialog = showProgressDialog;
    }

    public void setLastMessageId(int lastMessageId) {
        this.mLastMessageId = lastMessageId;
    }

    public void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    public void attach(Context context) {
        this.mContext = context;
        if (this.getStatus() == AsyncTask.Status.RUNNING && (this.mProgressDialog == null || !this.mProgressDialog.isShowing()) && this.mShowProgressDialog) {
            this.mProgressDialog = ProgressDialog.show((Context)this.mContext, (CharSequence)"", (CharSequence)this.getLoadingMessage(), (boolean)true, (boolean)false);
        }
    }

    public void detach() {
        this.mContext = null;
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
            this.mProgressDialog = null;
        }
    }

    protected void onPreExecute() {
        if ((this.mProgressDialog == null || !this.mProgressDialog.isShowing()) && this.mShowProgressDialog) {
            this.mProgressDialog = ProgressDialog.show((Context)this.mContext, (CharSequence)"", (CharSequence)this.getLoadingMessage(), (boolean)true, (boolean)false);
        }
    }

    protected HashMap<String, String> doInBackground(Void ... args) {
        if (this.mIsFetchMessages && this.mToken != null) {
            return this.doGet();
        }
        if (!this.mIsFetchMessages) {
            if (this.mAttachmentUris.isEmpty()) {
                return this.doPostPut();
            }
            HashMap<String, String> result = this.doPostPutWithAttachments();
            if (result != null) {
                this.clearTemporaryFolder(result);
            }
            return result;
        }
        return null;
    }

    private void clearTemporaryFolder(HashMap<String, String> result) {
        String status = result.get("status");
        if (status != null && status.startsWith("2") && this.mContext != null) {
            File[] screenshots;
            File folder = new File(this.mContext.getCacheDir(), FILE_TAG);
            if (folder.exists()) {
                for (File file : folder.listFiles()) {
                    Boolean success;
                    if (file == null || (success = Boolean.valueOf(file.delete())).booleanValue()) continue;
                    HockeyLog.debug(TAG, "Error deleting file from temporary folder");
                }
            }
            File hockeyAppStorageDir = Constants.getHockeyAppStorageDir(this.mContext);
            for (File screenshot : screenshots = hockeyAppStorageDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jpg");
                }
            })) {
                if (!this.mAttachmentUris.contains(Uri.fromFile((File)screenshot))) continue;
                if (screenshot.delete()) {
                    HockeyLog.debug(TAG, "Screenshot '" + screenshot.getName() + "' has been deleted");
                    continue;
                }
                HockeyLog.error(TAG, "Error deleting screenshot");
            }
        }
    }

    protected void onPostExecute(HashMap<String, String> result) {
        if (this.mProgressDialog != null) {
            try {
                this.mProgressDialog.dismiss();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mHandler != null) {
            Message msg = new Message();
            Bundle bundle = new Bundle();
            if (result != null) {
                bundle.putString(BUNDLE_REQUEST_TYPE, result.get("type"));
                bundle.putString(BUNDLE_FEEDBACK_RESPONSE, result.get("response"));
                bundle.putString(BUNDLE_FEEDBACK_STATUS, result.get("status"));
            } else {
                bundle.putString(BUNDLE_REQUEST_TYPE, "unknown");
            }
            msg.setData(bundle);
            this.mHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> doPostPut() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("type", "send");
        HttpURLConnection urlConnection = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("name", this.mName);
            parameters.put("email", this.mEmail);
            parameters.put("subject", this.mSubject);
            parameters.put("text", this.mText);
            parameters.put("bundle_identifier", Constants.APP_PACKAGE);
            parameters.put("bundle_short_version", Constants.APP_VERSION_NAME);
            parameters.put("bundle_version", Constants.APP_VERSION);
            parameters.put("os_version", Constants.ANDROID_VERSION);
            parameters.put("oem", Constants.PHONE_MANUFACTURER);
            parameters.put("model", Constants.PHONE_MODEL);
            parameters.put("sdk_version", "5.1.0");
            if (this.mUserId != null) {
                parameters.put("user_string", this.mUserId);
            }
            if (this.mToken != null) {
                this.mUrlString = this.mUrlString + this.mToken + "/";
            }
            urlConnection = new HttpURLConnectionBuilder(this.mUrlString).setRequestMethod(this.mToken != null ? "PUT" : "POST").writeFormFields(parameters).build();
            urlConnection.connect();
            result.put("status", String.valueOf(urlConnection.getResponseCode()));
            result.put("response", SendFeedbackTask.getStringFromConnection(urlConnection));
        }
        catch (IOException e) {
            HockeyLog.error("Failed to send feedback message", e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> doPostPutWithAttachments() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("type", "send");
        HttpURLConnection urlConnection = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("name", this.mName);
            parameters.put("email", this.mEmail);
            parameters.put("subject", this.mSubject);
            parameters.put("text", this.mText);
            parameters.put("bundle_identifier", Constants.APP_PACKAGE);
            parameters.put("bundle_short_version", Constants.APP_VERSION_NAME);
            parameters.put("bundle_version", Constants.APP_VERSION);
            parameters.put("os_version", Constants.ANDROID_VERSION);
            parameters.put("oem", Constants.PHONE_MANUFACTURER);
            parameters.put("model", Constants.PHONE_MODEL);
            parameters.put("sdk_version", "5.1.0");
            if (this.mUserId != null) {
                parameters.put("user_string", this.mUserId);
            }
            if (this.mToken != null) {
                this.mUrlString = this.mUrlString + this.mToken + "/";
            }
            urlConnection = new HttpURLConnectionBuilder(this.mUrlString).setRequestMethod(this.mToken != null ? "PUT" : "POST").writeMultipartData(parameters, this.mContext, this.mAttachmentUris).build();
            urlConnection.connect();
            result.put("status", String.valueOf(urlConnection.getResponseCode()));
            result.put("response", SendFeedbackTask.getStringFromConnection(urlConnection));
        }
        catch (IOException e) {
            HockeyLog.error("Failed to send feedback message", e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> doGet() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mUrlString).append(Util.encodeParam(this.mToken));
        if (this.mLastMessageId != -1) {
            sb.append("?last_message_id=").append(this.mLastMessageId);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = new HttpURLConnectionBuilder(sb.toString()).build();
            result.put("type", "fetch");
            urlConnection.connect();
            result.put("status", String.valueOf(urlConnection.getResponseCode()));
            result.put("response", SendFeedbackTask.getStringFromConnection(urlConnection));
        }
        catch (IOException e) {
            HockeyLog.error("Failed to fetching feedback messages", e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return result;
    }

    private String getLoadingMessage() {
        String loadingMessage = this.mContext.getString(R.string.hockeyapp_feedback_sending_feedback_text);
        if (this.mIsFetchMessages) {
            loadingMessage = this.mContext.getString(R.string.hockeyapp_feedback_fetching_feedback_text);
        }
        return loadingMessage;
    }
}

