/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.tasks;

import android.content.Context;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import net.hockeyapp.android.listeners.DownloadFileListener;
import net.hockeyapp.android.tasks.DownloadFileTask;
import net.hockeyapp.android.utils.HockeyLog;

public class GetFileSizeTask
extends DownloadFileTask {
    private long mSize;

    public GetFileSizeTask(Context context, String urlString, DownloadFileListener notifier) {
        super(context, urlString, notifier);
    }

    @Override
    protected Long doInBackground(Void ... args) {
        try {
            URL url = new URL(this.getURLString());
            URLConnection connection = this.createConnection(url, 6);
            return connection.getContentLength();
        }
        catch (IOException e) {
            HockeyLog.error("Failed to get size " + this.mUrlString, e);
            return 0L;
        }
    }

    @Override
    protected void onProgressUpdate(Integer ... args) {
    }

    @Override
    protected void onPostExecute(Long result) {
        this.mSize = result;
        if (this.mSize > 0L) {
            this.mNotifier.downloadSuccessful(this);
        } else {
            this.mNotifier.downloadFailed(this, false);
        }
    }

    public long getSize() {
        return this.mSize;
    }
}

