/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.tasks;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.widget.Toast;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import net.hockeyapp.android.R;
import net.hockeyapp.android.UpdateActivity;
import net.hockeyapp.android.UpdateFragment;
import net.hockeyapp.android.UpdateManagerListener;
import net.hockeyapp.android.tasks.CheckUpdateTask;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.Util;
import org.json.JSONArray;

public class CheckUpdateTaskWithUI
extends CheckUpdateTask {
    private WeakReference<Activity> mWeakActivity = null;
    private AlertDialog mDialog = null;
    protected boolean mIsDialogRequired = false;

    public CheckUpdateTaskWithUI(WeakReference<Activity> weakActivity, String urlString, String appIdentifier, UpdateManagerListener listener, boolean isDialogRequired) {
        super(weakActivity, urlString, appIdentifier, listener);
        this.mWeakActivity = weakActivity;
        this.mIsDialogRequired = isDialogRequired;
    }

    @Override
    public void detach() {
        super.detach();
        this.mWeakActivity = null;
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
        }
    }

    @Override
    protected void onPostExecute(JSONArray updateInfo) {
        super.onPostExecute(updateInfo);
        if (updateInfo != null && this.mIsDialogRequired) {
            this.showDialog((Activity)this.mWeakActivity.get(), updateInfo);
        }
    }

    private void showDialog(final Activity activity, final JSONArray updateInfo) {
        if (activity == null || activity.isFinishing()) {
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setTitle(R.string.hockeyapp_update_dialog_title);
        if (!this.mandatory.booleanValue()) {
            builder.setMessage(R.string.hockeyapp_update_dialog_message);
            builder.setNegativeButton(R.string.hockeyapp_update_dialog_negative_button, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    CheckUpdateTaskWithUI.this.cleanUp();
                    if (null != CheckUpdateTaskWithUI.this.listener) {
                        CheckUpdateTaskWithUI.this.listener.onCancel();
                    }
                }
            });
            builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    CheckUpdateTaskWithUI.this.cleanUp();
                    if (null != CheckUpdateTaskWithUI.this.listener) {
                        CheckUpdateTaskWithUI.this.listener.onCancel();
                    }
                }
            });
            builder.setPositiveButton(R.string.hockeyapp_update_dialog_positive_button, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    boolean useUpdateDialog;
                    boolean bl = useUpdateDialog = CheckUpdateTaskWithUI.this.listener != null ? CheckUpdateTaskWithUI.this.listener.useUpdateDialog((Context)activity) : Util.runsOnTablet((Context)activity).booleanValue();
                    if (useUpdateDialog) {
                        CheckUpdateTaskWithUI.this.showUpdateFragment(activity, updateInfo);
                    } else {
                        CheckUpdateTaskWithUI.this.startUpdateIntent(activity, updateInfo, false);
                    }
                }
            });
            this.mDialog = builder.create();
            this.mDialog.show();
        } else {
            String appName = Util.getAppName((Context)activity);
            String toast = activity.getString(R.string.hockeyapp_update_mandatory_toast, new Object[]{appName});
            Toast.makeText((Context)activity, (CharSequence)toast, (int)1).show();
            this.startUpdateIntent(activity, updateInfo, true);
        }
    }

    private void showUpdateFragment(Activity activity, JSONArray updateInfo) {
        if (activity != null) {
            FragmentTransaction fragmentTransaction = activity.getFragmentManager().beginTransaction();
            fragmentTransaction.setTransition(4097);
            Fragment existingFragment = activity.getFragmentManager().findFragmentByTag("hockey_update_dialog");
            if (existingFragment != null) {
                fragmentTransaction.remove(existingFragment);
            }
            fragmentTransaction.addToBackStack(null);
            Class<UpdateFragment> fragmentClass = UpdateFragment.class;
            if (this.listener != null) {
                fragmentClass = this.listener.getUpdateFragmentClass();
            }
            try {
                Method method = fragmentClass.getMethod("newInstance", String.class, String.class, Boolean.TYPE);
                DialogFragment updateFragment = (DialogFragment)method.invoke(null, updateInfo.toString(), this.apkUrlString, true);
                updateFragment.show(fragmentTransaction, "hockey_update_dialog");
            }
            catch (Exception e) {
                HockeyLog.error("An exception happened while showing the update fragment", e);
            }
        }
    }

    private void startUpdateIntent(Activity activity, JSONArray updateInfo, Boolean finish) {
        if (activity != null) {
            Class<UpdateFragment> fragmentClass = UpdateFragment.class;
            if (this.listener != null) {
                fragmentClass = this.listener.getUpdateFragmentClass();
            }
            Intent intent = new Intent();
            intent.setClass((Context)activity, UpdateActivity.class);
            intent.putExtra("fragmentClass", fragmentClass.getName());
            intent.putExtra("versionInfo", updateInfo.toString());
            intent.putExtra("url", this.apkUrlString);
            intent.putExtra("dialog", false);
            activity.startActivity(intent);
            if (finish.booleanValue()) {
                activity.finish();
            }
        }
        this.cleanUp();
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this.mWeakActivity = null;
        this.mDialog = null;
    }
}

