/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.metrics;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.PrivateEventManager;
import net.hockeyapp.android.metrics.Channel;
import net.hockeyapp.android.metrics.Persistence;
import net.hockeyapp.android.metrics.Sender;
import net.hockeyapp.android.metrics.TelemetryContext;
import net.hockeyapp.android.metrics.model.Data;
import net.hockeyapp.android.metrics.model.Domain;
import net.hockeyapp.android.metrics.model.EventData;
import net.hockeyapp.android.metrics.model.SessionState;
import net.hockeyapp.android.metrics.model.SessionStateData;
import net.hockeyapp.android.metrics.model.TelemetryData;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.Util;

public class MetricsManager {
    private static final String TAG = "HA-MetricsManager";
    private static boolean sUserMetricsEnabled = true;
    private static final AtomicInteger ACTIVITY_COUNT = new AtomicInteger(0);
    private static final AtomicLong LAST_BACKGROUND = new AtomicLong(MetricsManager.getTime());
    private static final Integer SESSION_RENEWAL_INTERVAL = 20000;
    private static final Object LOCK = new Object();
    private static volatile MetricsManager instance;
    private static WeakReference<Application> sWeakApplication;
    private static Sender sSender;
    private static Channel sChannel;
    private static TelemetryContext sTelemetryContext;
    private volatile boolean mSessionTrackingDisabled;
    private TelemetryLifecycleCallbacks mTelemetryLifecycleCallbacks;

    MetricsManager(Context context, TelemetryContext telemetryContext, Sender sender, Persistence persistence, Channel channel) {
        sTelemetryContext = telemetryContext;
        if (sender == null) {
            sender = new Sender();
        }
        sSender = sender;
        if (persistence == null) {
            persistence = new Persistence(context, sender);
        } else {
            persistence.setSender(sender);
        }
        sSender.setPersistence(persistence);
        sChannel = channel == null ? new Channel(sTelemetryContext, persistence) : channel;
        persistence.sendAvailable();
    }

    public static void register(Application application) {
        String appIdentifier = Util.getAppIdentifier(application.getApplicationContext());
        if (appIdentifier == null || appIdentifier.length() == 0) {
            throw new IllegalArgumentException("HockeyApp app identifier was not configured correctly in manifest or build configuration.");
        }
        MetricsManager.register(application, appIdentifier);
    }

    public static void register(Application application, String appIdentifier) {
        MetricsManager.register(application, appIdentifier, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Application application, String appIdentifier, Sender sender, Persistence persistence, Channel channel) {
        MetricsManager result = instance;
        if (result == null) {
            Object object = LOCK;
            synchronized (object) {
                result = instance;
                if (result == null) {
                    Constants.loadFromContext(application.getApplicationContext());
                    result = new MetricsManager(application.getApplicationContext(), new TelemetryContext(application.getApplicationContext(), appIdentifier), sender, persistence, channel);
                    sWeakApplication = new WeakReference<Application>(application);
                }
                result.mSessionTrackingDisabled = false;
                instance = result;
                if (!result.mSessionTrackingDisabled) {
                    MetricsManager.setSessionTrackingDisabled(false);
                }
            }
            PrivateEventManager.addEventListener(new PrivateEventManager.HockeyEventListener(){

                @Override
                public void onHockeyEvent(PrivateEventManager.Event event) {
                    if (event.getType() == 1) {
                        sChannel.synchronize();
                    }
                }
            });
        }
    }

    public static void disableUserMetrics() {
        MetricsManager.setUserMetricsEnabled(false);
    }

    public static void enableUserMetrics() {
        MetricsManager.setUserMetricsEnabled(true);
    }

    public static boolean isUserMetricsEnabled() {
        return sUserMetricsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setUserMetricsEnabled(boolean enabled) {
        sUserMetricsEnabled = enabled;
        if (instance != null) {
            Object object = LOCK;
            synchronized (object) {
                if (sUserMetricsEnabled) {
                    instance.registerTelemetryLifecycleCallbacks();
                } else {
                    instance.unregisterTelemetryLifecycleCallbacks();
                }
            }
        }
    }

    @Deprecated
    public static boolean sessionTrackingEnabled() {
        if (instance == null) {
            HockeyLog.error(TAG, "MetricsManager hasn't been registered or User Metrics has been disabled. No User Metrics will be collected!");
            return false;
        }
        return MetricsManager.isUserMetricsEnabled() && !MetricsManager.instance.mSessionTrackingDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void setSessionTrackingDisabled(Boolean disabled) {
        if (instance == null || !MetricsManager.isUserMetricsEnabled()) {
            HockeyLog.warn(TAG, "MetricsManager hasn't been registered or User Metrics has been disabled. No User Metrics will be collected!");
        } else {
            Object object = LOCK;
            synchronized (object) {
                MetricsManager.instance.mSessionTrackingDisabled = disabled;
                if (!disabled.booleanValue()) {
                    instance.registerTelemetryLifecycleCallbacks();
                }
            }
        }
    }

    private void registerTelemetryLifecycleCallbacks() {
        Application application;
        if (this.mTelemetryLifecycleCallbacks == null) {
            this.mTelemetryLifecycleCallbacks = new TelemetryLifecycleCallbacks();
        }
        if ((application = MetricsManager.getApplication()) != null) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mTelemetryLifecycleCallbacks);
        }
    }

    private void unregisterTelemetryLifecycleCallbacks() {
        if (this.mTelemetryLifecycleCallbacks == null) {
            return;
        }
        Application application = MetricsManager.getApplication();
        if (application != null) {
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mTelemetryLifecycleCallbacks);
        }
        this.mTelemetryLifecycleCallbacks = null;
    }

    public static void setCustomServerURL(String serverURL) {
        if (sSender != null) {
            sSender.setCustomServerURL(serverURL);
        } else {
            HockeyLog.warn(TAG, "HockeyApp couldn't set the custom server url. Please register(...) the MetricsManager before setting the server URL.");
        }
    }

    private static Application getApplication() {
        return sWeakApplication != null ? (Application)sWeakApplication.get() : null;
    }

    private static long getTime() {
        return new Date().getTime();
    }

    protected static Channel getChannel() {
        return sChannel;
    }

    protected void setChannel(Channel channel) {
        sChannel = channel;
    }

    protected static Sender getSender() {
        return sSender;
    }

    protected static void setSender(Sender sender) {
        sSender = sender;
    }

    protected static MetricsManager getInstance() {
        return instance;
    }

    private void updateSession() {
        int count = ACTIVITY_COUNT.getAndIncrement();
        if (count == 0) {
            if (MetricsManager.sessionTrackingEnabled()) {
                HockeyLog.debug(TAG, "Starting & tracking session");
                this.renewSession();
            } else {
                HockeyLog.debug(TAG, "Session management disabled by the developer");
            }
        } else {
            long then;
            long now = MetricsManager.getTime();
            boolean shouldRenew = now - (then = LAST_BACKGROUND.getAndSet(MetricsManager.getTime())) >= (long)SESSION_RENEWAL_INTERVAL.intValue();
            HockeyLog.debug(TAG, "Checking if we have to renew a session, time difference is: " + (now - then));
            if (shouldRenew && MetricsManager.sessionTrackingEnabled()) {
                HockeyLog.debug(TAG, "Renewing session");
                this.renewSession();
            }
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void renewSession() {
        final String sessionId = UUID.randomUUID().toString();
        try {
            AsyncTaskUtils.execute(new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    sTelemetryContext.renewSessionContext(sessionId);
                    MetricsManager.this.trackSessionState(SessionState.START);
                    return null;
                }
            });
        }
        catch (RejectedExecutionException e) {
            HockeyLog.error("Could not track session state. Executor rejected async task.", e);
        }
    }

    private void trackSessionState(SessionState sessionState) {
        SessionStateData sessionItem = new SessionStateData();
        sessionItem.setState(sessionState);
        Data<Domain> data = MetricsManager.createData(sessionItem);
        sChannel.enqueueData(data);
    }

    private static Data<Domain> createData(TelemetryData telemetryData) {
        Data<Domain> data = new Data<Domain>();
        data.setBaseData(telemetryData);
        data.setBaseType(telemetryData.getBaseType());
        data.QualifiedName = telemetryData.getEnvelopeName();
        return data;
    }

    public static void trackEvent(String eventName) {
        MetricsManager.trackEvent(eventName, null);
    }

    public static void trackEvent(String eventName, Map<String, String> properties) {
        MetricsManager.trackEvent(eventName, properties, null);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    public static void trackEvent(String eventName, Map<String, String> properties, Map<String, Double> measurements) {
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            return;
        }
        if (instance == null) {
            HockeyLog.error(TAG, "MetricsManager hasn't been registered or User Metrics has been disabled. No User Metrics will be collected!");
            return;
        }
        if (!MetricsManager.isUserMetricsEnabled()) {
            HockeyLog.warn("User Metrics is disabled. Will not track event.");
            return;
        }
        final EventData eventItem = new EventData();
        eventItem.setName(eventName);
        if (properties != null) {
            eventItem.setProperties(properties);
        }
        if (measurements != null) {
            eventItem.setMeasurements(measurements);
        }
        try {
            AsyncTaskUtils.execute(new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    Data data = MetricsManager.createData(eventItem);
                    sChannel.enqueueData(data);
                    return null;
                }
            });
        }
        catch (RejectedExecutionException e) {
            HockeyLog.error("Could not track custom event. Executor rejected async task.", e);
        }
    }

    private class TelemetryLifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private final long MAX_ACTIVITY_TRANSITION_TIME_MS = 2000L;
        private Timer mActivityTransitionTimer;
        private TimerTask mActivityTransitionTimerTask;

        private TelemetryLifecycleCallbacks() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
            MetricsManager.this.updateSession();
            if (this.mActivityTransitionTimerTask != null) {
                this.mActivityTransitionTimerTask.cancel();
                this.mActivityTransitionTimerTask = null;
            }
            if (this.mActivityTransitionTimer != null) {
                this.mActivityTransitionTimer.cancel();
                this.mActivityTransitionTimer = null;
            }
        }

        public void onActivityPaused(Activity activity) {
            LAST_BACKGROUND.set(MetricsManager.getTime());
            this.mActivityTransitionTimer = new Timer();
            this.mActivityTransitionTimerTask = new TimerTask(){

                @Override
                public void run() {
                    HockeyLog.debug(MetricsManager.TAG, "Application goes into the background. Sending logs.");
                    sChannel.synchronize();
                }
            };
            this.mActivityTransitionTimer.schedule(this.mActivityTransitionTimerTask, 2000L);
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

