/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.metrics;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hockeyapp.android.metrics.model.IJsonSerializable;

public final class JsonHelper {
    private static final int CONTROL_CHARACTER_RANGE = 128;
    private static final String[] CONTROL_CHARACTERS = new String[128];

    private JsonHelper() {
    }

    private static String escapeJSON(String input) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        for (int i = 0; i < input.length(); ++i) {
            char charIndex = input.charAt(i);
            if (charIndex < '\u0080') {
                String replacement = CONTROL_CHARACTERS[charIndex];
                if (replacement == null) {
                    builder.append(charIndex);
                    continue;
                }
                builder.append(replacement);
                continue;
            }
            if (charIndex == '\u2028') {
                builder.append("\\u2028");
                continue;
            }
            if (charIndex == '\u2029') {
                builder.append("\\u2029");
                continue;
            }
            builder.append(charIndex);
        }
        builder.append("\"");
        return builder.toString();
    }

    public static String convert(Integer value) {
        return Integer.toString(value);
    }

    public static String convert(Long value) {
        return Long.toString(value);
    }

    public static String convert(char value) {
        return Character.toString(value);
    }

    public static String convert(Float value) {
        return Float.toString(value.floatValue());
    }

    public static String convert(Double value) {
        return Double.toString(value);
    }

    public static String convert(boolean value) {
        return Boolean.toString(value);
    }

    public static String convert(String value) {
        if (value == null) {
            return "null";
        }
        if (value.length() == 0) {
            return "\"\"";
        }
        return JsonHelper.escapeJSON(value);
    }

    public static void writeJsonSerializable(Writer writer, IJsonSerializable value) throws IOException {
        if (value != null) {
            value.serialize(writer);
        }
    }

    public static <T> void writeDictionary(Writer writer, Map<String, T> map) throws IOException {
        if (map == null || map.isEmpty()) {
            writer.write("null");
        } else {
            Set<String> keys = map.keySet();
            Iterator<String> iterator = keys.iterator();
            if (iterator.hasNext()) {
                writer.write("{");
                String key = iterator.next();
                T item = map.get(key);
                writer.write("\"" + key + "\"");
                writer.write(":");
                JsonHelper.writeItem(writer, item);
                while (iterator.hasNext()) {
                    key = iterator.next();
                    writer.write(",");
                    writer.write("\"" + key + "\"");
                    writer.write(":");
                    item = map.get(key);
                    JsonHelper.writeItem(writer, item);
                }
                writer.write("}");
            }
        }
    }

    public static <T extends IJsonSerializable> void writeList(Writer writer, List<T> list) throws IOException {
        if (list == null || list.isEmpty()) {
            writer.write("null");
        } else {
            Iterator<T> iterator = list.iterator();
            if (iterator.hasNext()) {
                writer.write("[");
                IJsonSerializable item = (IJsonSerializable)iterator.next();
                item.serialize(writer);
                while (iterator.hasNext()) {
                    item = (IJsonSerializable)iterator.next();
                    writer.write(",");
                    item.serialize(writer);
                }
                writer.write("]");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> void writeItem(Writer writer, T item) throws IOException {
        if (item != null) {
            if (item instanceof String) {
                writer.write(JsonHelper.convert((String)item));
                return;
            } else if (item instanceof Double) {
                writer.write(JsonHelper.convert((Double)item));
                return;
            } else if (item instanceof Integer) {
                writer.write(JsonHelper.convert((Integer)item));
                return;
            } else if (item instanceof Long) {
                writer.write(JsonHelper.convert((Long)item));
                return;
            } else {
                if (!(item instanceof IJsonSerializable)) throw new IOException("Cannot serialize: " + item.toString());
                ((IJsonSerializable)item).serialize(writer);
            }
            return;
        } else {
            writer.write("null");
        }
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonHelper.CONTROL_CHARACTERS[i] = String.format("\\u%04X", i);
        }
        JsonHelper.CONTROL_CHARACTERS[34] = "\\\"";
        JsonHelper.CONTROL_CHARACTERS[92] = "\\\\";
        JsonHelper.CONTROL_CHARACTERS[8] = "\\b";
        JsonHelper.CONTROL_CHARACTERS[12] = "\\f";
        JsonHelper.CONTROL_CHARACTERS[10] = "\\n";
        JsonHelper.CONTROL_CHARACTERS[13] = "\\r";
        JsonHelper.CONTROL_CHARACTERS[9] = "\\t";
    }
}

