/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import java.lang.ref.WeakReference;
import java.util.Date;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.ExpiryInfoActivity;
import net.hockeyapp.android.UpdateManagerListener;
import net.hockeyapp.android.tasks.CheckUpdateTask;
import net.hockeyapp.android.tasks.CheckUpdateTaskWithUI;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.Util;

public class UpdateManager {
    public static final String INSTALLER_ADB = "adb";
    public static final String INSTALLER_PACKAGE_INSTALLER_NOUGAT = "com.google.android.packageinstaller";
    public static final String INSTALLER_PACKAGE_INSTALLER_NOUGAT2 = "com.android.packageinstaller";
    private static CheckUpdateTask updateTask = null;

    public static void register(Activity activity) {
        String appIdentifier = Util.getAppIdentifier((Context)activity);
        UpdateManager.register(activity, appIdentifier);
    }

    public static void register(Activity activity, UpdateManagerListener listener) {
        String appIdentifier = Util.getAppIdentifier((Context)activity);
        UpdateManager.register(activity, appIdentifier, listener);
    }

    public static void register(Activity activity, String appIdentifier) {
        UpdateManager.register(activity, appIdentifier, true);
    }

    public static void register(Activity activity, String appIdentifier, boolean isDialogRequired) {
        UpdateManager.register(activity, appIdentifier, null, isDialogRequired);
    }

    public static void register(Activity activity, String appIdentifier, UpdateManagerListener listener) {
        UpdateManager.register(activity, "https://sdk.hockeyapp.net/", appIdentifier, listener, true);
    }

    public static void register(Activity activity, String appIdentifier, UpdateManagerListener listener, boolean isDialogRequired) {
        UpdateManager.register(activity, "https://sdk.hockeyapp.net/", appIdentifier, listener, isDialogRequired);
    }

    public static void register(Activity activity, String urlString, String appIdentifier, UpdateManagerListener listener) {
        UpdateManager.register(activity, urlString, appIdentifier, listener, true);
    }

    public static void register(Activity activity, String urlString, String appIdentifier, UpdateManagerListener listener, boolean isDialogRequired) {
        appIdentifier = Util.sanitizeAppIdentifier(appIdentifier);
        Constants.loadFromContext((Context)activity);
        WeakReference<Activity> weakActivity = new WeakReference<Activity>(activity);
        if (UpdateManager.dialogShown(weakActivity)) {
            return;
        }
        if (!UpdateManager.checkExpiryDate(weakActivity, listener) && (listener != null && listener.canUpdateInMarket() || !UpdateManager.installedFromMarket(weakActivity))) {
            UpdateManager.startUpdateTask(weakActivity, urlString, appIdentifier, listener, isDialogRequired);
        }
    }

    public static void registerForBackground(Context appContext, String appIdentifier, UpdateManagerListener listener) {
        UpdateManager.registerForBackground(appContext, "https://sdk.hockeyapp.net/", appIdentifier, listener);
    }

    public static void registerForBackground(Context appContext, String urlString, String appIdentifier, UpdateManagerListener listener) {
        appIdentifier = Util.sanitizeAppIdentifier(appIdentifier);
        WeakReference<Context> weakContext = new WeakReference<Context>(appContext);
        if (!UpdateManager.checkExpiryDateForBackground(listener) && (listener != null && listener.canUpdateInMarket() || !UpdateManager.installedFromMarket(weakContext))) {
            UpdateManager.startUpdateTaskForBackground(weakContext, urlString, appIdentifier, listener);
        }
    }

    public static void unregister() {
        if (updateTask != null) {
            updateTask.cancel(true);
            updateTask.detach();
            updateTask = null;
        }
    }

    private static boolean checkExpiryDate(WeakReference<Activity> weakActivity, UpdateManagerListener listener) {
        boolean handle = false;
        boolean hasExpired = UpdateManager.checkExpiryDateForBackground(listener);
        if (hasExpired) {
            handle = listener.onBuildExpired();
        }
        if (hasExpired && handle) {
            UpdateManager.startExpiryInfoIntent(weakActivity);
        }
        return hasExpired;
    }

    private static boolean checkExpiryDateForBackground(UpdateManagerListener listener) {
        boolean result = false;
        if (listener != null) {
            Date expiryDate = listener.getExpiryDate();
            result = expiryDate != null && new Date().compareTo(expiryDate) > 0;
        }
        return result;
    }

    protected static boolean installedFromMarket(WeakReference<? extends Context> weakContext) {
        boolean result = false;
        Context context = (Context)weakContext.get();
        if (context != null) {
            try {
                String installer = context.getPackageManager().getInstallerPackageName(context.getPackageName());
                if (!TextUtils.isEmpty((CharSequence)installer)) {
                    result = true;
                    if (Build.VERSION.SDK_INT >= 24 && (TextUtils.equals((CharSequence)installer, (CharSequence)INSTALLER_PACKAGE_INSTALLER_NOUGAT) || TextUtils.equals((CharSequence)installer, (CharSequence)INSTALLER_PACKAGE_INSTALLER_NOUGAT2))) {
                        result = false;
                    }
                    if (TextUtils.equals((CharSequence)installer, (CharSequence)INSTALLER_ADB)) {
                        result = false;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private static void startExpiryInfoIntent(WeakReference<Activity> weakActivity) {
        Activity activity;
        if (weakActivity != null && (activity = (Activity)weakActivity.get()) != null) {
            activity.finish();
            Intent intent = new Intent((Context)activity, ExpiryInfoActivity.class);
            intent.addFlags(0x14000000);
            activity.startActivity(intent);
        }
    }

    private static void startUpdateTask(WeakReference<Activity> weakActivity, String urlString, String appIdentifier, UpdateManagerListener listener, boolean isDialogRequired) {
        if (updateTask == null || updateTask.getStatus() == AsyncTask.Status.FINISHED) {
            updateTask = new CheckUpdateTaskWithUI(weakActivity, urlString, appIdentifier, listener, isDialogRequired);
            AsyncTaskUtils.execute(updateTask);
        } else {
            updateTask.attach(weakActivity);
        }
    }

    private static void startUpdateTaskForBackground(WeakReference<Context> weakContext, String urlString, String appIdentifier, UpdateManagerListener listener) {
        if (updateTask == null || updateTask.getStatus() == AsyncTask.Status.FINISHED) {
            updateTask = new CheckUpdateTask(weakContext, urlString, appIdentifier, listener);
            AsyncTaskUtils.execute(updateTask);
        } else {
            updateTask.attach(weakContext);
        }
    }

    private static boolean dialogShown(WeakReference<Activity> weakActivity) {
        Activity activity;
        if (weakActivity != null && (activity = (Activity)weakActivity.get()) != null) {
            Fragment existingFragment = activity.getFragmentManager().findFragmentByTag("hockey_update_dialog");
            return existingFragment != null;
        }
        return false;
    }
}

