/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Locale;
import net.hockeyapp.android.R;
import net.hockeyapp.android.UpdateInfoListener;
import net.hockeyapp.android.listeners.DownloadFileListener;
import net.hockeyapp.android.tasks.DownloadFileTask;
import net.hockeyapp.android.tasks.GetFileSizeTask;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.PermissionsUtil;
import net.hockeyapp.android.utils.Util;
import net.hockeyapp.android.utils.VersionHelper;

public class UpdateFragment
extends DialogFragment
implements View.OnClickListener,
UpdateInfoListener {
    public static final String FRAGMENT_URL = "url";
    public static final String FRAGMENT_VERSION_INFO = "versionInfo";
    public static final String FRAGMENT_DIALOG = "dialog";
    public static final String FRAGMENT_TAG = "hockey_update_dialog";
    private String mVersionInfo;
    private String mUrlString;

    public static UpdateFragment newInstance(String versionInfo, String urlString, boolean dialog) {
        Bundle arguments = new Bundle();
        arguments.putString(FRAGMENT_URL, urlString);
        arguments.putString(FRAGMENT_VERSION_INFO, versionInfo);
        arguments.putBoolean(FRAGMENT_DIALOG, dialog);
        UpdateFragment fragment = new UpdateFragment();
        fragment.setArguments(arguments);
        return fragment;
    }

    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        if (dialog != null && dialog.getWindow() != null) {
            int width = -1;
            int height = -1;
            dialog.getWindow().setLayout(width, height);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        Bundle arguments = this.getArguments();
        this.mUrlString = arguments.getString(FRAGMENT_URL);
        this.mVersionInfo = arguments.getString(FRAGMENT_VERSION_INFO);
        boolean dialog = arguments.getBoolean(FRAGMENT_DIALOG);
        this.setShowsDialog(dialog);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = this.getLayoutView();
        VersionHelper versionHelper = new VersionHelper((Context)this.getActivity(), this.mVersionInfo, this);
        TextView nameLabel = (TextView)view.findViewById(R.id.label_title);
        nameLabel.setText((CharSequence)Util.getAppName((Context)this.getActivity()));
        nameLabel.setContentDescription(nameLabel.getText());
        final TextView versionLabel = (TextView)view.findViewById(R.id.label_version);
        final String versionString = String.format(this.getString(R.string.hockeyapp_update_version), versionHelper.getVersionString());
        final String fileDate = versionHelper.getFileDateString();
        String appSizeString = this.getString(R.string.hockeyapp_update_unknown_size);
        long appSize = versionHelper.getFileSizeBytes();
        if (appSize >= 0L) {
            appSizeString = String.format(Locale.US, "%.2f", Float.valueOf((float)appSize / 1048576.0f)) + " MB";
        } else {
            GetFileSizeTask task = new GetFileSizeTask((Context)this.getActivity(), this.mUrlString, new DownloadFileListener(){

                @Override
                public void downloadSuccessful(DownloadFileTask task) {
                    if (task instanceof GetFileSizeTask) {
                        long appSize = ((GetFileSizeTask)task).getSize();
                        String appSizeString = String.format(Locale.US, "%.2f", Float.valueOf((float)appSize / 1048576.0f)) + " MB";
                        versionLabel.setText((CharSequence)UpdateFragment.this.getString(R.string.hockeyapp_update_version_details_label, new Object[]{versionString, fileDate, appSizeString}));
                    }
                }
            });
            AsyncTaskUtils.execute(task);
        }
        versionLabel.setText((CharSequence)this.getString(R.string.hockeyapp_update_version_details_label, new Object[]{versionString, fileDate, appSizeString}));
        Button updateButton = (Button)view.findViewById(R.id.button_update);
        updateButton.setOnClickListener((View.OnClickListener)this);
        WebView webView = (WebView)view.findViewById(R.id.web_update_details);
        webView.clearCache(true);
        webView.destroyDrawingCache();
        webView.loadDataWithBaseURL("https://sdk.hockeyapp.net/", versionHelper.getReleaseNotes(false), "text/html", "utf-8", null);
        return view;
    }

    public void onDestroyView() {
        Dialog dialog = this.getDialog();
        if (dialog != null && this.getRetainInstance()) {
            dialog.setDismissMessage(null);
        }
        super.onDestroyView();
    }

    public void onClick(View view) {
        this.prepareDownload();
    }

    @Override
    public int getCurrentVersionCode() {
        int currentVersionCode = -1;
        try {
            currentVersionCode = this.getActivity().getPackageManager().getPackageInfo((String)this.getActivity().getPackageName(), (int)128).versionCode;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            // empty catch block
        }
        return currentVersionCode;
    }

    private void showError(int message) {
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.hockeyapp_dialog_error_title).setMessage(message).setCancelable(false).setPositiveButton(R.string.hockeyapp_dialog_positive_button, null).create();
        alertDialog.show();
    }

    private static String[] requiredPermissions() {
        ArrayList<String> permissions = new ArrayList<String>();
        if (Build.VERSION.SDK_INT < 19) {
            permissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
        }
        return permissions.toArray(new String[0]);
    }

    protected void prepareDownload() {
        Activity context = this.getActivity();
        if (!Util.isConnectedToNetwork((Context)context)) {
            this.showError(R.string.hockeyapp_error_no_network_message);
            return;
        }
        String[] permissions = UpdateFragment.requiredPermissions();
        int[] permissionsState = PermissionsUtil.permissionsState((Context)context, permissions);
        if (!PermissionsUtil.permissionsAreGranted(permissionsState)) {
            this.showError(R.string.hockeyapp_error_no_external_storage_permission);
            return;
        }
        if (!PermissionsUtil.isUnknownSourcesEnabled((Context)context)) {
            if (Build.VERSION.SDK_INT >= 26) {
                Intent intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
                intent.setData(Uri.parse((String)("package:" + context.getPackageName())));
                context.startActivity(intent);
            } else {
                this.showError(R.string.hockeyapp_error_install_form_unknown_sources_disabled);
            }
            return;
        }
        this.startDownloadTask();
        if (this.getShowsDialog()) {
            this.dismiss();
        }
    }

    protected void startDownloadTask() {
        AsyncTaskUtils.execute(new DownloadFileTask((Context)this.getActivity(), this.mUrlString, new DownloadFileListener(){

            @Override
            public void downloadFailed(DownloadFileTask task, Boolean userWantsRetry) {
                if (userWantsRetry.booleanValue()) {
                    UpdateFragment.this.startDownloadTask();
                }
            }

            @Override
            public void downloadSuccessful(DownloadFileTask task) {
            }
        }));
    }

    public View getLayoutView() {
        LinearLayout layout2 = new LinearLayout((Context)this.getActivity());
        LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.hockeyapp_fragment_update, (ViewGroup)layout2);
        return layout2;
    }
}

