/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import java.lang.ref.WeakReference;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import net.hockeyapp.android.LoginManager;
import net.hockeyapp.android.R;
import net.hockeyapp.android.tasks.LoginTask;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.Util;

public class LoginActivity
extends Activity {
    public static final String EXTRA_URL = "url";
    public static final String EXTRA_SECRET = "secret";
    public static final String EXTRA_MODE = "mode";
    private String mUrl;
    private String mSecret;
    private int mMode;
    private LoginTask mLoginTask;
    private Handler mLoginHandler;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hockeyapp_activity_login);
        Bundle extras = this.getIntent().getExtras();
        if (extras != null) {
            this.mUrl = extras.getString(EXTRA_URL);
            this.mSecret = extras.getString(EXTRA_SECRET);
            this.mMode = extras.getInt(EXTRA_MODE);
        }
        this.configureView();
        this.initLoginHandler();
        Object object = this.getLastNonConfigurationInstance();
        if (object != null) {
            this.mLoginTask = (LoginTask)((Object)object);
            this.mLoginTask.attach((Context)this, this.mLoginHandler);
        }
    }

    public Object onRetainNonConfigurationInstance() {
        if (this.mLoginTask != null) {
            this.mLoginTask.detach();
        }
        return this.mLoginTask;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (LoginManager.listener != null) {
                LoginManager.listener.onBack();
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void configureView() {
        if (this.mMode == 1) {
            EditText passwordInput = (EditText)this.findViewById(R.id.input_password);
            passwordInput.setVisibility(4);
        }
        TextView headlineText = (TextView)this.findViewById(R.id.text_headline);
        headlineText.setText(this.mMode == 1 ? R.string.hockeyapp_login_headline_text_email_only : R.string.hockeyapp_login_headline_text);
        Button loginButton = (Button)this.findViewById(R.id.button_login);
        loginButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LoginActivity.this.performAuthentication();
            }
        });
    }

    private void initLoginHandler() {
        this.mLoginHandler = new LoginHandler(this);
    }

    private void performAuthentication() {
        if (!Util.isConnectedToNetwork((Context)this)) {
            Toast errorToast = Toast.makeText((Context)this, (int)R.string.hockeyapp_error_no_network_message, (int)1);
            errorToast.show();
            return;
        }
        String email = ((EditText)this.findViewById(R.id.input_email)).getText().toString();
        String password = ((EditText)this.findViewById(R.id.input_password)).getText().toString();
        boolean ready = false;
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.mMode == 1) {
            ready = !TextUtils.isEmpty((CharSequence)email);
            params.put("email", email);
            params.put("authcode", this.md5(this.mSecret + email));
        } else if (this.mMode == 2) {
            ready = !TextUtils.isEmpty((CharSequence)email) && !TextUtils.isEmpty((CharSequence)password);
            params.put("email", email);
            params.put("password", password);
        }
        if (ready) {
            this.mLoginTask = new LoginTask((Context)this, this.mLoginHandler, this.mUrl, this.mMode, params);
            AsyncTaskUtils.execute(this.mLoginTask);
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.hockeyapp_login_missing_credentials_toast), (int)1).show();
        }
    }

    public String md5(String s) {
        try {
            return Util.bytesToHex(Util.hash(s.getBytes(), "MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            HockeyLog.error("Failed to create MD5 hash", e);
            return "";
        }
    }

    private static class LoginHandler
    extends Handler {
        private final WeakReference<Activity> mWeakActivity;

        LoginHandler(Activity activity) {
            this.mWeakActivity = new WeakReference<Activity>(activity);
        }

        public void handleMessage(Message msg) {
            Activity activity = (Activity)this.mWeakActivity.get();
            if (activity == null) {
                return;
            }
            Bundle bundle = msg.getData();
            boolean success = bundle.getBoolean("success");
            if (success) {
                activity.finish();
                if (LoginManager.listener != null) {
                    LoginManager.listener.onSuccess();
                }
            } else {
                Toast.makeText((Context)activity, (CharSequence)"Login failed. Check your credentials.", (int)1).show();
            }
        }
    }
}

