/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import net.hockeyapp.android.FeedbackManager;
import net.hockeyapp.android.PaintActivity;
import net.hockeyapp.android.R;
import net.hockeyapp.android.adapters.MessagesAdapter;
import net.hockeyapp.android.objects.FeedbackMessage;
import net.hockeyapp.android.objects.FeedbackResponse;
import net.hockeyapp.android.objects.FeedbackUserDataElement;
import net.hockeyapp.android.tasks.ParseFeedbackTask;
import net.hockeyapp.android.tasks.SendFeedbackTask;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.PrefsUtil;
import net.hockeyapp.android.utils.Util;
import net.hockeyapp.android.views.AttachmentListView;
import net.hockeyapp.android.views.AttachmentView;

public class FeedbackActivity
extends Activity
implements View.OnClickListener,
View.OnFocusChangeListener {
    public static final String EXTRA_URL = "url";
    public static final String EXTRA_TOKEN = "token";
    public static final String EXTRA_FORCE_NEW_THREAD = "forceNewThread";
    public static final String EXTRA_INITIAL_USER_NAME = "initialUserName";
    public static final String EXTRA_INITIAL_USER_EMAIL = "initialUserEmail";
    public static final String EXTRA_INITIAL_USER_SUBJECT = "initialUserSubject";
    public static final String EXTRA_INITIAL_ATTACHMENTS = "initialAttachments";
    public static final String EXTRA_USER_ID = "userId";
    private static final int MAX_ATTACHMENTS_PER_MSG = 3;
    private static final int ATTACH_PICTURE = 1;
    private static final int ATTACH_FILE = 2;
    private static final int PAINT_IMAGE = 3;
    private String mInitialUserName;
    private String mInitialUserEmail;
    private String mInitialUserSubject;
    private String mUserId;
    private List<Uri> mInitialAttachments = new ArrayList<Uri>();
    private Context mContext;
    private TextView mLastUpdatedTextView;
    private EditText mNameInput;
    private EditText mEmailInput;
    private EditText mSubjectInput;
    private EditText mTextInput;
    private Button mSendFeedbackButton;
    private ListView mMessagesListView;
    private AttachmentListView mAttachmentListView;
    private SendFeedbackTask mSendFeedbackTask;
    private Handler mFeedbackHandler;
    private ParseFeedbackTask mParseFeedbackTask;
    private Handler mParseFeedbackHandler;
    private String mUrl;
    private MessagesAdapter mMessagesAdapter;
    private boolean mInSendFeedback;
    private boolean mForceNewThread;
    private boolean mFeedbackViewInitialized;
    private String mToken;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.getLayoutView());
        this.setTitle(R.string.hockeyapp_feedback_title);
        this.mContext = this;
        Bundle extras = this.getIntent().getExtras();
        if (extras != null) {
            this.mUrl = extras.getString(EXTRA_URL);
            this.mToken = extras.getString(EXTRA_TOKEN);
            this.mForceNewThread = extras.getBoolean(EXTRA_FORCE_NEW_THREAD);
            this.mInitialUserName = extras.getString(EXTRA_INITIAL_USER_NAME);
            this.mInitialUserEmail = extras.getString(EXTRA_INITIAL_USER_EMAIL);
            this.mInitialUserSubject = extras.getString(EXTRA_INITIAL_USER_SUBJECT);
            this.mUserId = extras.getString(EXTRA_USER_ID);
            Parcelable[] initialAttachmentsArray = extras.getParcelableArray(EXTRA_INITIAL_ATTACHMENTS);
            if (initialAttachmentsArray != null) {
                this.mInitialAttachments.clear();
                for (Parcelable parcelable : initialAttachmentsArray) {
                    this.mInitialAttachments.add((Uri)parcelable);
                }
            }
        }
        if (savedInstanceState != null) {
            this.mFeedbackViewInitialized = savedInstanceState.getBoolean("feedbackViewInitialized");
            this.mInSendFeedback = savedInstanceState.getBoolean("inSendFeedback");
            this.mToken = savedInstanceState.getString(EXTRA_TOKEN);
        } else {
            this.mInSendFeedback = false;
            this.mFeedbackViewInitialized = false;
        }
        Util.cancelNotification((Context)this, 2);
        this.initFeedbackHandler();
        this.initParseFeedbackHandler();
        this.restoreSendFeedbackTask();
        this.configureAppropriateView();
    }

    private void restoreSendFeedbackTask() {
        Object object = this.getLastNonConfigurationInstance();
        if (object != null && object instanceof SendFeedbackTask) {
            this.mSendFeedbackTask = (SendFeedbackTask)((Object)object);
            this.mSendFeedbackTask.setHandler(this.mFeedbackHandler);
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            ArrayList attachmentsUris = savedInstanceState.getParcelableArrayList("attachments");
            if (attachmentsUris != null) {
                for (Uri attachmentUri : attachmentsUris) {
                    if (this.mInitialAttachments.contains(attachmentUri)) continue;
                    this.mAttachmentListView.addView((View)new AttachmentView((Context)this, (ViewGroup)this.mAttachmentListView, attachmentUri, true));
                }
            }
            this.mFeedbackViewInitialized = savedInstanceState.getBoolean("feedbackViewInitialized");
        }
        super.onRestoreInstanceState(savedInstanceState);
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putParcelableArrayList("attachments", this.mAttachmentListView.getAttachments());
        outState.putBoolean("feedbackViewInitialized", this.mFeedbackViewInitialized);
        outState.putBoolean("inSendFeedback", this.mInSendFeedback);
        outState.putString(EXTRA_TOKEN, this.mToken);
        super.onSaveInstanceState(outState);
    }

    protected void onStart() {
        super.onStart();
        if (this.mSendFeedbackTask != null) {
            this.mSendFeedbackTask.attach((Context)this);
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.mSendFeedbackTask != null) {
            this.mSendFeedbackTask.detach();
        }
    }

    public Object onRetainNonConfigurationInstance() {
        if (this.mSendFeedbackTask != null) {
            this.mSendFeedbackTask.detach();
        }
        return this.mSendFeedbackTask;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.mInSendFeedback) {
                this.mInSendFeedback = false;
                this.configureAppropriateView();
            } else {
                this.finish();
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.button_send) {
            this.sendFeedback();
        } else if (viewId == R.id.button_attachment) {
            if (this.mAttachmentListView.getChildCount() >= 3) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.hockeyapp_feedback_max_attachments_allowed, new Object[]{3}), (int)0).show();
            } else {
                this.openContextMenu(v);
            }
        } else if (viewId == R.id.button_add_response) {
            this.mInSendFeedback = true;
            this.configureFeedbackView(false);
        } else if (viewId == R.id.button_refresh) {
            this.sendFetchFeedback(this.mUrl, null, null, null, null, null, null, this.mToken, this.mFeedbackHandler, true);
        }
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            if (v instanceof EditText) {
                this.showKeyboard(v);
            } else if (v instanceof Button || v instanceof ImageButton) {
                this.hideKeyboard();
            }
        }
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        menu.add(0, 2, 0, (CharSequence)this.getString(R.string.hockeyapp_feedback_attach_file));
        menu.add(0, 1, 0, (CharSequence)this.getString(R.string.hockeyapp_feedback_attach_picture));
    }

    public boolean onContextItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 1: 
            case 2: {
                return this.addAttachment(item.getItemId());
            }
        }
        return super.onContextItemSelected(item);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Uri uri;
        if (resultCode != -1) {
            return;
        }
        if (requestCode == 2) {
            Uri uri2 = data.getData();
            if (uri2 != null) {
                this.mAttachmentListView.addView((View)new AttachmentView((Context)this, (ViewGroup)this.mAttachmentListView, uri2, true));
                Util.announceForAccessibility((View)this.mAttachmentListView, this.getString(R.string.hockeyapp_feedback_attachment_added));
            }
        } else if (requestCode == 1) {
            Uri uri3 = data.getData();
            if (uri3 != null) {
                try {
                    Intent intent = new Intent((Context)this, PaintActivity.class);
                    intent.putExtra("imageUri", (Parcelable)uri3);
                    this.startActivityForResult(intent, 3);
                }
                catch (ActivityNotFoundException e) {
                    HockeyLog.error("Paint activity not declared!", e);
                }
            }
        } else if (requestCode == 3 && (uri = (Uri)data.getParcelableExtra("imageUri")) != null) {
            this.mAttachmentListView.addView((View)new AttachmentView((Context)this, (ViewGroup)this.mAttachmentListView, uri, true));
            Util.announceForAccessibility((View)this.mAttachmentListView, this.getString(R.string.hockeyapp_feedback_attachment_added));
        }
    }

    @SuppressLint(value={"InflateParams"})
    public View getLayoutView() {
        return this.getLayoutInflater().inflate(R.layout.hockeyapp_activity_feedback, null);
    }

    public void enableDisableSendFeedbackButton(boolean isEnable) {
        if (this.mSendFeedbackButton != null) {
            this.mSendFeedbackButton.setEnabled(isEnable);
        }
    }

    protected void configureFeedbackView(boolean haveToken) {
        ScrollView feedbackScrollView = (ScrollView)this.findViewById(R.id.wrapper_feedback_scroll);
        LinearLayout wrapperLayoutFeedbackAndMessages = (LinearLayout)this.findViewById(R.id.wrapper_messages);
        this.mMessagesListView = (ListView)this.findViewById(R.id.list_feedback_messages);
        this.mAttachmentListView = (AttachmentListView)this.findViewById(R.id.wrapper_attachments);
        if (haveToken) {
            wrapperLayoutFeedbackAndMessages.setVisibility(0);
            feedbackScrollView.setVisibility(8);
            this.mLastUpdatedTextView = (TextView)this.findViewById(R.id.label_last_updated);
            this.mLastUpdatedTextView.setVisibility(4);
            Button addResponseButton = (Button)this.findViewById(R.id.button_add_response);
            addResponseButton.setOnClickListener((View.OnClickListener)this);
            addResponseButton.setOnFocusChangeListener((View.OnFocusChangeListener)this);
            Button refreshButton = (Button)this.findViewById(R.id.button_refresh);
            refreshButton.setOnClickListener((View.OnClickListener)this);
            refreshButton.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        } else {
            wrapperLayoutFeedbackAndMessages.setVisibility(8);
            feedbackScrollView.setVisibility(0);
            this.mNameInput = (EditText)this.findViewById(R.id.input_name);
            this.mNameInput.setOnFocusChangeListener((View.OnFocusChangeListener)this);
            this.mEmailInput = (EditText)this.findViewById(R.id.input_email);
            this.mEmailInput.setOnFocusChangeListener((View.OnFocusChangeListener)this);
            this.mSubjectInput = (EditText)this.findViewById(R.id.input_subject);
            this.mSubjectInput.setOnFocusChangeListener((View.OnFocusChangeListener)this);
            this.mTextInput = (EditText)this.findViewById(R.id.input_message);
            this.mTextInput.setOnFocusChangeListener((View.OnFocusChangeListener)this);
            this.configureHints();
            if (!this.mFeedbackViewInitialized) {
                this.mNameInput.setText((CharSequence)this.mInitialUserName);
                this.mEmailInput.setText((CharSequence)this.mInitialUserEmail);
                this.mSubjectInput.setText((CharSequence)this.mInitialUserSubject);
                if (TextUtils.isEmpty((CharSequence)this.mInitialUserName)) {
                    this.mNameInput.requestFocus();
                } else if (TextUtils.isEmpty((CharSequence)this.mInitialUserEmail)) {
                    this.mEmailInput.requestFocus();
                } else if (TextUtils.isEmpty((CharSequence)this.mInitialUserSubject)) {
                    this.mSubjectInput.requestFocus();
                } else {
                    this.mTextInput.requestFocus();
                }
                this.mFeedbackViewInitialized = true;
            }
            this.mNameInput.setVisibility(FeedbackManager.getRequireUserName() == FeedbackUserDataElement.DONT_SHOW ? 8 : 0);
            this.mEmailInput.setVisibility(FeedbackManager.getRequireUserEmail() == FeedbackUserDataElement.DONT_SHOW ? 8 : 0);
            this.mTextInput.setText((CharSequence)"");
            if ((!this.mForceNewThread || this.mInSendFeedback) && this.mToken != null) {
                this.mSubjectInput.setVisibility(8);
            } else {
                this.mSubjectInput.setVisibility(0);
            }
            this.mAttachmentListView.removeAllViews();
            for (Uri attachmentUri : this.mInitialAttachments) {
                this.mAttachmentListView.addView((View)new AttachmentView((Context)this, (ViewGroup)this.mAttachmentListView, attachmentUri, true));
            }
            Button addAttachmentButton = (Button)this.findViewById(R.id.button_attachment);
            addAttachmentButton.setOnClickListener((View.OnClickListener)this);
            addAttachmentButton.setOnFocusChangeListener((View.OnFocusChangeListener)this);
            this.registerForContextMenu((View)addAttachmentButton);
            this.mSendFeedbackButton = (Button)this.findViewById(R.id.button_send);
            this.mSendFeedbackButton.setOnClickListener((View.OnClickListener)this);
            addAttachmentButton.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        }
    }

    protected void onSendFeedbackResult(boolean success) {
    }

    private boolean addAttachment(int request) {
        if (request == 2) {
            Intent intent = new Intent();
            intent.setType("*/*");
            intent.setAction("android.intent.action.GET_CONTENT");
            this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)this.getString(R.string.hockeyapp_feedback_select_file)), 2);
            return true;
        }
        if (request == 1) {
            Intent intent = new Intent();
            intent.setType("image/*");
            intent.setAction("android.intent.action.GET_CONTENT");
            this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)this.getString(R.string.hockeyapp_feedback_select_picture)), 1);
            return true;
        }
        return false;
    }

    private void configureHints() {
        if (FeedbackManager.getRequireUserName() == FeedbackUserDataElement.REQUIRED) {
            this.mNameInput.setHint((CharSequence)this.getString(R.string.hockeyapp_feedback_name_hint_required));
        }
        if (FeedbackManager.getRequireUserEmail() == FeedbackUserDataElement.REQUIRED) {
            this.mEmailInput.setHint((CharSequence)this.getString(R.string.hockeyapp_feedback_email_hint_required));
        }
        this.mSubjectInput.setHint((CharSequence)this.getString(R.string.hockeyapp_feedback_subject_hint_required));
        this.mTextInput.setHint((CharSequence)this.getString(R.string.hockeyapp_feedback_message_hint_required));
    }

    private void configureAppropriateView() {
        if (this.mToken == null || this.mInSendFeedback) {
            this.configureFeedbackView(false);
        } else {
            this.configureFeedbackView(true);
            this.sendFetchFeedback(this.mUrl, null, null, null, null, null, null, this.mToken, this.mFeedbackHandler, true);
        }
    }

    private void createParseFeedbackTask(String feedbackResponseString, String requestType) {
        this.mParseFeedbackTask = new ParseFeedbackTask((Context)this, feedbackResponseString, this.mParseFeedbackHandler, requestType);
    }

    private void showKeyboard(View view) {
        InputMethodManager manager = (InputMethodManager)this.getSystemService("input_method");
        manager.showSoftInput(view, 1);
    }

    private void hideKeyboard() {
        if (this.mTextInput != null) {
            InputMethodManager manager = (InputMethodManager)this.getSystemService("input_method");
            manager.hideSoftInputFromWindow(this.mTextInput.getWindowToken(), 0);
        }
    }

    private void showError(int message) {
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).setTitle(R.string.hockeyapp_dialog_error_title).setMessage(message).setCancelable(false).setPositiveButton(R.string.hockeyapp_dialog_positive_button, null).create();
        alertDialog.show();
    }

    private void initFeedbackHandler() {
        this.mFeedbackHandler = new FeedbackHandler(this);
    }

    private void initParseFeedbackHandler() {
        this.mParseFeedbackHandler = new ParseFeedbackHandler(this);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private void loadFeedbackMessages(FeedbackResponse feedbackResponse) {
        this.configureFeedbackView(true);
        if (feedbackResponse != null && feedbackResponse.getFeedback() != null && feedbackResponse.getFeedback().getMessages() != null && feedbackResponse.getFeedback().getMessages().size() > 0) {
            ArrayList<FeedbackMessage> feedbackMessages = feedbackResponse.getFeedback().getMessages();
            Collections.reverse(feedbackMessages);
            try {
                SimpleDateFormat dateFormatIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
                dateFormatIn.setTimeZone(TimeZone.getTimeZone("UTC"));
                DateFormat dateFormatOut = DateFormat.getDateTimeInstance(3, 3);
                Date date = dateFormatIn.parse(feedbackMessages.get(0).getCreatedAt());
                this.mLastUpdatedTextView.setText((CharSequence)String.format(this.getString(R.string.hockeyapp_feedback_last_updated_text), dateFormatOut.format(date)));
                this.mLastUpdatedTextView.setContentDescription(this.mLastUpdatedTextView.getText());
                this.mLastUpdatedTextView.setVisibility(0);
            }
            catch (ParseException e1) {
                HockeyLog.error("Failed to parse feedback", e1);
            }
            if (this.mMessagesAdapter == null) {
                this.mMessagesAdapter = new MessagesAdapter(this.mContext, feedbackMessages);
            } else {
                this.mMessagesAdapter.clear();
                for (FeedbackMessage message : feedbackMessages) {
                    this.mMessagesAdapter.add(message);
                }
                this.mMessagesAdapter.notifyDataSetChanged();
            }
            this.mMessagesListView.setAdapter((ListAdapter)this.mMessagesAdapter);
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void resetFeedbackView() {
        this.mToken = null;
        AsyncTaskUtils.execute(new AsyncTask<Void, Object, Object>(){

            protected Object doInBackground(Void ... voids) {
                PrefsUtil.getInstance().saveFeedbackTokenToPrefs((Context)FeedbackActivity.this, null);
                FeedbackActivity.this.getSharedPreferences("net.hockeyapp.android.feedback", 0).edit().remove("idLastMessageSend").remove("idLastMessageProcessed").apply();
                return null;
            }
        });
        this.configureFeedbackView(false);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void sendFeedback() {
        if (!Util.isConnectedToNetwork((Context)this)) {
            Toast errorToast = Toast.makeText((Context)this, (int)R.string.hockeyapp_error_no_network_message, (int)1);
            errorToast.show();
            return;
        }
        this.enableDisableSendFeedbackButton(false);
        String token = this.mForceNewThread && !this.mInSendFeedback ? null : this.mToken;
        final String name = this.mNameInput.getText().toString().trim();
        final String email = this.mEmailInput.getText().toString().trim();
        final String subject = this.mSubjectInput.getText().toString().trim();
        String text = this.mTextInput.getText().toString().trim();
        if (TextUtils.isEmpty((CharSequence)subject)) {
            this.mSubjectInput.setVisibility(0);
            this.setError(this.mSubjectInput, R.string.hockeyapp_feedback_validate_subject_error);
        } else if (FeedbackManager.getRequireUserName() == FeedbackUserDataElement.REQUIRED && TextUtils.isEmpty((CharSequence)name)) {
            this.setError(this.mNameInput, R.string.hockeyapp_feedback_validate_name_error);
        } else if (FeedbackManager.getRequireUserEmail() == FeedbackUserDataElement.REQUIRED && TextUtils.isEmpty((CharSequence)email)) {
            this.setError(this.mEmailInput, R.string.hockeyapp_feedback_validate_email_empty);
        } else if (TextUtils.isEmpty((CharSequence)text)) {
            this.setError(this.mTextInput, R.string.hockeyapp_feedback_validate_text_error);
        } else if (FeedbackManager.getRequireUserEmail() == FeedbackUserDataElement.REQUIRED && !Util.isValidEmail(email)) {
            this.setError(this.mEmailInput, R.string.hockeyapp_feedback_validate_email_error);
        } else {
            AsyncTaskUtils.execute(new AsyncTask<Void, Object, Object>(){

                protected Object doInBackground(Void ... voids) {
                    PrefsUtil.getInstance().saveNameEmailSubjectToPrefs(FeedbackActivity.this.mContext, name, email, subject);
                    return null;
                }
            });
            ArrayList<Uri> attachmentUris = this.mAttachmentListView.getAttachments();
            this.sendFetchFeedback(this.mUrl, name, email, subject, text, this.mUserId, attachmentUris, token, this.mFeedbackHandler, false);
            this.hideKeyboard();
        }
    }

    private void setError(final EditText inputField, int feedbackStringId) {
        inputField.setError((CharSequence)this.getString(feedbackStringId));
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                inputField.requestFocus();
            }
        });
        this.enableDisableSendFeedbackButton(true);
    }

    private void sendFetchFeedback(String url, String name, String email, String subject, String text, String userId, List<Uri> attachmentUris, String token, Handler feedbackHandler, boolean isFetchMessages) {
        this.mSendFeedbackTask = new SendFeedbackTask(this.mContext, url, name, email, subject, text, userId, attachmentUris, token, feedbackHandler, isFetchMessages);
        AsyncTaskUtils.execute(this.mSendFeedbackTask);
    }

    private void startParseFeedbackTask(String feedbackResponseString, String requestType) {
        this.createParseFeedbackTask(feedbackResponseString, requestType);
        AsyncTaskUtils.execute(this.mParseFeedbackTask);
    }

    private static class ParseFeedbackHandler
    extends Handler {
        private final WeakReference<FeedbackActivity> mWeakFeedbackActivity;

        ParseFeedbackHandler(FeedbackActivity feedbackActivity) {
            this.mWeakFeedbackActivity = new WeakReference<FeedbackActivity>(feedbackActivity);
        }

        @SuppressLint(value={"StaticFieldLeak"})
        public void handleMessage(Message msg) {
            Bundle bundle;
            FeedbackResponse feedbackResponse;
            boolean success = false;
            final FeedbackActivity feedbackActivity = (FeedbackActivity)((Object)this.mWeakFeedbackActivity.get());
            if (feedbackActivity == null) {
                return;
            }
            if (msg != null && msg.getData() != null && (feedbackResponse = (FeedbackResponse)(bundle = msg.getData()).getSerializable("parse_feedback_response")) != null) {
                if (feedbackResponse.getStatus().equalsIgnoreCase("success")) {
                    success = true;
                    if (feedbackResponse.getToken() != null) {
                        feedbackActivity.mToken = feedbackResponse.getToken();
                        AsyncTaskUtils.execute(new AsyncTask<Void, Object, Object>(){

                            protected Object doInBackground(Void ... voids) {
                                PrefsUtil.getInstance().saveFeedbackTokenToPrefs((Context)feedbackActivity, feedbackResponse.getToken());
                                return null;
                            }
                        });
                        feedbackActivity.loadFeedbackMessages(feedbackResponse);
                        feedbackActivity.mInSendFeedback = false;
                    }
                } else {
                    success = false;
                }
            }
            if (!success) {
                feedbackActivity.showError(R.string.hockeyapp_dialog_error_message);
            }
            feedbackActivity.enableDisableSendFeedbackButton(true);
        }
    }

    private static class FeedbackHandler
    extends Handler {
        private final WeakReference<FeedbackActivity> mWeakFeedbackActivity;

        FeedbackHandler(FeedbackActivity feedbackActivity) {
            this.mWeakFeedbackActivity = new WeakReference<FeedbackActivity>(feedbackActivity);
        }

        public void handleMessage(Message msg) {
            boolean success = false;
            int errorMessage = 0;
            FeedbackActivity feedbackActivity = (FeedbackActivity)((Object)this.mWeakFeedbackActivity.get());
            if (feedbackActivity == null) {
                return;
            }
            if (msg != null && msg.getData() != null) {
                Bundle bundle = msg.getData();
                String responseString = bundle.getString("feedback_response");
                String statusCode = bundle.getString("feedback_status");
                String requestType = bundle.getString("request_type");
                if ("send".equals(requestType) && (responseString == null || Integer.parseInt(statusCode) != 201)) {
                    errorMessage = R.string.hockeyapp_feedback_send_generic_error;
                } else if ("fetch".equals(requestType) && statusCode != null && (Integer.parseInt(statusCode) == 404 || Integer.parseInt(statusCode) == 422)) {
                    feedbackActivity.resetFeedbackView();
                    success = true;
                } else if (responseString != null) {
                    feedbackActivity.startParseFeedbackTask(responseString, requestType);
                    if ("send".equals(requestType)) {
                        ArrayList<Uri> attachments = feedbackActivity.mAttachmentListView.getAttachments();
                        feedbackActivity.mInitialAttachments.removeAll(attachments);
                        Toast.makeText((Context)feedbackActivity, (int)R.string.hockeyapp_feedback_sent_toast, (int)1).show();
                    }
                    success = true;
                } else {
                    errorMessage = R.string.hockeyapp_feedback_send_network_error;
                }
            } else {
                errorMessage = R.string.hockeyapp_feedback_send_generic_error;
            }
            if (!success) {
                feedbackActivity.showError(errorMessage);
            }
            feedbackActivity.onSendFeedbackResult(success);
        }
    }
}

