/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.UUID;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.CrashManager;
import net.hockeyapp.android.CrashManagerListener;
import net.hockeyapp.android.objects.CrashDetails;
import net.hockeyapp.android.utils.HockeyLog;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private boolean mIgnoreDefaultHandler = false;
    private CrashManagerListener mCrashManagerListener;
    private Thread.UncaughtExceptionHandler mDefaultExceptionHandler;

    public ExceptionHandler(Thread.UncaughtExceptionHandler defaultExceptionHandler, CrashManagerListener listener, boolean ignoreDefaultHandler) {
        this.mDefaultExceptionHandler = defaultExceptionHandler;
        this.mIgnoreDefaultHandler = ignoreDefaultHandler;
        this.mCrashManagerListener = listener;
    }

    public void setListener(CrashManagerListener listener) {
        this.mCrashManagerListener = listener;
    }

    public static void saveException(Throwable exception, Thread thread, CrashManagerListener listener) {
        String deviceIdentifier;
        Context context;
        Date now = new Date();
        Date startDate = new Date(CrashManager.getInitializeTimestamp());
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        exception.printStackTrace(printWriter);
        Context context2 = context = CrashManager.weakContext != null ? (Context)CrashManager.weakContext.get() : null;
        if (context == null) {
            HockeyLog.error("Failed to save exception: context in CrashManager is null");
            return;
        }
        if (CrashManager.stackTracesCount >= 100) {
            HockeyLog.warn("ExceptionHandler: HockeyApp will not save this exception as there are already 100 or more unsent exceptions on disk");
            return;
        }
        String filename = UUID.randomUUID().toString();
        CrashDetails crashDetails = new CrashDetails(filename, exception);
        crashDetails.setAppPackage(Constants.APP_PACKAGE);
        crashDetails.setAppVersionCode(Constants.APP_VERSION);
        crashDetails.setAppVersionName(Constants.APP_VERSION_NAME);
        crashDetails.setAppStartDate(startDate);
        crashDetails.setAppCrashDate(now);
        if (listener == null || listener.includeDeviceData()) {
            crashDetails.setOsVersion(Constants.ANDROID_VERSION);
            crashDetails.setOsBuild(Constants.ANDROID_BUILD);
            crashDetails.setDeviceManufacturer(Constants.PHONE_MANUFACTURER);
            crashDetails.setDeviceModel(Constants.PHONE_MODEL);
        }
        if (thread != null && (listener == null || listener.includeThreadDetails())) {
            crashDetails.setThreadName(thread.getName() + "-" + thread.getId());
        }
        if ((deviceIdentifier = Constants.DEVICE_IDENTIFIER) != null && (listener == null || listener.includeDeviceIdentifier())) {
            crashDetails.setReporterKey(deviceIdentifier);
        }
        crashDetails.writeCrashReport(context);
        if (listener != null) {
            try {
                ExceptionHandler.writeValueToFile(context, ExceptionHandler.limitedString(listener.getUserID()), filename + ".user");
                ExceptionHandler.writeValueToFile(context, ExceptionHandler.limitedString(listener.getContact()), filename + ".contact");
                ExceptionHandler.writeValueToFile(context, listener.getDescription(), filename + ".description");
            }
            catch (IOException e) {
                HockeyLog.error("Error saving crash meta data!", e);
            }
        }
    }

    public static void saveNativeException(Throwable exception, String managedExceptionString, Thread thread, CrashManagerListener listener) {
        String[] splits;
        if (!TextUtils.isEmpty((CharSequence)managedExceptionString) && (splits = managedExceptionString.split("--- End of managed exception stack trace ---", 2)) != null && splits.length > 0) {
            managedExceptionString = splits[0];
        }
        ExceptionHandler.saveXamarinException(exception, thread, managedExceptionString, false, listener);
    }

    public static void saveManagedException(Throwable exception, Thread thread, CrashManagerListener listener) {
        ExceptionHandler.saveXamarinException(exception, thread, null, true, listener);
    }

    private static void saveXamarinException(Throwable exception, Thread thread, String additionalManagedException, Boolean isManagedException, CrashManagerListener listener) {
        String deviceIdentifier;
        Context context;
        Date startDate = new Date(CrashManager.getInitializeTimestamp());
        String filename = UUID.randomUUID().toString();
        Date now = new Date();
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        if (exception != null) {
            exception.printStackTrace(printWriter);
        }
        Context context2 = context = CrashManager.weakContext != null ? (Context)CrashManager.weakContext.get() : null;
        if (context == null) {
            HockeyLog.error("Failed to save exception: context in CrashManager is null");
            return;
        }
        CrashDetails crashDetails = new CrashDetails(filename, exception, additionalManagedException, isManagedException);
        crashDetails.setAppPackage(Constants.APP_PACKAGE);
        crashDetails.setAppVersionCode(Constants.APP_VERSION);
        crashDetails.setAppVersionName(Constants.APP_VERSION_NAME);
        crashDetails.setAppStartDate(startDate);
        crashDetails.setAppCrashDate(now);
        if (listener == null || listener.includeDeviceData()) {
            crashDetails.setOsVersion(Constants.ANDROID_VERSION);
            crashDetails.setOsBuild(Constants.ANDROID_BUILD);
            crashDetails.setDeviceManufacturer(Constants.PHONE_MANUFACTURER);
            crashDetails.setDeviceModel(Constants.PHONE_MODEL);
        }
        if (thread != null && (listener == null || listener.includeThreadDetails())) {
            crashDetails.setThreadName(thread.getName() + "-" + thread.getId());
        }
        if ((deviceIdentifier = Constants.DEVICE_IDENTIFIER) != null && (listener == null || listener.includeDeviceIdentifier())) {
            crashDetails.setReporterKey(deviceIdentifier);
        }
        crashDetails.writeCrashReport(context);
        if (listener != null) {
            try {
                ExceptionHandler.writeValueToFile(context, ExceptionHandler.limitedString(listener.getUserID()), filename + ".user");
                ExceptionHandler.writeValueToFile(context, ExceptionHandler.limitedString(listener.getContact()), filename + ".contact");
                ExceptionHandler.writeValueToFile(context, listener.getDescription(), filename + ".description");
            }
            catch (IOException e) {
                HockeyLog.error("Error saving crash meta data!", e);
            }
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        Context context;
        Context context2 = context = CrashManager.weakContext != null ? (Context)CrashManager.weakContext.get() : null;
        if (context == null || context.getFilesDir() == null) {
            this.mDefaultExceptionHandler.uncaughtException(thread, exception);
        } else {
            ExceptionHandler.saveException(exception, thread, this.mCrashManagerListener);
            if (!this.mIgnoreDefaultHandler) {
                this.mDefaultExceptionHandler.uncaughtException(thread, exception);
            } else {
                Process.killProcess((int)Process.myPid());
                System.exit(10);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeValueToFile(Context context, String value, String filename) throws IOException {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        try (BufferedWriter writer = null;){
            File file = new File(context.getFilesDir(), filename);
            if (!TextUtils.isEmpty((CharSequence)value) && TextUtils.getTrimmedLength((CharSequence)value) > 0) {
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(value);
                writer.flush();
            }
        }
    }

    private static String limitedString(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2) && string2.length() > 255) {
            string2 = string2.substring(0, 255);
        }
        return string2;
    }
}

