/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.CrashManagerListener;
import net.hockeyapp.android.ExceptionHandler;
import net.hockeyapp.android.R;
import net.hockeyapp.android.objects.CrashDetails;
import net.hockeyapp.android.objects.CrashManagerUserInput;
import net.hockeyapp.android.objects.CrashMetaData;
import net.hockeyapp.android.utils.AsyncTaskUtils;
import net.hockeyapp.android.utils.HockeyLog;
import net.hockeyapp.android.utils.HttpURLConnectionBuilder;
import net.hockeyapp.android.utils.Util;

public class CrashManager {
    private static String identifier = null;
    static WeakReference<Context> weakContext;
    private static String urlString;
    private static long initializeTimestamp;
    private static boolean didCrashInLastSession;
    static int stackTracesCount;
    static CountDownLatch latch;
    private static final String ALWAYS_SEND_KEY = "always_send_crash_reports";
    private static final String PREFERENCES_NAME = "HockeySDK";
    private static final String CONFIRMED_FILENAMES_KEY = "ConfirmedFilenames";
    static final int MAX_NUMBER_OF_CRASHFILES = 100;
    private static final int STACK_TRACES_FOUND_NONE = 0;
    private static final int STACK_TRACES_FOUND_NEW = 1;
    private static final int STACK_TRACES_FOUND_CONFIRMED = 2;
    private static final FilenameFilter STACK_TRACES_FILTER;

    public static void register(Context context) {
        String appIdentifier = Util.getAppIdentifier(context);
        CrashManager.register(context, appIdentifier);
    }

    public static void register(Context context, CrashManagerListener listener) {
        String appIdentifier = Util.getAppIdentifier(context);
        CrashManager.register(context, appIdentifier, listener);
    }

    public static void register(Context context, String appIdentifier) {
        CrashManager.register(context, "https://sdk.hockeyapp.net/", appIdentifier, null);
    }

    public static void register(Context context, String appIdentifier, CrashManagerListener listener) {
        CrashManager.register(context, "https://sdk.hockeyapp.net/", appIdentifier, listener);
    }

    public static void register(Context context, String urlString, String appIdentifier, CrashManagerListener listener) {
        CrashManager.initialize(context, urlString, appIdentifier, listener, false);
        CrashManager.execute(context, listener);
    }

    public static void initialize(Context context, String appIdentifier, CrashManagerListener listener) {
        CrashManager.initialize(context, "https://sdk.hockeyapp.net/", appIdentifier, listener, true);
    }

    public static void initialize(Context context, String urlString, String appIdentifier, CrashManagerListener listener) {
        CrashManager.initialize(context, urlString, appIdentifier, listener, true);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    public static void execute(Context context, final CrashManagerListener listener) {
        final WeakReference<Context> weakContext = new WeakReference<Context>(context);
        AsyncTaskUtils.execute(new AsyncTask<Void, Object, Integer>(){
            private boolean autoSend = false;

            protected Integer doInBackground(Void ... voids) {
                int foundOrSend;
                Context context = (Context)weakContext.get();
                if (context != null) {
                    SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
                    this.autoSend |= prefs.getBoolean(CrashManager.ALWAYS_SEND_KEY, false);
                }
                didCrashInLastSession = (foundOrSend = CrashManager.hasStackTraces(weakContext)) == 1;
                latch.countDown();
                return foundOrSend;
            }

            protected void onPostExecute(Integer foundOrSend) {
                boolean ignoreDefaultHandler;
                boolean autoSend = this.autoSend;
                boolean bl = ignoreDefaultHandler = listener != null && listener.ignoreDefaultHandler();
                if (foundOrSend == 1) {
                    if (listener != null) {
                        autoSend |= listener.shouldAutoUploadCrashes();
                        listener.onNewCrashesFound();
                    }
                    if (autoSend || !CrashManager.showDialog(weakContext, listener, ignoreDefaultHandler)) {
                        CrashManager.sendCrashes(weakContext, listener, ignoreDefaultHandler, null);
                    }
                } else if (foundOrSend == 2) {
                    if (listener != null) {
                        listener.onConfirmedCrashesFound();
                    }
                    CrashManager.sendCrashes(weakContext, listener, ignoreDefaultHandler, null);
                } else if (foundOrSend == 0) {
                    if (listener != null) {
                        listener.onNoCrashesFound();
                    }
                    CrashManager.registerHandler(listener, ignoreDefaultHandler);
                }
            }
        });
    }

    public static int hasStackTraces(WeakReference<Context> weakContext) {
        String[] filenames = CrashManager.searchForStackTraces(weakContext);
        List<String> confirmedFilenames = null;
        int result = 0;
        if (filenames != null && filenames.length > 0) {
            try {
                Context context;
                Context context2 = context = weakContext != null ? (Context)weakContext.get() : null;
                if (context != null) {
                    SharedPreferences preferences = context.getSharedPreferences(PREFERENCES_NAME, 0);
                    confirmedFilenames = Arrays.asList(preferences.getString(CONFIRMED_FILENAMES_KEY, "").split("\\|"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (confirmedFilenames != null) {
                result = 2;
                for (String filename : filenames) {
                    if (confirmedFilenames.contains(filename)) continue;
                    result = 1;
                    break;
                }
            } else {
                result = 1;
            }
        }
        return result;
    }

    public static Future<Boolean> didCrashInLastSession() {
        return AsyncTaskUtils.execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                latch.await();
                return didCrashInLastSession;
            }
        });
    }

    public static Future<CrashDetails> getLastCrashDetails(Context context) {
        final WeakReference<Context> weakContext = new WeakReference<Context>(context);
        return AsyncTaskUtils.execute(new Callable<CrashDetails>(){

            @Override
            public CrashDetails call() throws Exception {
                latch.await();
                if (!didCrashInLastSession) {
                    return null;
                }
                Context context = (Context)weakContext.get();
                if (context == null) {
                    return null;
                }
                File dir = context.getFilesDir();
                if (dir == null) {
                    return null;
                }
                File[] files = dir.listFiles(STACK_TRACES_FILTER);
                stackTracesCount = files != null ? files.length : 0;
                long lastModification = 0L;
                File lastModifiedFile = null;
                CrashDetails result = null;
                if (files != null) {
                    for (File file : files) {
                        if (file.lastModified() <= lastModification) continue;
                        lastModification = file.lastModified();
                        lastModifiedFile = file;
                    }
                }
                if (lastModifiedFile != null && lastModifiedFile.exists()) {
                    try {
                        result = CrashDetails.fromFile(lastModifiedFile);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return result;
            }
        });
    }

    public static void submitStackTraces(WeakReference<Context> weakContext, CrashManagerListener listener) {
        CrashManager.submitStackTraces(weakContext, listener, null);
    }

    public static synchronized void submitStackTraces(WeakReference<Context> weakContext, CrashManagerListener listener, CrashMetaData crashMetaData) {
        String[] list = CrashManager.searchForStackTraces(weakContext);
        if (list != null && list.length > 0) {
            HockeyLog.debug("Found " + list.length + " stacktrace(s).");
            if (list.length > 100) {
                CrashManager.deleteRedundantStackTraces(weakContext);
                list = CrashManager.searchForStackTraces(weakContext);
                if (list == null) {
                    return;
                }
            }
            for (String file : list) {
                CrashManager.submitStackTrace(weakContext, file, listener, crashMetaData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void submitStackTrace(WeakReference<Context> weakContext, String filename, CrashManagerListener listener, CrashMetaData crashMetaData) {
        Boolean successful = false;
        HttpURLConnection urlConnection = null;
        try {
            String stacktrace = CrashManager.contentsOfFile(weakContext, filename);
            if (stacktrace.length() > 0) {
                String description;
                HockeyLog.debug("Transmitting crash data: \n" + stacktrace);
                String userID = CrashManager.contentsOfFile(weakContext, filename.replace(".stacktrace", ".user"));
                String contact = CrashManager.contentsOfFile(weakContext, filename.replace(".stacktrace", ".contact"));
                if (crashMetaData != null) {
                    String crashMetaDataContact;
                    String crashMetaDataUserID = crashMetaData.getUserID();
                    if (!TextUtils.isEmpty((CharSequence)crashMetaDataUserID)) {
                        userID = crashMetaDataUserID;
                    }
                    if (!TextUtils.isEmpty((CharSequence)(crashMetaDataContact = crashMetaData.getUserEmail()))) {
                        contact = crashMetaDataContact;
                    }
                }
                String applicationLog = CrashManager.contentsOfFile(weakContext, filename.replace(".stacktrace", ".description"));
                String string2 = description = crashMetaData != null ? crashMetaData.getUserDescription() : "";
                if (!TextUtils.isEmpty((CharSequence)applicationLog)) {
                    description = !TextUtils.isEmpty((CharSequence)description) ? String.format("%s\n\nLog:\n%s", description, applicationLog) : String.format("Log:\n%s", applicationLog);
                }
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("raw", stacktrace);
                parameters.put("userID", userID);
                parameters.put("contact", contact);
                parameters.put("description", description);
                parameters.put("sdk", PREFERENCES_NAME);
                parameters.put("sdk_version", "5.1.0");
                urlConnection = new HttpURLConnectionBuilder(CrashManager.getURLString()).setRequestMethod("POST").writeFormFields(parameters).build();
                int responseCode = urlConnection.getResponseCode();
                successful = responseCode == 202 || responseCode == 201;
            }
        }
        catch (Exception e) {
            HockeyLog.error("Failed to transmit crash data", e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            if (successful.booleanValue()) {
                HockeyLog.debug("Transmission succeeded");
                CrashManager.deleteStackTrace(weakContext, filename);
                if (listener != null) {
                    listener.onCrashesSent();
                    CrashManager.deleteRetryCounter(weakContext, filename);
                }
            } else {
                HockeyLog.debug("Transmission failed, will retry on next register() call");
                if (listener != null) {
                    listener.onCrashesNotSent();
                    CrashManager.updateRetryCounter(weakContext, filename, listener.getMaxRetryAttempts());
                }
            }
        }
    }

    public static void deleteStackTraces(WeakReference<Context> weakContext) {
        String[] list = CrashManager.searchForStackTraces(weakContext);
        if (list != null && list.length > 0) {
            HockeyLog.debug("Found " + list.length + " stacktrace(s).");
            for (String file : list) {
                try {
                    if (weakContext == null) continue;
                    HockeyLog.debug("Delete stacktrace " + file + ".");
                    CrashManager.deleteStackTrace(weakContext, file);
                }
                catch (Exception e) {
                    HockeyLog.error("Failed to delete stacktrace", e);
                }
            }
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    public static boolean handleUserInput(CrashManagerUserInput userInput, CrashMetaData userProvidedMetaData, CrashManagerListener listener, final WeakReference<Context> weakContext, boolean ignoreDefaultHandler) {
        switch (userInput) {
            case CrashManagerUserInputDontSend: {
                if (listener != null) {
                    listener.onUserDeniedCrashes();
                }
                CrashManager.registerHandler(listener, ignoreDefaultHandler);
                AsyncTaskUtils.execute(new AsyncTask<Void, Object, Object>(){

                    protected Object doInBackground(Void ... voids) {
                        CrashManager.deleteStackTraces(weakContext);
                        return null;
                    }
                });
                return true;
            }
            case CrashManagerUserInputAlwaysSend: {
                Context context;
                Context context2 = context = weakContext != null ? (Context)weakContext.get() : null;
                if (context == null) {
                    return false;
                }
                SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
                prefs.edit().putBoolean(ALWAYS_SEND_KEY, true).apply();
                CrashManager.sendCrashes(weakContext, listener, ignoreDefaultHandler, userProvidedMetaData);
                return true;
            }
            case CrashManagerUserInputSend: {
                CrashManager.sendCrashes(weakContext, listener, ignoreDefaultHandler, userProvidedMetaData);
                return true;
            }
        }
        return false;
    }

    public static void resetAlwaysSend(WeakReference<Context> weakContext) {
        Context context;
        Context context2 = context = weakContext != null ? (Context)weakContext.get() : null;
        if (context != null) {
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            prefs.edit().remove(ALWAYS_SEND_KEY).apply();
        }
    }

    private static void initialize(Context context, String urlString, String appIdentifier, CrashManagerListener listener, boolean registerHandler) {
        if (context != null) {
            if (initializeTimestamp == 0L) {
                initializeTimestamp = System.currentTimeMillis();
            }
            CrashManager.urlString = urlString;
            identifier = Util.sanitizeAppIdentifier(appIdentifier);
            didCrashInLastSession = false;
            weakContext = new WeakReference<Context>(context);
            Constants.loadFromContext(context);
            if (identifier == null) {
                identifier = Constants.APP_PACKAGE;
            }
            if (registerHandler) {
                boolean ignoreDefaultHandler = listener != null && listener.ignoreDefaultHandler();
                CrashManager.registerHandler(listener, ignoreDefaultHandler);
            }
        }
    }

    private static boolean showDialog(final WeakReference<Context> weakContext, final CrashManagerListener listener, final boolean ignoreDefaultHandler) {
        Context context;
        if (listener != null && listener.onHandleAlertView()) {
            return true;
        }
        Context context2 = context = weakContext != null ? (Context)weakContext.get() : null;
        if (context == null || !(context instanceof Activity)) {
            return false;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        String alertTitle = CrashManager.getAlertTitle(context);
        builder.setTitle((CharSequence)alertTitle);
        builder.setMessage(R.string.hockeyapp_crash_dialog_message);
        builder.setNegativeButton(R.string.hockeyapp_crash_dialog_negative_button, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CrashManager.handleUserInput(CrashManagerUserInput.CrashManagerUserInputDontSend, null, listener, weakContext, ignoreDefaultHandler);
            }
        });
        builder.setNeutralButton(R.string.hockeyapp_crash_dialog_neutral_button, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CrashManager.handleUserInput(CrashManagerUserInput.CrashManagerUserInputAlwaysSend, null, listener, weakContext, ignoreDefaultHandler);
            }
        });
        builder.setPositiveButton(R.string.hockeyapp_crash_dialog_positive_button, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CrashManager.handleUserInput(CrashManagerUserInput.CrashManagerUserInputSend, null, listener, weakContext, ignoreDefaultHandler);
            }
        });
        builder.create().show();
        return true;
    }

    private static String getAlertTitle(Context context) {
        return context.getString(R.string.hockeyapp_crash_dialog_title, new Object[]{Util.getAppName(context)});
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private static void sendCrashes(final WeakReference<Context> weakContext, final CrashManagerListener listener, boolean ignoreDefaultHandler, final CrashMetaData crashMetaData) {
        boolean isConnectedToNetwork;
        CrashManager.registerHandler(listener, ignoreDefaultHandler);
        Context context = weakContext != null ? (Context)weakContext.get() : null;
        boolean bl = isConnectedToNetwork = context != null && Util.isConnectedToNetwork(context);
        if (!isConnectedToNetwork && listener != null) {
            listener.onCrashesNotSent();
        }
        AsyncTaskUtils.execute(new AsyncTask<Void, Object, Object>(){

            protected Object doInBackground(Void ... voids) {
                String[] list = CrashManager.searchForStackTraces(weakContext);
                if (list != null && list.length > 0) {
                    HockeyLog.debug("Found " + list.length + " stacktrace(s).");
                    if (list.length > 100) {
                        CrashManager.deleteRedundantStackTraces(weakContext);
                        list = CrashManager.searchForStackTraces(weakContext);
                        if (list == null) {
                            return null;
                        }
                    }
                    CrashManager.saveConfirmedStackTraces(weakContext, list);
                    if (isConnectedToNetwork) {
                        for (String file : list) {
                            CrashManager.submitStackTrace(weakContext, file, listener, crashMetaData);
                        }
                    }
                }
                return null;
            }
        });
    }

    private static void registerHandler(CrashManagerListener listener, boolean ignoreDefaultHandler) {
        if (!TextUtils.isEmpty((CharSequence)Constants.APP_VERSION) && !TextUtils.isEmpty((CharSequence)Constants.APP_PACKAGE)) {
            Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
            if (currentHandler != null) {
                HockeyLog.debug("Current handler class = " + currentHandler.getClass().getName());
            }
            if (currentHandler instanceof ExceptionHandler) {
                ((ExceptionHandler)currentHandler).setListener(listener);
            } else {
                Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(currentHandler, listener, ignoreDefaultHandler));
            }
        } else {
            HockeyLog.debug("Exception handler not set because version or package is null.");
        }
    }

    private static String getURLString() {
        return urlString + "api/2/apps/" + identifier + "/crashes/";
    }

    private static void updateRetryCounter(WeakReference<Context> weakContext, String filename, int maxRetryAttempts) {
        Context context;
        if (maxRetryAttempts == -1) {
            return;
        }
        Context context2 = context = weakContext != null ? (Context)weakContext.get() : null;
        if (context != null) {
            SharedPreferences preferences = context.getSharedPreferences(PREFERENCES_NAME, 0);
            SharedPreferences.Editor editor = preferences.edit();
            int retryCounter = preferences.getInt("RETRY_COUNT: " + filename, 0);
            if (retryCounter >= maxRetryAttempts) {
                CrashManager.deleteStackTrace(weakContext, filename);
                CrashManager.deleteRetryCounter(weakContext, filename);
            } else {
                editor.putInt("RETRY_COUNT: " + filename, retryCounter + 1);
                editor.apply();
            }
        }
    }

    private static void deleteRetryCounter(WeakReference<Context> weakContext, String filename) {
        Context context;
        Context context2 = context = weakContext != null ? (Context)weakContext.get() : null;
        if (context != null) {
            SharedPreferences preferences = context.getSharedPreferences(PREFERENCES_NAME, 0);
            SharedPreferences.Editor editor = preferences.edit();
            editor.remove("RETRY_COUNT: " + filename);
            editor.apply();
        }
    }

    private static void deleteStackTrace(WeakReference<Context> weakContext, String filename) {
        Context context;
        Context context2 = context = weakContext != null ? (Context)weakContext.get() : null;
        if (context != null) {
            context.deleteFile(filename);
            String user = filename.replace(".stacktrace", ".user");
            context.deleteFile(user);
            String contact = filename.replace(".stacktrace", ".contact");
            context.deleteFile(contact);
            String description = filename.replace(".stacktrace", ".description");
            context.deleteFile(description);
            --stackTracesCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String contentsOfFile(WeakReference<Context> weakContext, String filename) {
        Context context;
        Context context2 = context = weakContext != null ? (Context)weakContext.get() : null;
        if (context != null) {
            File file = context.getFileStreamPath(filename);
            if (file == null || !file.exists()) {
                return "";
            }
            StringBuilder contents = new StringBuilder();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(context.openFileInput(filename)));
                while ((line = reader.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            catch (IOException e) {
                HockeyLog.error("Failed to read content of " + filename, e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return contents.toString();
        }
        return "";
    }

    private static void saveConfirmedStackTraces(WeakReference<Context> weakContext, String[] stackTraces) {
        Context context;
        Context context2 = context = weakContext != null ? (Context)weakContext.get() : null;
        if (context != null) {
            try {
                SharedPreferences preferences = context.getSharedPreferences(PREFERENCES_NAME, 0);
                SharedPreferences.Editor editor = preferences.edit();
                editor.putString(CONFIRMED_FILENAMES_KEY, TextUtils.join((CharSequence)",", (Object[])stackTraces));
                editor.apply();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static String[] searchForStackTraces(WeakReference<Context> weakContext) {
        Context context;
        Context context2 = context = weakContext != null ? (Context)weakContext.get() : null;
        if (context != null) {
            File dir = context.getFilesDir();
            if (dir != null) {
                HockeyLog.debug("Looking for exceptions in: " + dir.getAbsolutePath());
                if (!dir.exists() && !dir.mkdir()) {
                    return new String[0];
                }
                String[] list = dir.list(STACK_TRACES_FILTER);
                stackTracesCount = list != null ? list.length : 0;
                return list;
            }
            HockeyLog.debug("Can't search for exception as file path is null.");
        }
        return null;
    }

    private static void deleteRedundantStackTraces(WeakReference<Context> weakContext) {
        Context context;
        Context context2 = context = weakContext != null ? (Context)weakContext.get() : null;
        if (context != null) {
            File dir = context.getFilesDir();
            if (dir == null || !dir.exists()) {
                return;
            }
            File[] files = dir.listFiles(STACK_TRACES_FILTER);
            if (files.length <= 100) {
                return;
            }
            HockeyLog.debug("Delete " + (files.length - 100) + " redundant stacktrace(s).");
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return Long.valueOf(file1.lastModified()).compareTo(file2.lastModified());
                }
            });
            for (int i = 0; i < files.length - 100; ++i) {
                CrashManager.deleteStackTrace(weakContext, files[i].getName());
            }
        }
    }

    public static long getInitializeTimestamp() {
        return initializeTimestamp;
    }

    static {
        urlString = null;
        didCrashInLastSession = false;
        stackTracesCount = 0;
        latch = new CountDownLatch(1);
        STACK_TRACES_FILTER = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".stacktrace");
            }
        };
    }
}

