/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.transition.ViewGroupOverlay;
import android.support.v4.view.ViewCompat;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

@RequiresApi(value=14)
@TargetApi(value=14)
class ViewOverlay {
    protected OverlayViewGroup mOverlayViewGroup;

    ViewOverlay(Context context, ViewGroup hostView, View requestingView) {
        this.mOverlayViewGroup = new OverlayViewGroup(context, hostView, requestingView, this);
    }

    static ViewGroup getContentView(View view) {
        View parent = view;
        while (parent != null) {
            if (parent.getId() == 0x1020002 && parent instanceof ViewGroup) {
                return (ViewGroup)parent;
            }
            if (!(parent.getParent() instanceof ViewGroup)) continue;
            parent = (ViewGroup)parent.getParent();
        }
        return null;
    }

    public static ViewOverlay createFrom(View view) {
        ViewGroup contentView = ViewOverlay.getContentView(view);
        if (contentView != null) {
            int numChildren = contentView.getChildCount();
            for (int i = 0; i < numChildren; ++i) {
                View child = contentView.getChildAt(i);
                if (!(child instanceof OverlayViewGroup)) continue;
                return ((OverlayViewGroup)child).mViewOverlay;
            }
            return new ViewGroupOverlay(contentView.getContext(), contentView, view);
        }
        return null;
    }

    ViewGroup getOverlayView() {
        return this.mOverlayViewGroup;
    }

    public void add(Drawable drawable) {
        this.mOverlayViewGroup.add(drawable);
    }

    public void remove(Drawable drawable) {
        this.mOverlayViewGroup.remove(drawable);
    }

    public void clear() {
        this.mOverlayViewGroup.clear();
    }

    boolean isEmpty() {
        return this.mOverlayViewGroup.isEmpty();
    }

    static class OverlayViewGroup
    extends ViewGroup {
        static Method sInvalidateChildInParentFastMethod;
        ViewGroup mHostView;
        View mRequestingView;
        ArrayList<Drawable> mDrawables = null;
        ViewOverlay mViewOverlay;

        OverlayViewGroup(Context context, ViewGroup hostView, View requestingView, ViewOverlay viewOverlay) {
            super(context);
            this.mHostView = hostView;
            this.mRequestingView = requestingView;
            this.setRight(hostView.getWidth());
            this.setBottom(hostView.getHeight());
            hostView.addView((View)this);
            this.mViewOverlay = viewOverlay;
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            return false;
        }

        public void add(Drawable drawable) {
            if (this.mDrawables == null) {
                this.mDrawables = new ArrayList();
            }
            if (!this.mDrawables.contains(drawable)) {
                this.mDrawables.add(drawable);
                this.invalidate(drawable.getBounds());
                drawable.setCallback((Drawable.Callback)this);
            }
        }

        public void remove(Drawable drawable) {
            if (this.mDrawables != null) {
                this.mDrawables.remove(drawable);
                this.invalidate(drawable.getBounds());
                drawable.setCallback(null);
            }
        }

        protected boolean verifyDrawable(Drawable who) {
            return super.verifyDrawable(who) || this.mDrawables != null && this.mDrawables.contains(who);
        }

        public void add(View child) {
            if (child.getParent() instanceof ViewGroup) {
                ViewGroup parent = (ViewGroup)child.getParent();
                if (parent != this.mHostView && parent.getParent() != null) {
                    int[] parentLocation = new int[2];
                    int[] hostViewLocation = new int[2];
                    parent.getLocationOnScreen(parentLocation);
                    this.mHostView.getLocationOnScreen(hostViewLocation);
                    ViewCompat.offsetLeftAndRight((View)child, (int)(parentLocation[0] - hostViewLocation[0]));
                    ViewCompat.offsetTopAndBottom((View)child, (int)(parentLocation[1] - hostViewLocation[1]));
                }
                parent.removeView(child);
                if (child.getParent() != null) {
                    parent.removeView(child);
                }
            }
            super.addView(child, this.getChildCount() - 1);
        }

        public void remove(View view) {
            super.removeView(view);
            if (this.isEmpty()) {
                this.mHostView.removeView((View)this);
            }
        }

        public void clear() {
            this.removeAllViews();
            if (this.mDrawables != null) {
                this.mDrawables.clear();
            }
        }

        boolean isEmpty() {
            return this.getChildCount() == 0 && (this.mDrawables == null || this.mDrawables.size() == 0);
        }

        public void invalidateDrawable(Drawable drawable) {
            this.invalidate(drawable.getBounds());
        }

        protected void dispatchDraw(Canvas canvas) {
            int[] contentViewLocation = new int[2];
            int[] hostViewLocation = new int[2];
            ViewGroup parent = (ViewGroup)this.getParent();
            this.mHostView.getLocationOnScreen(contentViewLocation);
            this.mRequestingView.getLocationOnScreen(hostViewLocation);
            canvas.translate((float)(hostViewLocation[0] - contentViewLocation[0]), (float)(hostViewLocation[1] - contentViewLocation[1]));
            canvas.clipRect(new Rect(0, 0, this.mRequestingView.getWidth(), this.mRequestingView.getHeight()));
            super.dispatchDraw(canvas);
            int numDrawables = this.mDrawables == null ? 0 : this.mDrawables.size();
            for (int i = 0; i < numDrawables; ++i) {
                this.mDrawables.get(i).draw(canvas);
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
        }

        private void getOffset(int[] offset) {
            int[] contentViewLocation = new int[2];
            int[] hostViewLocation = new int[2];
            ViewGroup parent = (ViewGroup)this.getParent();
            this.mHostView.getLocationOnScreen(contentViewLocation);
            this.mRequestingView.getLocationOnScreen(hostViewLocation);
            offset[0] = hostViewLocation[0] - contentViewLocation[0];
            offset[1] = hostViewLocation[1] - contentViewLocation[1];
        }

        public void invalidateChildFast(View child, Rect dirty) {
            if (this.mHostView != null) {
                int left = child.getLeft();
                int top = child.getTop();
                int[] offset = new int[2];
                this.getOffset(offset);
                dirty.offset(left + offset[0], top + offset[1]);
                this.mHostView.invalidate(dirty);
            }
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        protected ViewParent invalidateChildInParentFast(int left, int top, Rect dirty) {
            if (this.mHostView instanceof ViewGroup && sInvalidateChildInParentFastMethod != null) {
                try {
                    int[] offset = new int[2];
                    this.getOffset(offset);
                    sInvalidateChildInParentFastMethod.invoke((Object)this.mHostView, left, top, dirty);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
            if (this.mHostView != null) {
                dirty.offset(location[0], location[1]);
                if (this.mHostView instanceof ViewGroup) {
                    location[0] = 0;
                    location[1] = 0;
                    int[] offset = new int[2];
                    this.getOffset(offset);
                    dirty.offset(offset[0], offset[1]);
                    return super.invalidateChildInParent(location, dirty);
                }
                this.invalidate(dirty);
            }
            return null;
        }

        static {
            try {
                sInvalidateChildInParentFastMethod = ViewGroup.class.getDeclaredMethod("invalidateChildInParentFast", Integer.TYPE, Integer.TYPE, Rect.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        static class TouchInterceptor
        extends View {
            TouchInterceptor(Context context) {
                super(context);
            }
        }
    }
}

