/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.annotation.TargetApi;
import android.support.annotation.RequiresApi;
import android.support.transition.SceneWrapper;
import android.transition.Scene;
import android.view.View;
import android.view.ViewGroup;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RequiresApi(value=19)
@TargetApi(value=19)
class SceneKitKat
extends SceneWrapper {
    private static Field sEnterAction;
    private static Method sSetCurrentScene;
    private View mLayout;

    SceneKitKat() {
    }

    @Override
    public void init(ViewGroup sceneRoot) {
        this.mScene = new Scene(sceneRoot);
    }

    @Override
    public void init(ViewGroup sceneRoot, View layout) {
        if (layout instanceof ViewGroup) {
            this.mScene = new Scene(sceneRoot, (ViewGroup)layout);
        } else {
            this.mScene = new Scene(sceneRoot);
            this.mLayout = layout;
        }
    }

    @Override
    public void enter() {
        if (this.mLayout != null) {
            ViewGroup root = this.getSceneRoot();
            root.removeAllViews();
            root.addView(this.mLayout);
            this.invokeEnterAction();
            this.updateCurrentScene((View)root);
        } else {
            this.mScene.enter();
        }
    }

    private void invokeEnterAction() {
        if (sEnterAction == null) {
            try {
                sEnterAction = Scene.class.getDeclaredField("mEnterAction");
                sEnterAction.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Runnable enterAction = (Runnable)sEnterAction.get(this.mScene);
            if (enterAction != null) {
                enterAction.run();
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateCurrentScene(View view) {
        if (sSetCurrentScene == null) {
            try {
                sSetCurrentScene = Scene.class.getDeclaredMethod("setCurrentScene", View.class, Scene.class);
                sSetCurrentScene.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            sSetCurrentScene.invoke(null, view, this.mScene);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

