/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.location.zzn;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class LocationResult
extends zza
implements ReflectedParcelable {
    static final List<Location> zzbjZ = Collections.emptyList();
    private final List<Location> zzbka;
    public static final Parcelable.Creator<LocationResult> CREATOR = new zzn();

    public static LocationResult create(List<Location> list) {
        if (list == null) {
            list = zzbjZ;
        }
        return new LocationResult(list);
    }

    LocationResult(List<Location> list) {
        this.zzbka = list;
    }

    public Location getLastLocation() {
        int n = this.zzbka.size();
        if (n == 0) {
            return null;
        }
        return this.zzbka.get(n - 1);
    }

    @NonNull
    public List<Location> getLocations() {
        return this.zzbka;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzn.zza(this, parcel, n);
    }

    public int hashCode() {
        int n = 17;
        for (Location location : this.zzbka) {
            long l = location.getTime();
            int n2 = (int)(l ^ l >>> 32);
            n = 31 * n + n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocationResult)) {
            return false;
        }
        LocationResult locationResult = (LocationResult)((Object)object);
        if (locationResult.zzbka.size() != this.zzbka.size()) {
            return false;
        }
        Iterator<Location> iterator = locationResult.zzbka.iterator();
        Iterator<Location> iterator2 = this.zzbka.iterator();
        while (iterator.hasNext()) {
            Location location = iterator2.next();
            Location location2 = iterator.next();
            if (location.getTime() == location2.getTime()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = String.valueOf(this.zzbka);
        return new StringBuilder(27 + String.valueOf(string).length()).append("LocationResult[locations: ").append(string).append("]").toString();
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }

    public static LocationResult extractResult(Intent intent) {
        if (!LocationResult.hasResult(intent)) {
            return null;
        }
        return (LocationResult)intent.getExtras().getParcelable("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }
}

